/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.appwork.utils.Regex;
import org.appwork.utils.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLParser {
    public static ArrayList<String> findUrls(String source) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            String[] stringArray = new Regex(source, "\\(?\\b(ftp://|https?://)[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]").getColumn(-1);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String link = stringArray[n2];
                try {
                    if (link != null) {
                        link = link.trim();
                    }
                    new URL(link);
                    if (!ret.contains(link)) {
                        ret.add(link);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Log.exception((Throwable)e);
        }
        return HTMLParser.removeDuplicates(ret);
    }

    public static ArrayList<String> removeDuplicates(ArrayList<String> links) {
        ArrayList<String> tmplinks = new ArrayList<String>();
        if (links == null || links.size() == 0) {
            return tmplinks;
        }
        for (String link : links) {
            if (link.contains("...")) {
                String check = link.substring(0, link.indexOf("..."));
                String found = link;
                for (String link2 : links) {
                    if (!link2.startsWith(check) || link2.contains("...")) continue;
                    found = link2;
                    break;
                }
                if (tmplinks.contains(found)) continue;
                tmplinks.add(found);
                continue;
            }
            tmplinks.add(link);
        }
        return tmplinks;
    }
}

