/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import org.appwork.utils.zip.ZipIOException;
import org.appwork.utils.zip.ZipIOReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipIOFile {
    private final String name;
    private final ZipEntry file;
    private final ZipIOReader zipFile;
    private final ZipIOFile parent;
    private final boolean isFile;
    private ArrayList<ZipIOFile> files = new ArrayList();

    protected ZipIOFile(String name, ZipEntry file, ZipIOReader zipFile, ZipIOFile parent) {
        this.name = name;
        this.zipFile = zipFile;
        this.file = file;
        this.parent = parent;
        this.isFile = file == null ? false : !file.isDirectory();
    }

    protected final ArrayList<ZipIOFile> getFilesInternal() {
        return this.files;
    }

    public final ZipIOFile[] getFiles() {
        return this.files.toArray(new ZipIOFile[this.files.size()]);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDirectory() {
        return !this.isFile;
    }

    public final ZipIOFile getParent() {
        return this.parent;
    }

    public final boolean isFile() {
        return this.isFile;
    }

    public final String getAbsolutePath() {
        if (this.file == null) {
            return String.valueOf(this.parent != null ? this.parent.getAbsolutePath() : "") + this.name + "/";
        }
        return this.file.getName();
    }

    public final long getSize() {
        if (!this.isFile) {
            return 0L;
        }
        return this.file.getSize();
    }

    public final long getCRC32() {
        if (!this.isFile) {
            return 0L;
        }
        return this.file.getCrc();
    }

    public final InputStream getInputStream() throws IOException, ZipIOException {
        if (!this.isFile) {
            return null;
        }
        return this.zipFile.getInputStream(this.file);
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public void extract(File output) throws ZipIOException, IOException {
        if (!this.isFile) {
            throw new ZipIOException("Cannot extract a directory", this.file);
        }
        this.zipFile.extract(this.file, output);
    }
}

