/*
 * Decompiled with CFR 0.152.
 */
package jd.http.ext.security;

import org.appwork.utils.logging.Log;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class JSPermissionRestricter {
    public static void init() {
        ContextFactory.initGlobal((ContextFactory)new SandboxContextFactory());
    }

    public static class SandboxContextFactory
    extends ContextFactory {
        protected Context makeContext() {
            Context cx = super.makeContext();
            cx.setWrapFactory((WrapFactory)new SandboxWrapFactory());
            cx.setClassShutter(new ClassShutter(){

                public boolean visibleToScripts(String className) {
                    if (className.startsWith("adapter")) {
                        return true;
                    }
                    if (className.equals("org.mozilla.javascript.EcmaError")) {
                        Log.L.severe("Javascript error occured");
                        return true;
                    }
                    throw new RuntimeException("Security Violation " + className);
                }
            });
            return cx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SandboxNativeJavaObject
    extends NativeJavaObject {
        private static final long serialVersionUID = -2783084485265910840L;

        public SandboxNativeJavaObject(Scriptable scope, Object javaObject, Class<?> staticType) {
            super(scope, javaObject, staticType);
        }

        public Object get(String name, Scriptable start) {
            if (name.equals("getClass")) {
                Log.L.severe("JS Security Exception");
                return NOT_FOUND;
            }
            return super.get(name, start);
        }
    }

    public static class SandboxWrapFactory
    extends WrapFactory {
        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            if (javaObject instanceof EcmaError) {
                Log.exception((Throwable)((EcmaError)javaObject));
            }
            return new SandboxNativeJavaObject(scope, javaObject, staticType);
        }
    }
}

