/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.appwork.storage.JacksonStorageChest;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.crypto.Crypto;
import org.appwork.utils.logging.Log;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class ConfigInterface {
    private static final HashMap<String, Storage> MAP = new HashMap();
    private static File path;
    private static final ObjectMapper MAPPER;
    static final byte[] KEY;

    static {
        MAPPER = new ObjectMapper();
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        KEY = new byte[]{1, 2, 17, 1, 1, 84, 1, 1, 1, 1, 18, 1, 1, 1, 34, 1};
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Iterator it = MAP.entrySet().iterator();
                while (it.hasNext()) {
                    try {
                        ((Storage)it.next().getValue()).save();
                    }
                    catch (Throwable e) {
                        Log.exception(e);
                    }
                }
            }
        });
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static synchronized Storage getStorage(String name) throws StorageException {
        Storage ret = MAP.get(name);
        if (ret == null) {
            ret = new JacksonStorageChest(name);
            MAP.put(name, ret);
        }
        return ret;
    }

    public static void saveTo(String pathname, String json) throws StorageException {
        try {
            path = Application.getRessource(pathname);
            File tmp = new File(path.getParentFile(), String.valueOf(path.getName()) + ".tmp");
            tmp.getParentFile().mkdirs();
            tmp.delete();
            if (new Regex(pathname, ".+\\.json").matches()) {
                IO.writeToFile(tmp, json.getBytes("UTF-8"));
            } else {
                IO.writeToFile(tmp, Crypto.encrypt(json, KEY));
            }
            if (path.exists() && !path.delete()) {
                throw new StorageException("Could not overwrite file: " + path);
            }
            if (!tmp.renameTo(path)) {
                throw new StorageException("Could not rename file: " + tmp + " to " + path);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public static void storeTo(String string, Object list) {
        try {
            ConfigInterface.saveTo(string, ConfigInterface.toString(list));
        }
        catch (JsonGenerationException e) {
            Log.exception(e);
        }
        catch (JsonMappingException e) {
            Log.exception(e);
        }
        catch (StorageException e) {
            Log.exception(e);
        }
        catch (IOException e) {
            Log.exception(e);
        }
    }

    public static String toString(Object list) throws JsonGenerationException, JsonMappingException, IOException {
        return MAPPER.writeValueAsString(list);
    }

    public static <E> E restoreFrom(String string, TypeReference<E> type, E def) {
        try {
            if (!Application.getRessource(string).exists()) {
                return def;
            }
            byte[] str = IO.readFile(Application.getRessource(string));
            if (new Regex(string, ".+\\.json").matches()) {
                return ConfigInterface.restoreFromString(new String(str, "UTF-8"), type, def);
            }
            return ConfigInterface.restoreFromString(Crypto.decrypt(str, KEY), type, def);
        }
        catch (JsonParseException e) {
            Log.exception(e);
        }
        catch (JsonMappingException e) {
            Log.exception(e);
        }
        catch (IOException e) {
            Log.exception(e);
        }
        return def;
    }

    public static <E> E restoreFromString(String string, TypeReference<E> type, E def) throws JsonParseException, JsonMappingException, IOException {
        if (string == null) {
            return def;
        }
        if (type != null) {
            return (E)MAPPER.readValue(string, type);
        }
        return (E)MAPPER.readValue(string, def.getClass());
    }
}

