/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import org.appwork.utils.logging.Log;

public class Application {
    private static String APP_FOLDER = ".appwork";
    private static String ROOT;

    public static boolean isJared() {
        String caller = "" + Thread.currentThread().getContextClassLoader().getResource("org/appwork");
        return caller.matches("jar\\:.*\\.jar\\!.*");
    }

    public static synchronized void setApplication(String newAppFolder) {
        APP_FOLDER = newAppFolder;
    }

    public static String getRoot() {
        return Application.getRoot(Application.class);
    }

    public static String getRoot(Class<?> rootOfClazz) {
        if (ROOT != null) {
            return ROOT;
        }
        if (Application.isJared()) {
            String loc;
            try {
                loc = URLDecoder.decode(rootOfClazz.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8");
            }
            catch (Exception e) {
                loc = rootOfClazz.getProtectionDomain().getCodeSource().getLocation().getFile();
                System.err.println("failed urldecoding Location: " + loc);
            }
            File appRoot = new File(loc);
            if (appRoot.isFile()) {
                appRoot = appRoot.getParentFile();
            }
            ROOT = appRoot.getAbsolutePath();
        } else {
            ROOT = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + APP_FOLDER + System.getProperty("file.separator");
        }
        return ROOT;
    }

    public static File getRessource(String relative) {
        return new File(Application.getRoot(), relative);
    }

    public static void addFolderToClassPath(File file) throws IOException {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)Application.class.getClassLoader(), file.toURI().toURL());
        }
        catch (Throwable t) {
            Log.exception(t);
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

