/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.appwork.utils.formatter.HexFormatter;

public class Hash {
    public static String HASH_TYPE_MD5 = "md5";
    public static String HASH_TYPE_SHA1 = "SHA-1";

    public static String getFileHash(File arg, String type) throws NoSuchAlgorithmException, IOException {
        if (arg == null || !arg.exists() || arg.isDirectory()) {
            throw new NullPointerException();
        }
        MessageDigest md = MessageDigest.getInstance(type);
        byte[] b = new byte[Short.MAX_VALUE];
        FileInputStream in = new FileInputStream(arg);
        int n = 0;
        while ((n = ((InputStream)in).read(b)) > -1) {
            md.update(b, 0, n);
        }
        ((InputStream)in).close();
        byte[] digest = md.digest();
        return HexFormatter.byteArrayToHex(digest);
    }

    public static String getStringHash(String arg, String type) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(type);
        byte[] digest = md.digest(arg.getBytes());
        return HexFormatter.byteArrayToHex(digest);
    }

    public static String getMD5(String arg) throws NoSuchAlgorithmException {
        return Hash.getStringHash(arg, HASH_TYPE_MD5);
    }

    public static String getMD5(File arg) throws NoSuchAlgorithmException, IOException {
        return Hash.getFileHash(arg, HASH_TYPE_MD5);
    }

    public static String getSHA1(String arg) throws NoSuchAlgorithmException {
        return Hash.getStringHash(arg, HASH_TYPE_SHA1);
    }

    public static String getSHA1(File arg) throws NoSuchAlgorithmException, IOException {
        return Hash.getFileHash(arg, HASH_TYPE_SHA1);
    }

    public static long getCRC32(File arg) throws IOException {
        FileInputStream fis = new FileInputStream(arg);
        FilterInputStream cis = null;
        try {
            cis = new CheckedInputStream(fis, new CRC32());
            byte[] readBuffer = new byte[Short.MAX_VALUE];
            while (cis.read(readBuffer) >= 0) {
            }
            long l = ((CheckedInputStream)cis).getChecksum().getValue();
            return l;
        }
        finally {
            if (cis != null) {
                cis.close();
            }
            fis.close();
        }
    }
}

