/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.ImageProvider;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;
import sun.awt.image.ToolkitImage;

public class ImageProvider {
    private static HashMap<String, BufferedImage> IMAGE_CACHE = new HashMap();
    private static HashMap<String, ImageIcon> IMAGEICON_CACHE = new HashMap();
    private static HashMap<Icon, Icon> DISABLED_ICON_CACHE = new HashMap();
    private static Object LOCK = new Object();
    private static StringBuilder SB = new StringBuilder();

    public static Image getBufferedImage(String name) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (IMAGE_CACHE.containsKey(name)) {
                return IMAGE_CACHE.get(name);
            }
            File absolutePath = Application.getRessource("images/" + name + ".png");
            try {
                BufferedImage image = ImageIO.read(absolutePath);
                IMAGE_CACHE.put(name, image);
                return image;
            }
            catch (IOException e) {
                Log.L.severe("Could not Init Image: " + absolutePath.getAbsolutePath());
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getImageIcon(String name, int width, int height) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            SB.delete(0, SB.capacity());
            SB.append(name);
            SB.append('_');
            SB.append(width);
            SB.append('_');
            SB.append(height);
            String key = SB.toString();
            if (IMAGEICON_CACHE.containsKey(key)) {
                return IMAGEICON_CACHE.get(key);
            }
            Image image = ImageProvider.getBufferedImage(name);
            double faktor = Math.max((double)image.getWidth(null) / (double)width, (double)image.getHeight(null) / (double)height);
            width = (int)((double)image.getWidth(null) / faktor);
            height = (int)((double)image.getHeight(null) / faktor);
            ImageIcon imageicon = new ImageIcon(image.getScaledInstance(width, height, 4));
            IMAGEICON_CACHE.put(key, imageicon);
            return imageicon;
        }
    }

    public static ImageIcon toImageIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return new ImageIcon(image);
    }

    public static Image scaleBufferedImage(BufferedImage img, int width, int height) {
        if (img == null) {
            return null;
        }
        double faktor = Math.max((double)img.getWidth() / (double)width, (double)img.getHeight() / (double)height);
        width = (int)((double)img.getWidth() / faktor);
        height = (int)((double)img.getHeight() / faktor);
        if (faktor == 1.0) {
            return img;
        }
        return img.getScaledInstance(width, height, 4);
    }

    public static ImageIcon scaleImageIcon(ImageIcon img, int w, int h) {
        BufferedImage dest;
        if (img.getIconHeight() == h && img.getIconWidth() == w) {
            return img;
        }
        if (img.getImage() instanceof ToolkitImage) {
            dest = new BufferedImage(w, h, 3);
            Graphics2D g2 = dest.createGraphics();
            g2.drawImage(img.getImage(), 0, 0, null);
            g2.dispose();
        } else {
            dest = (BufferedImage)img.getImage();
        }
        return new ImageIcon(ImageProvider.scaleBufferedImage(dest, w, h));
    }

    public static BufferedImage convertToGrayScale(BufferedImage bufferedImage) {
        BufferedImage dest = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage((Image)bufferedImage, 0, 0, null);
        g2.dispose();
        return dest;
    }

    public static BufferedImage merge(Image image, Image b, int xoffset, int yoffset) {
        int width = Math.max(image.getWidth(null), xoffset + b.getWidth(null));
        int height = Math.max(image.getHeight(null), yoffset + b.getHeight(null));
        BufferedImage dest = new BufferedImage(width, height, 3);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.drawImage(b, xoffset, yoffset, null);
        g2.dispose();
        return dest;
    }

    public static Icon getDisabledIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        Icon ret = DISABLED_ICON_CACHE.get(icon);
        if (ret != null) {
            return ret;
        }
        ret = UIManager.getLookAndFeel().getDisabledIcon(null, icon);
        DISABLED_ICON_CACHE.put(icon, ret);
        return ret;
    }
}

