/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.formatter;

import org.appwork.utils.BinaryLogic;
import org.appwork.utils.Regex;
import org.appwork.utils.formatter.StringFormatter;

public class TimeFormatter {
    public static final int HIDE_SECONDS = 1;
    public static final int HIDE_MARKER = 2;
    public static final int CLOCK = 3;

    public static String formatMilliSeconds(long totalSeconds, int flags) {
        return TimeFormatter.formatSeconds(totalSeconds / 1000L, flags);
    }

    public static String formatSeconds(long totalSeconds, int flags) {
        StringBuilder string = new StringBuilder();
        long days = totalSeconds / 86400L;
        long hours = (totalSeconds -= days * 24L * 60L * 60L) / 3600L;
        long minutes = (totalSeconds -= hours * 60L * 60L) / 60L;
        long seconds = totalSeconds - minutes * 60L;
        if (!BinaryLogic.containsAll(flags, 3) && days != 0L) {
            string.append(days);
            string.append('d');
        }
        if (hours != 0L || string.length() != 0 || BinaryLogic.containsAll(flags, 3)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(hours);
            if (BinaryLogic.containsNone(flags, 2)) {
                string.append('h');
            }
        }
        if (minutes != 0L || string.length() != 0 || BinaryLogic.containsAll(flags, 3)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(StringFormatter.fillStart(String.valueOf(minutes), 2, "0"));
            if (BinaryLogic.containsNone(flags, 2)) {
                string.append('m');
            }
        }
        if (BinaryLogic.containsNone(flags, 1)) {
            if (string.length() != 0) {
                string.append(':');
            }
            string.append(StringFormatter.fillStart(String.valueOf(seconds), 2, "0"));
            if (BinaryLogic.containsNone(flags, 2)) {
                string.append('s');
            }
        }
        return string.toString();
    }

    public static long formatStringToMilliseconds(String text) {
        String[] found = new Regex(text, "(\\d+)\\w?:(\\d+)").getRow(0);
        if (found == null) {
            return 0L;
        }
        int hours = Integer.parseInt(found[0]);
        int minutes = Integer.parseInt(found[1]);
        if (hours >= 24) {
            hours = 24;
            minutes = 0;
        }
        if (minutes >= 60) {
            ++hours;
            minutes = 0;
        }
        return hours * 60 * 60 * 1000 + minutes * 60 * 1000;
    }
}

