/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.appwork.utils.logging.FileLogFormatter;
import org.appwork.utils.logging.LogEventHandler;
import org.appwork.utils.logging.LogFormatter;
import org.appwork.utils.logging.LogToFileHandler;

public class Log {
    private static Logger LOGGER = Logger.getLogger("org.appwork");
    public static Logger L;

    static {
        LOGGER.setUseParentHandlers(false);
        ConsoleHandler cHandler = new ConsoleHandler();
        cHandler.setLevel(Level.ALL);
        cHandler.setFormatter(new LogFormatter());
        LOGGER.addHandler(cHandler);
        try {
            LogToFileHandler fh = new LogToFileHandler();
            fh.setFormatter(new FileLogFormatter());
            LOGGER.addHandler(fh);
        }
        catch (Exception e) {
            Log.exception(e);
        }
        LOGGER.addHandler(LogEventHandler.getInstance());
        LOGGER.setLevel(Level.ALL);
        L = LOGGER;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void exception(Throwable e) {
        Log.exception(Level.SEVERE, e);
    }

    public static void exception(Level level, Throwable e) {
        Log.getLogger().log(level, String.valueOf(level.getName()) + " Exception occurred", e);
    }
}

