/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import javax.swing.SwingUtilities;
import org.appwork.utils.logging.Log;

public abstract class EDTHelper<T>
implements Runnable {
    private boolean done = false;
    private Object lock = new Object();
    private T returnValue;
    private boolean started = false;

    public abstract T edtRun();

    public T getReturnValue() {
        this.waitForEDT();
        return this.returnValue;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.returnValue = this.edtRun();
        }
        catch (Exception e) {
            Log.exception(e);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
            this.lock = null;
        }
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void start() {
        this.setStarted(true);
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void invokeLater() {
        this.setStarted(true);
        SwingUtilities.invokeLater(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEDT() {
        if (this.done) {
            return;
        }
        if (!this.isStarted()) {
            this.start();
        }
        if (!SwingUtilities.isEventDispatchThread() && this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    if (this.lock != null) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.done = true;
    }
}

