/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public abstract class Graph
extends JPanel {
    private static final long serialVersionUID = 6943108941655020136L;
    private int i;
    private int[] cache;
    private transient Thread fetcherThread;
    private int interval = 1000;
    private Timer painter;
    private Color colorA = new Color(100, 100, 100, 40);
    private Color colorB = new Color(100, 100, 100, 80);
    private int max;

    public Color getColorA() {
        return this.colorA;
    }

    public void setColorA(Color colorA) {
        this.colorA = colorA;
    }

    public Color getColorB() {
        return this.colorB;
    }

    public void setColorB(Color colorB) {
        this.colorB = colorB;
    }

    public Graph() {
        this.setCapacity(60);
        this.setOpaque(false);
    }

    private void setCapacity(int cap) {
        this.cache = new int[cap];
        int x = 0;
        while (x < cap) {
            this.cache[x] = 0;
            ++x;
        }
    }

    public void start() {
        this.painter = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Graph.this.repaint();
            }
        });
        this.painter.setRepeats(true);
        this.painter.setInitialDelay(0);
        this.i = 0;
        this.fetcherThread = new Thread("Speedmeter updater"){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    ((Graph)Graph.this).cache[((Graph)Graph.this).i] = Graph.this.getValue();
                    Graph graph = Graph.this;
                    graph.i = graph.i + 1;
                    Graph graph2 = Graph.this;
                    graph2.i = graph2.i % Graph.this.cache.length;
                    try {
                        Thread.sleep(Graph.this.interval);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        this.fetcherThread.start();
        this.painter.start();
    }

    public abstract int getValue();

    public void stop() {
        if (this.fetcherThread != null) {
            this.fetcherThread.interrupt();
            this.fetcherThread = null;
        }
        if (this.painter != null) {
            this.painter.stop();
            this.painter = null;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        int id = this.i;
        this.max = 10;
        int[] nArray = this.cache;
        int n = this.cache.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            this.max = Math.max(element, this.max);
            ++n2;
        }
        int height = this.getHeight();
        Polygon poly = new Polygon();
        poly.addPoint(0, this.getWidth());
        int x = 0;
        while (x < this.cache.length) {
            poly.addPoint(x * this.getWidth() / this.cache.length, this.getHeight() - (int)((double)(this.getHeight() * this.cache[id]) * 0.9) / this.max);
            ++id;
            id %= this.cache.length;
            ++x;
        }
        poly.addPoint(this.getWidth(), height);
        ((Graphics2D)g).setPaint(new GradientPaint(this.getWidth() / 2, 0.0f, this.colorA, this.getWidth() / 2, height, this.colorB.darker()));
        g2.fill(poly);
    }
}

