/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.appwork.utils.logging.Log;

public class TreeModelStateSaver {
    protected JTree tree;
    private HashMap<Object, Boolean> expandCache;
    private TreePath treePath;
    protected TreePath[] selectedPathes;

    public void setSelectedPathes(TreePath[] selectedPathes) {
        this.selectedPathes = selectedPathes;
    }

    public HashMap<Object, Boolean> getExpandCache() {
        return this.expandCache;
    }

    public TreeModelStateSaver(JTree tree) {
        this.tree = tree;
        this.expandCache = new HashMap();
    }

    public void save() {
        this.saveState(this.tree.getModel().getRoot(), new ArrayList<Object>());
        this.selectedPathes = this.tree.getSelectionPaths();
    }

    private void saveState(Object node, ArrayList<Object> path) {
        path.add(node);
        try {
            this.treePath = new TreePath(path.toArray(new Object[0]));
            this.expandCache.put(node, this.tree.isExpanded(this.treePath));
        }
        catch (Exception e) {
            Log.exception(e);
        }
        int max = this.tree.getModel().getChildCount(node);
        int i = 0;
        while (i < max) {
            try {
                this.saveState(this.tree.getModel().getChild(node, i), new ArrayList<Object>(path));
            }
            catch (Exception e) {
                Log.exception(e);
            }
            this.tree.getModel().getChildCount(node);
            ++i;
        }
    }

    public void restore() {
        this.restoreState(this.tree.getModel().getRoot(), new ArrayList<Object>());
        if (this.selectedPathes != null && this.selectedPathes.length > 0) {
            this.tree.getSelectionModel().clearSelection();
            this.tree.getSelectionModel().setSelectionPaths(this.selectedPathes);
        }
    }

    public TreePath[] getSelectedPathes() {
        return this.selectedPathes;
    }

    protected void restoreState(Object node, ArrayList<Object> path) {
        if (node == null) {
            return;
        }
        path.add(node);
        this.treePath = new TreePath(path.toArray(new Object[0]));
        Boolean bo = this.expandCache.get(node);
        if (bo != null && bo.booleanValue()) {
            this.tree.expandPath(this.treePath);
        }
        int i = 0;
        while (i < this.tree.getModel().getChildCount(node)) {
            this.restoreState(this.tree.getModel().getChild(node, i), new ArrayList<Object>(path));
            ++i;
        }
    }
}

