/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class ComboBoxDialog
extends AbstractDialog {
    private static final long serialVersionUID = 3779238515088665521L;
    private JComboBox box;
    private String message;
    private JTextPane textpane;
    private int defaultAnswer;
    private Object[] options;
    private ListCellRenderer renderer;

    public ComboBoxDialog(int flag, String title, String question, Object[] options, int defaultSelection, ImageIcon icon, String okText, String cancelText, ListCellRenderer renderer) {
        super(flag, title, icon, okText, cancelText);
        this.message = question;
        this.renderer = renderer;
        this.defaultAnswer = defaultSelection;
        this.options = options;
        this.init();
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel contentpane = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1", "[fill,grow]"));
        this.textpane = new JTextPane();
        this.textpane.setBorder(null);
        this.textpane.setBackground(null);
        this.textpane.setOpaque(false);
        this.textpane.setText(this.message);
        this.textpane.setEditable(false);
        contentpane.add(this.textpane);
        this.box = new JComboBox<Object>(this.options);
        if (this.renderer != null) {
            this.box.setRenderer(this.renderer);
        }
        try {
            this.box.setSelectedIndex(this.defaultAnswer);
        }
        catch (Exception e) {
            Log.exception(e);
        }
        if (this.getDesiredSize() != null) {
            this.box.setBounds(0, 0, (int)this.getDesiredSize().getWidth(), (int)this.getDesiredSize().getHeight());
            this.box.setMaximumSize(this.getDesiredSize());
        } else {
            this.box.setBounds(0, 0, 450, 600);
            this.box.setMaximumSize(new Dimension(450, 600));
        }
        contentpane.add((Component)this.box, "pushy,growy, width n:n:450");
        return contentpane;
    }

    public Integer getReturnIndex() {
        if ((this.getReturnmask() & 2) == 0) {
            return -1;
        }
        return this.box.getSelectedIndex();
    }
}

