/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class ProgressDialog
extends AbstractDialog {
    private static final long serialVersionUID = -7420852517889843489L;
    private JTextPane textField;
    private String message;
    private ProgressGetter getter;
    private Timer updater;
    private Thread executer;

    public ProgressDialog(ProgressGetter progressGetter, int flags, String title, String message) {
        super(flags | 8, title, null, null, null);
        this.message = message;
        this.setDefaultCloseOperation(0);
        this.getter = progressGetter;
        this.setReturnmask(true);
        this.init();
    }

    private JComponent getTextfield() {
        this.textField = new JTextPane();
        if (BinaryLogic.containsAll(this.flagMask, 128)) {
            this.textField.setContentType("text/html");
            this.textField.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        CrossSystem.openURL(e.getURL());
                    }
                }
            });
        } else {
            this.textField.setContentType("text");
            this.textField.setMaximumSize(new Dimension(450, 600));
        }
        this.textField.setText(this.message);
        this.textField.setEditable(false);
        this.textField.setBackground(null);
        this.textField.setOpaque(false);
        this.textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        if (BinaryLogic.containsAll(this.flagMask, 64)) {
            JScrollPane sp = new JScrollPane(this.textField);
            sp.setMaximumSize(new Dimension(450, 600));
            return sp;
        }
        return this.textField;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.executer.interrupt();
        try {
            this.executer.join(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0"));
        p.add((Component)this.getTextfield(), "growx,pushx");
        final JProgressBar bar = new JProgressBar(0, 100);
        p.add((Component)bar, "growx,pushx,newline");
        bar.setStringPainted(true);
        this.updater = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgressDialog.this.getter != null) {
                    int prg = ProgressDialog.this.getter.getProgress();
                    String text = ProgressDialog.this.getter.getString();
                    bar.setValue(prg);
                    if (text == null) {
                        bar.setStringPainted(false);
                    } else {
                        bar.setStringPainted(true);
                        bar.setString(text);
                    }
                    if (prg >= 100) {
                        ProgressDialog.this.updater.stop();
                        ProgressDialog.this.dispose();
                        return;
                    }
                }
            }
        });
        this.updater.setRepeats(true);
        this.updater.setInitialDelay(50);
        this.updater.start();
        this.executer = new Thread("ProgressDialogExecuter"){

            @Override
            public void run() {
                try {
                    try {
                        ProgressDialog.this.getter.run();
                    }
                    catch (Exception e) {
                        ProgressDialog.this.setReturnmask(false);
                        ProgressDialog.this.dispose();
                        ProgressDialog.this.updater.stop();
                    }
                }
                finally {
                    ProgressDialog.this.dispose();
                    ProgressDialog.this.updater.stop();
                }
            }
        };
        this.executer.start();
        return p;
    }

    public static interface ProgressGetter {
        public void run() throws Exception;

        public int getProgress();

        public String getString();
    }
}

