/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.locale.Tl8;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.EDTHelper;

public abstract class TimerDialog
extends JDialog {
    private static final long serialVersionUID = -7551772010164684078L;
    protected Thread timer;
    protected int counter;
    protected JLabel timerLbl;

    public TimerDialog(JFrame parentframe) {
        super((Window)parentframe, Dialog.ModalityType.TOOLKIT_MODAL);
        if (parentframe != null) {
            parentframe.setAlwaysOnTop(true);
        }
        if (parentframe != null) {
            parentframe.setAlwaysOnTop(false);
        }
        this.layoutDialog();
    }

    protected void layoutDialog() {
        this.timerLbl = new JLabel(Tl8.TIMERDIALOG_MESSAGE_COUNTDOWN_STARTING.toString());
        this.timerLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TimerDialog.this.cancel();
                TimerDialog.this.timerLbl.removeMouseListener(this);
            }
        });
        this.timerLbl.setToolTipText(Tl8.TIMERDIALOG_TOOLTIP_TIMERLABEL.toString());
        try {
            this.timerLbl.setIcon(ImageProvider.getImageIcon("cancel", 16, 16));
        }
        catch (IOException e1) {
            Log.exception(e1);
        }
    }

    public void cancel() {
        if (this.timer != null) {
            this.timer.interrupt();
            this.timer = null;
            this.timerLbl.setEnabled(false);
        }
    }

    protected abstract void onTimeout();

    protected void initTimer(int time) {
        this.counter = time;
        this.timer = new Thread(){

            @Override
            public void run() {
                try {
                    while (!TimerDialog.this.isVisible()) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    int count = TimerDialog.this.counter;
                    while (--count >= 0) {
                        if (!TimerDialog.this.isVisible()) {
                            return;
                        }
                        if (TimerDialog.this.timer == null) {
                            return;
                        }
                        final String left = TimeFormatter.formatSeconds(count, 0);
                        new EDTHelper<Object>(){

                            @Override
                            public Object edtRun() {
                                (this).TimerDialog.this.timerLbl.setText(left);
                                return null;
                            }
                        }.start();
                        Thread.sleep(1000L);
                        if (TimerDialog.this.counter < 0) {
                            return;
                        }
                        if (TimerDialog.this.isVisible()) continue;
                        return;
                    }
                    if (TimerDialog.this.counter < 0) {
                        return;
                    }
                    if (!this.isInterrupted()) {
                        TimerDialog.this.onTimeout();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        this.timer.start();
    }
}

