/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.appwork.storage.ConfigInterface;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.table.ExtCheckBoxMenuItem;
import org.appwork.utils.swing.table.ExtColumn;
import org.appwork.utils.swing.table.ExtRowHighlighter;
import org.appwork.utils.swing.table.ExtTableModel;
import org.appwork.utils.swing.table.SearchDialog;

public class ExtTable<E>
extends JTable {
    private static final long serialVersionUID = 2822230056021924679L;
    private Color columnBackground;
    private Color columnBackgroundSelected;
    private Color columnForeground;
    private Color columnForegroundSelected;
    private ExtTableModel<E> model;
    private String tableID;
    private final ArrayList<ExtRowHighlighter> rowHighlighters;
    private boolean searchEnabled = false;
    private SearchDialog searchDialog;

    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    public void setSearchEnabled(boolean searchEnabled) {
        this.searchEnabled = searchEnabled;
    }

    public ExtTable(ExtTableModel<E> model, String id) {
        super(model);
        this.tableID = id;
        this.rowHighlighters = new ArrayList();
        this.model = model;
        model.setTable(this);
        Component c = super.getCellRenderer(0, 0).getTableCellRendererComponent(this, "", true, false, 0, 0);
        this.columnBackgroundSelected = c.getBackground();
        this.columnForegroundSelected = c.getForeground();
        c = super.getCellRenderer(0, 0).getTableCellRendererComponent(this, "", false, false, 0, 0);
        this.columnBackground = c.getBackground();
        this.columnForeground = c.getForeground();
        this.createColumns();
        this.getTableHeader().addMouseListener(new MouseAdapter(){
            int columnPressed = 0;

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ExtTable.this.getTableHeader().getCursor().getType() == Cursor.getDefaultCursor().getType() && e.getButton() == 1) {
                    if (this.columnPressed != ExtTable.this.columnAtPoint(e.getPoint())) {
                        return;
                    }
                    int col = ExtTable.this.getExtColumnIndexByPoint(e.getPoint());
                    if (ExtTable.this.getExtTableModel().getExtColumn(col).isSortable(null)) {
                        ExtTable.this.getExtTableModel().getExtColumn(col).doSort(null);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ExtTable.this.getTableHeader().getCursor().getType() == Cursor.getDefaultCursor().getType()) {
                    if (e.getButton() == 1) {
                        this.columnPressed = ExtTable.this.columnAtPoint(e.getPoint());
                    } else if (e.getButton() == 3) {
                        ExtTable.this.columControlMenu().show(ExtTable.this.getTableHeader(), e.getX(), e.getY());
                    }
                }
            }
        });
        this.getTableHeader().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int col = ExtTable.this.getExtColumnIndexByPoint(e.getPoint());
                ExtTable.this.getTableHeader().setToolTipText(ExtTable.this.getExtTableModel().getExtColumn(col).getName());
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ArrayList sel = ExtTable.this.getExtTableModel().getSelectedObjects();
                if (sel != null && sel.size() == 0) {
                    sel = null;
                }
                ExtTable.this.onSelectionChanged(sel);
            }
        });
        this.getTableHeader().setReorderingAllowed(true);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(2);
        this.setAutoscrolls(true);
        this.getTableHeader().setPreferredSize(new Dimension(this.getColumnModel().getTotalColumnWidth(), 19));
        this.setFillsViewportHeight(true);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getFromIndex() == e.getToIndex()) {
                    return;
                }
                TableColumnModel tcm = ExtTable.this.getColumnModel();
                int i = 0;
                while (i < tcm.getColumnCount()) {
                    try {
                        ConfigInterface.getStorage("ExtTable_" + ExtTable.this.tableID).put("POS_COL_" + i, ExtTable.this.getExtTableModel().getExtColumn(tcm.getColumn(i).getModelIndex()).getID());
                    }
                    catch (Exception e1) {
                        Log.exception(e1);
                    }
                    ++i;
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public String getTableID() {
        return this.tableID;
    }

    protected void scrollToSelection() {
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                JViewport viewport = (JViewport)ExtTable.this.getParent();
                if (viewport == null) {
                    return null;
                }
                int[] sel = ExtTable.this.getSelectedRows();
                if (sel == null || sel.length == 0) {
                    return null;
                }
                Rectangle rect = ExtTable.this.getCellRect(sel[0], 0, true);
                Rectangle rect2 = ExtTable.this.getCellRect(sel[sel.length - 1], 0, true);
                rect.height += rect2.y - rect.y;
                Point pt = viewport.getViewPosition();
                rect.setLocation(rect.x - pt.x, rect.y - pt.y);
                viewport.scrollRectToVisible(rect);
                return null;
            }
        }.start();
    }

    public void scrollToRow(final int row) {
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                JViewport viewport = (JViewport)ExtTable.this.getParent();
                if (viewport == null) {
                    return null;
                }
                Rectangle rect = ExtTable.this.getCellRect(row, 0, true);
                Point pt = viewport.getViewPosition();
                rect.setLocation(rect.x - pt.x, rect.y - pt.y);
                viewport.scrollRectToVisible(rect);
                return null;
            }
        }.start();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 502) {
            if (e.isPopupTrigger() || e.getButton() == 3) {
                ArrayList<E> selected;
                JPopupMenu popup;
                int row = this.rowAtPoint(e.getPoint());
                E obj = this.getExtTableModel().getObjectbyRow(row);
                if (obj == null || row == -1) {
                    this.clearSelection();
                    JPopupMenu popup2 = this.onContextMenu(new JPopupMenu(), null, null);
                    if (popup2 != null && popup2.getComponentCount() > 0) {
                        popup2.show(this, e.getPoint().x, e.getPoint().y);
                    }
                    return;
                }
                if (!this.isRowSelected(row)) {
                    this.clearSelection();
                    this.addRowSelectionInterval(row, row);
                }
                if ((popup = this.onContextMenu(new JPopupMenu(), obj, selected = this.getExtTableModel().getSelectedObjects())) != null && popup.getComponentCount() > 0) {
                    popup.show(this, e.getPoint().x, e.getPoint().y);
                }
            } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                int row = this.rowAtPoint(e.getPoint());
                E obj = this.getExtTableModel().getObjectbyRow(row);
                if (obj == null || row == -1) {
                    this.onDoubleClick(obj);
                }
            }
        } else if (e.getID() == 501 && this.rowAtPoint(e.getPoint()) < 0) {
            this.clearSelection();
        }
    }

    protected void onDoubleClick(E obj) {
    }

    @Override
    protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
        if (!pressed) {
            return super.processKeyBinding(stroke, evt, condition, pressed);
        }
        switch (evt.getKeyCode()) {
            case 88: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                return this.onShortcutCut(this.getExtTableModel().getSelectedObjects(), evt);
            }
            case 86: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                return this.onShortcutPaste(this.getExtTableModel().getSelectedObjects(), evt);
            }
            case 67: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                return this.onShortcutCopy(this.getExtTableModel().getSelectedObjects(), evt);
            }
            case 127: {
                return this.onShortcutDelete(this.getExtTableModel().getSelectedObjects(), evt, BinaryLogic.containsSome(evt.getModifiers(), 1));
            }
            case 8: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                return this.onShortcutDelete(this.getExtTableModel().getSelectedObjects(), evt, false);
            }
            case 70: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                return this.onShortcutSearch(this.getExtTableModel().getSelectedObjects(), evt);
            }
            case 38: {
                if (this.getSelectedRow() != 0) break;
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                this.changeSelection(this.getRowCount() - 1, 0, false, false);
                return true;
            }
            case 40: {
                if (this.getSelectedRow() != this.getRowCount() - 1) break;
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                this.changeSelection(0, 0, false, false);
                return true;
            }
            case 65: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                this.getSelectionModel().setSelectionInterval(0, this.getRowCount() - 1);
                return true;
            }
            case 36: {
                if (evt.isControlDown() || evt.isMetaDown() || evt.isShiftDown()) {
                    if (this.getCellEditor() != null) {
                        this.getCellEditor().stopCellEditing();
                    }
                    if (this.getSelectedRow() == -1 || this.getRowCount() == 0) break;
                    this.getSelectionModel().setSelectionInterval(0, this.getSelectedRows()[this.getSelectedRows().length - 1]);
                    return true;
                }
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                this.getSelectionModel().setSelectionInterval(0, 0);
                break;
            }
            case 35: {
                if (evt.isControlDown() || evt.isMetaDown() || evt.isShiftDown()) {
                    if (this.getCellEditor() != null) {
                        this.getCellEditor().stopCellEditing();
                    }
                    if (this.getSelectedRow() == -1 || this.getRowCount() == 0) break;
                    this.getSelectionModel().setSelectionInterval(this.getSelectedRow(), this.getRowCount() - 1);
                    return true;
                }
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                if (this.getRowCount() == 0) break;
                this.getSelectionModel().setSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
            }
        }
        return super.processKeyBinding(stroke, evt, condition, pressed);
    }

    protected boolean onShortcutSearch(ArrayList<E> selectedObjects, KeyEvent evt) {
        if (this.searchEnabled && this.hasFocus()) {
            this.startSearch();
            return true;
        }
        return false;
    }

    private synchronized void startSearch() {
        try {
            if (this.searchDialog != null && this.searchDialog.isShowing()) {
                this.searchDialog.requestFocus();
            } else {
                this.searchDialog = new SearchDialog(1, this){
                    private static final long serialVersionUID = 2652101312418765845L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String ret = ExtTable.this.searchDialog.getReturnID();
                        if (ret != null) {
                            int[] sel = ExtTable.this.getSelectedRows();
                            int startRow = -1;
                            if (sel != null & sel.length > 0) {
                                startRow = sel[sel.length - 1];
                            }
                            Object found = ExtTable.this.getExtTableModel().searchNextObject(startRow + 1, ret, ExtTable.this.searchDialog.isCaseSensitive(), ExtTable.this.searchDialog.isRegex());
                            ExtTable.this.getExtTableModel().setSelectedObject(found);
                            ExtTable.this.scrollToSelection();
                        }
                    }
                };
                this.addFocusListener(this.searchDialog);
            }
        }
        catch (IOException e) {
            Log.exception(e);
        }
    }

    protected boolean onShortcutDelete(ArrayList<E> selectedObjects, KeyEvent evt, boolean direct) {
        return false;
    }

    protected boolean onShortcutCopy(ArrayList<E> selectedObjects, KeyEvent evt) {
        return false;
    }

    protected boolean onShortcutPaste(ArrayList<E> selectedObjects, KeyEvent evt) {
        return false;
    }

    protected void onSelectionChanged(ArrayList<E> selected) {
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, E contextObject, ArrayList<E> selection) {
        return null;
    }

    protected boolean onShortcutCut(ArrayList<E> selectedObjects, KeyEvent evt) {
        return false;
    }

    public void addRowHighlighter(ExtRowHighlighter highlighter) {
        this.removeRowHighlighter(highlighter);
        this.rowHighlighters.add(highlighter);
    }

    public void removeRowHighlighter(ExtRowHighlighter highlighter) {
        this.rowHighlighters.remove(highlighter);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getRowCount() == 0) {
            return;
        }
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle first = this.getCellRect(0, 0, true);
        Rectangle last = this.getCellRect(0, this.getColumnCount() - 1, true);
        int width = last.x + last.width - first.x;
        for (ExtRowHighlighter rh : this.rowHighlighters) {
            int i = 0;
            while (i < this.getRowCount()) {
                first = this.getCellRect(i, 0, true);
                if (first.y + first.height >= visibleRect.y && first.y <= visibleRect.y + visibleRect.height && rh.doHighlight(this, i)) {
                    rh.paint((Graphics2D)g, 0, first.y, width, first.height);
                }
                ++i;
            }
        }
    }

    private JPopupMenu columControlMenu() {
        JPopupMenu popup = new JPopupMenu();
        JCheckBoxMenuItem[] mis = new JCheckBoxMenuItem[this.getExtTableModel().getColumnCount()];
        int i = 0;
        while (i < this.getExtTableModel().getColumnCount()) {
            final int j = i;
            final ExtCheckBoxMenuItem mi = new ExtCheckBoxMenuItem(this.getExtTableModel().getColumnName(i));
            mi.setHideOnClick(false);
            mis[i] = mi;
            if (i == 0) {
                mi.setEnabled(false);
            }
            mi.setSelected(this.getExtTableModel().isVisible(i));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtTable.this.getExtTableModel().setVisible(j, mi.isSelected());
                    ExtTable.this.createColumns();
                    ExtTable.this.revalidate();
                    ExtTable.this.repaint();
                }
            });
            popup.add(mi);
            ++i;
        }
        return popup;
    }

    private void createColumns() {
        this.setAutoCreateColumnsFromModel(false);
        TableColumnModel tcm = this.getColumnModel();
        while (tcm.getColumnCount() > 0) {
            tcm.removeColumn(tcm.getColumn(0));
        }
        LinkedHashMap<String, TableColumn> columns = new LinkedHashMap<String, TableColumn>();
        int i = 0;
        while (i < this.getModel().getColumnCount()) {
            block12: {
                TableColumn tableColumn;
                int j;
                block11: {
                    j = i;
                    tableColumn = new TableColumn(i);
                    tableColumn.setHeaderRenderer(this.model.getExtColumn(j).getHeaderRenderer());
                    tableColumn.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getPropertyName().equals("width")) {
                                try {
                                    ConfigInterface.getStorage("ExtTable_" + ExtTable.this.tableID).put("WIDTH_COL_" + ExtTable.this.model.getExtColumn(j).getID(), (Integer)evt.getNewValue());
                                }
                                catch (Exception e) {
                                    Log.exception(e);
                                }
                            }
                        }
                    });
                    if (this.model.getExtColumn(j).getMaxWidth() >= 0) {
                        tableColumn.setMaxWidth(this.model.getExtColumn(j).getMaxWidth());
                    }
                    if (this.model.getExtColumn(j).getMinWidth() >= 0) {
                        tableColumn.setMinWidth(this.model.getExtColumn(j).getMinWidth());
                    }
                    try {
                        int w = ConfigInterface.getStorage("ExtTable_" + this.tableID).get("WIDTH_COL_" + this.model.getExtColumn(j).getID(), this.model.getExtColumn(j).getDefaultWidth());
                        tableColumn.setPreferredWidth(w);
                        if (this.model.isVisible(i)) break block11;
                        break block12;
                    }
                    catch (Exception e) {
                        Log.exception(e);
                    }
                }
                columns.put(this.model.getExtColumn(j).getID(), tableColumn);
            }
            ++i;
        }
        int index = 0;
        while (!columns.isEmpty()) {
            if (index < this.getModel().getColumnCount()) {
                try {
                    TableColumn item;
                    String id = ConfigInterface.getStorage("ExtTable_" + this.tableID).get("POS_COL_" + index, "");
                    ++index;
                    if (id == null || (item = (TableColumn)columns.remove(id)) == null) continue;
                    this.addColumn(item);
                }
                catch (Exception e) {
                    Log.exception(e);
                }
                continue;
            }
            for (TableColumn ritem : columns.values()) {
                this.addColumn(ritem);
            }
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        return this.model.getCelleditorByColumn(this.convertColumnIndexToModel(column));
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.model.getCellrendererByColumn(this.convertColumnIndexToModel(column));
    }

    public Color getColumnBackground() {
        return this.columnBackground;
    }

    public Color getColumnBackgroundSelected() {
        return this.columnBackgroundSelected;
    }

    public Color getColumnForeground() {
        return this.columnForeground;
    }

    public Color getColumnForegroundSelected() {
        return this.columnForegroundSelected;
    }

    public ExtTableModel<E> getExtTableModel() {
        return this.model;
    }

    public TableCellEditor getLafCellEditor(int row, int column) {
        return super.getCellEditor(row, column);
    }

    public TableCellRenderer getLafCellRenderer(int row, int column) {
        return super.getCellRenderer(row, column);
    }

    public int getExtColumnIndexByPoint(Point point) {
        int x = this.columnAtPoint(point);
        return this.convertColumnIndexToModel(x);
    }

    public ExtColumn<E> getExtColumnAtPoint(Point point) {
        int x = this.getExtColumnIndexByPoint(point);
        return this.getExtTableModel().getExtColumn(x);
    }
}

