/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.ConfigInterface;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.locale.Tl8;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.table.ExtTable;

public abstract class SearchDialog
extends JDialog
implements KeyListener,
WindowListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 9206575398715006581L;
    public static final int NO_REGEX_FLAG = 1;
    public static final int NO_CASE_FLAG = 2;
    private JTextComponent input;
    private JCheckBox caseSensitive;
    private JCheckBox regularExpression;
    private JButton okButton;
    private ExtTable<?> owner;

    public SearchDialog(int flag, ExtTable<?> extTable) throws IOException {
        super(Dialog.getInstance().getParentOwner());
        Dimension screenSize;
        this.owner = extTable;
        this.setTitle(Tl8.EXTTABLE_SEARCH_DIALOG_TITLE.toString());
        this.caseSensitive = new JCheckBox(Tl8.SEARCHDIALOG_CHECKBOX_CASESENSITIVE.toString());
        this.regularExpression = new JCheckBox(Tl8.SEARCHDIALOG_CHECKBOX_REGULAREXPRESSION.toString());
        try {
            this.caseSensitive.setSelected(ConfigInterface.getStorage("SearchDialog_" + this.owner.getTableID()).get("caseSensitive", false));
            this.regularExpression.setSelected(ConfigInterface.getStorage("SearchDialog_" + this.owner.getTableID()).get("regularExpression", false));
            ActionListener saveListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigInterface.getStorage("SearchDialog_" + SearchDialog.this.owner.getTableID()).put("caseSensitive", SearchDialog.this.caseSensitive.isSelected());
                    ConfigInterface.getStorage("SearchDialog_" + SearchDialog.this.owner.getTableID()).put("regularExpression", SearchDialog.this.regularExpression.isSelected());
                }
            };
            this.caseSensitive.addActionListener(saveListener);
            this.regularExpression.addActionListener(saveListener);
        }
        catch (Exception e) {
            Log.exception(e);
        }
        this.caseSensitive.setVisible(BinaryLogic.containsNone(flag, 2));
        this.regularExpression.setVisible(BinaryLogic.containsNone(flag, 1));
        this.setLayout((LayoutManager)new MigLayout("ins 5", "[fill,grow]", "[fill,grow][][]"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.okButton = new JButton(Tl8.SEARCHDIALOG_BUTTON_FIND.toString());
        this.okButton.addActionListener(this);
        this.add((Component)new JLabel(ImageProvider.getImageIcon("find", 32, 32)), "alignx left,aligny center,shrinkx,gapright 10,spany");
        this.input = new JTextField();
        this.input.setBorder(BorderFactory.createEtchedBorder());
        this.input.addKeyListener(this);
        this.add((Component)this.input, "pushy,growy,spanx,wrap");
        this.input.selectAll();
        this.add((Component)this.regularExpression, "");
        this.add((Component)this.caseSensitive, "");
        this.add((Component)this.okButton, "skip 2,alignx right,wrap");
        this.invalidate();
        this.pack();
        this.setResizable(false);
        this.toFront();
        if (Dialog.getInstance().getParentOwner() == null || !Dialog.getInstance().getParentOwner().isDisplayable() || !Dialog.getInstance().getParentOwner().isVisible()) {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(new Point((int)(screenSize.getWidth() - (double)this.getWidth()) / 2, (int)(screenSize.getHeight() - (double)this.getHeight()) / 2));
        } else if (Dialog.getInstance().getParentOwner().getExtendedState() == 1) {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(new Point((int)(screenSize.getWidth() - (double)this.getWidth() - 20.0), (int)(screenSize.getHeight() - (double)this.getHeight() - 60.0)));
        } else {
            this.setLocation(SwingUtils.getCenter(Dialog.getInstance().getParentOwner(), this));
        }
        KeyStroke ks = KeyStroke.getKeyStroke("ESCAPE");
        this.okButton.getInputMap().put(ks, "ESCAPE");
        this.okButton.getInputMap(1).put(ks, "ESCAPE");
        this.okButton.getInputMap(2).put(ks, "ESCAPE");
        this.okButton.getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -6666144330707394562L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.close();
            }
        });
        AbstractAction enterAction = new AbstractAction(){
            private static final long serialVersionUID = -1331741306700505613L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.okButton.doClick();
            }
        };
        ks = KeyStroke.getKeyStroke("ENTER");
        this.okButton.getInputMap().put(ks, "ENTER");
        this.okButton.getInputMap(1).put(ks, "ENTER");
        this.okButton.getInputMap(2).put(ks, "ENTER");
        this.okButton.getActionMap().put("ENTER", enterAction);
        this.setVisible(true);
        if (Dialog.getInstance().getParentOwner() != null) {
            Dialog.getInstance().getParentOwner().setAlwaysOnTop(true);
            Dialog.getInstance().getParentOwner().setAlwaysOnTop(false);
        }
        this.requestFocus();
        this.input.requestFocusInWindow();
        this.input.requestFocus();
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.input.requestFocusInWindow();
        this.input.requestFocus();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.close();
        }
    }

    private void close() {
        this.owner.removeFocusListener(this);
        this.dispose();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.close();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public String getReturnID() {
        return this.input.getText();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive.isSelected();
    }

    public boolean isRegex() {
        return this.regularExpression.isSelected();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);
}

