/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ChildHTMLCollection;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeListImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.SkipVisitorException;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.lobobrowser.html.domimpl.TextFilter;
import org.lobobrowser.html.domimpl.TextImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.js.event.JSEventListener;
import org.lobobrowser.html.js.event.JSEventTarget;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Strings;
import org.mozilla.javascript.Function;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
extends AbstractScriptableDelegate
implements Node,
ModelNode,
JSEventTarget {
    private static final NodeImpl[] EMPTY_ARRAY = new NodeImpl[0];
    private static final RenderState INVALID_RENDER_STATE = new StyleSheetRenderState(null);
    protected static final Logger logger = Logger.getLogger(NodeImpl.class.getName());
    protected UINode uiNode;
    protected ArrayList nodeList;
    protected volatile Document document;
    protected volatile Object treeLock = this;
    private ChildHTMLCollection childrenCollection;
    private Map userData;
    private Map userDataHandlers;
    protected volatile boolean notificationsSuspended = false;
    private volatile String prefix;
    protected volatile Node parentNode;
    private RenderState renderState = INVALID_RENDER_STATE;

    @Override
    public void addEventListener(String name, Function callback, Boolean capture) {
        this.getHtmlRendererContext().addEventListener(new JSEventListener(this, name, callback, capture == null ? false : capture));
    }

    @Override
    public void removeEventListener(String name, Function callback, Boolean capture) {
        this.getHtmlRendererContext().removeEventListener(new JSEventListener(this, name, callback, capture == null ? false : capture));
    }

    @Override
    public void addEventListener(String name, Function callback) {
        this.addEventListener(name, callback, false);
    }

    @Override
    public void removeEventListener(String name, Function callback) {
        this.removeEventListener(name, callback, false);
    }

    public void setUINode(UINode uiNode) {
        this.uiNode = uiNode;
    }

    public UINode getUINode() {
        return this.uiNode;
    }

    public UINode findUINode() {
        UINode uiNode = this.uiNode;
        if (uiNode != null) {
            return uiNode;
        }
        NodeImpl parentNode = (NodeImpl)this.getParentNode();
        return parentNode == null ? null : parentNode.findUINode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node appendChild(Node newChild) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            if (nl == null) {
                this.nodeList = nl = new ArrayList<Node>(3);
            }
            nl.add(newChild);
            if (newChild instanceof NodeImpl) {
                ((NodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllChildren() {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeAllChildrenImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllChildrenImpl() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                nl.clear();
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeList getNodeList(NodeFilter filter) {
        ArrayList collection = new ArrayList();
        Object object = this.treeLock;
        synchronized (object) {
            this.appendChildrenToCollectionImpl(filter, collection);
        }
        return new NodeListImpl(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeImpl[] getChildrenArray() {
        ArrayList nl = this.nodeList;
        Object object = this.treeLock;
        synchronized (object) {
            return nl == null ? null : nl.toArray(EMPTY_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getChildCount() {
        ArrayList nl = this.nodeList;
        Object object = this.treeLock;
        synchronized (object) {
            return nl == null ? 0 : nl.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildHTMLCollection getChildren() {
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            ChildHTMLCollection collection = this.childrenCollection;
            if (collection == null) {
                this.childrenCollection = collection = new ChildHTMLCollection(this);
            }
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDescendents(NodeFilter filter, boolean nestIntoMatchingNodes) {
        ArrayList al = new ArrayList();
        Object object = this.treeLock;
        synchronized (object) {
            this.extractDescendentsArrayImpl(filter, al, nestIntoMatchingNodes);
        }
        return al;
    }

    private void extractDescendentsArrayImpl(NodeFilter filter, ArrayList al, boolean nestIntoMatchingNodes) {
        ArrayList nl = this.nodeList;
        if (nl != null) {
            for (NodeImpl n : nl) {
                if (filter.accept(n)) {
                    al.add(n);
                    if (!nestIntoMatchingNodes) continue;
                    n.extractDescendentsArrayImpl(filter, al, nestIntoMatchingNodes);
                    continue;
                }
                if (n.getNodeType() != 1) continue;
                n.extractDescendentsArrayImpl(filter, al, nestIntoMatchingNodes);
            }
        }
    }

    private void appendChildrenToCollectionImpl(NodeFilter filter, Collection collection) {
        ArrayList nl = this.nodeList;
        if (nl != null) {
            for (NodeImpl node : nl) {
                if (filter.accept(node)) {
                    collection.add(node);
                }
                node.appendChildrenToCollectionImpl(filter, collection);
            }
        }
    }

    protected abstract Node createSimilarNode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node cloneNode(boolean deep) {
        try {
            Node newNode = this.createSimilarNode();
            NodeList children = this.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                Node newChild = deep ? child.cloneNode(deep) : child;
                newNode.appendChild(newChild);
                ++i;
            }
            if (newNode instanceof Element) {
                Element elem = (Element)newNode;
                NamedNodeMap nnmap = this.getAttributes();
                if (nnmap != null) {
                    int nnlength = nnmap.getLength();
                    int i2 = 0;
                    while (i2 < nnlength) {
                        Attr attr = (Attr)nnmap.item(i2);
                        elem.setAttributeNode((Attr)attr.cloneNode(true));
                        ++i2;
                    }
                }
            }
            NodeImpl nodeImpl = this;
            synchronized (nodeImpl) {
                if (this.userDataHandlers != null && this.userData != null) {
                    for (Map.Entry entry : this.userDataHandlers.entrySet()) {
                        UserDataHandler handler = (UserDataHandler)entry.getValue();
                        handler.handle((short)1, (String)entry.getKey(), this.userData.get(entry.getKey()), this, newNode);
                    }
                }
            }
            return newNode;
        }
        catch (Exception err) {
            throw new IllegalStateException(err.getMessage());
        }
    }

    private int getNodeIndex() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        return parent == null ? -1 : parent.getChildIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getChildIndex(Node child) {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            return nl == null ? -1 : nl.indexOf(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getChildAtIndex(int index) {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            try {
                return nl == null ? null : (Node)nl.get(index);
            }
            catch (IndexOutOfBoundsException iob) {
                this.warn("getChildAtIndex(): Bad index=" + index + " for node=" + this + ".");
                return null;
            }
        }
    }

    private boolean isAncestorOf(Node other) {
        NodeImpl parent = (NodeImpl)other.getParentNode();
        if (parent == this) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        return this.isAncestorOf(parent);
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        Node parent = this.getParentNode();
        if (!(other instanceof NodeImpl)) {
            throw new DOMException(9, "Unknwon node implementation");
        }
        if (parent != null && parent == other.getParentNode()) {
            int thisIndex = this.getNodeIndex();
            int otherIndex = ((NodeImpl)other).getNodeIndex();
            if (thisIndex == -1 || otherIndex == -1) {
                return 32;
            }
            if (thisIndex < otherIndex) {
                return 4;
            }
            return 2;
        }
        if (this.isAncestorOf(other)) {
            return 16;
        }
        if (((NodeImpl)other).isAncestorOf(this)) {
            return 8;
        }
        return 1;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.document;
    }

    void setOwnerDocument(Document value) {
        this.document = value;
        this.treeLock = value == null ? this : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwnerDocument(Document value, boolean deep) {
        this.document = value;
        Object object = this.treeLock = value == null ? this : value;
        if (deep) {
            Object object2 = this.treeLock;
            synchronized (object2) {
                ArrayList nl = this.nodeList;
                if (nl != null) {
                    for (NodeImpl child : nl) {
                        child.setOwnerDocument(value, deep);
                    }
                }
            }
        }
    }

    void visitImpl(NodeVisitor visitor) {
        try {
            visitor.visit(this);
        }
        catch (SkipVisitorException sve) {
            return;
        }
        catch (StopVisitorException sve) {
            throw sve;
        }
        ArrayList nl = this.nodeList;
        if (nl != null) {
            for (NodeImpl child : nl) {
                child.visit(visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(NodeVisitor visitor) {
        Object object = this.treeLock;
        synchronized (object) {
            this.visitImpl(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(refChild);
            if (idx == -1) {
                throw new DOMException(8, "refChild not found");
            }
            nl.add(idx, newChild);
            if (newChild instanceof NodeImpl) {
                ((NodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node insertAt(Node newChild, int idx) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList<Node> nl = this.nodeList;
            if (nl == null) {
                this.nodeList = nl = new ArrayList<Node>();
            }
            nl.add(idx, newChild);
            if (newChild instanceof NodeImpl) {
                ((NodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(oldChild);
            if (idx == -1) {
                throw new DOMException(8, "oldChild not found");
            }
            nl.set(idx, newChild);
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl == null || !nl.remove(oldChild)) {
                throw new DOMException(8, "oldChild not found");
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return oldChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChildAt(int index) throws DOMException {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                ArrayList nl = this.nodeList;
                if (nl == null) {
                    throw new DOMException(1, "Empty list of children");
                }
                Node n = (Node)nl.remove(index);
                if (n == null) {
                    throw new DOMException(1, "No node with that index");
                }
                Node node = n;
                return node;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildNodes() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            return nl != null && !nl.isEmpty();
        }
    }

    @Override
    public String getBaseURI() {
        Document document = this.document;
        return document == null ? null : document.getBaseURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeList getChildNodes() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            return new NodeListImpl(nl == null ? Collections.EMPTY_LIST : nl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getFirstChild() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            try {
                return nl == null ? null : (Node)nl.get(0);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getLastChild() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            try {
                return nl == null ? null : (Node)nl.get(nl.size() - 1);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getPreviousTo(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(node);
            if (idx == -1) {
                throw new DOMException(8, "node not found");
            }
            try {
                return (Node)nl.get(idx - 1);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getNextTo(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(node);
            if (idx == -1) {
                throw new DOMException(8, "node not found");
            }
            try {
                return (Node)nl.get(idx + 1);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    @Override
    public Node getPreviousSibling() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        return parent == null ? null : parent.getPreviousTo(this);
    }

    @Override
    public Node getNextSibling() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        return parent == null ? null : parent.getNextTo(this);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key)) {
            boolean ns;
            this.notificationsSuspended = ns = Boolean.TRUE == data;
            if (!ns) {
                this.informNodeLoaded();
            }
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (handler != null) {
                if (this.userDataHandlers == null) {
                    this.userDataHandlers = new HashMap();
                } else if (handler == null) {
                    this.userDataHandlers.remove(key);
                }
                if (handler != null) {
                    this.userDataHandlers.put(key, handler);
                }
            }
            HashMap<String, Object> userData = this.userData;
            if (data != null) {
                if (userData == null) {
                    this.userData = userData = new HashMap<String, Object>();
                }
                return userData.put(key, data);
            }
            if (userData != null) {
                return userData.remove(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(String key) {
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            Map ud = this.userData;
            return ud == null ? null : ud.get(key);
        }
    }

    @Override
    public abstract String getLocalName();

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public abstract String getNodeName();

    @Override
    public abstract String getNodeValue() throws DOMException;

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.prefix = prefix;
    }

    @Override
    public abstract void setNodeValue(String var1) throws DOMException;

    @Override
    public abstract short getNodeType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTextContent() throws DOMException {
        StringBuffer sb = new StringBuffer();
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                for (Node node : nl) {
                    short type = node.getNodeType();
                    switch (type) {
                        case 1: 
                        case 3: 
                        case 4: {
                            String textContent = node.getTextContent();
                            if (textContent == null) break;
                            sb.append(textContent);
                            break;
                        }
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTextContent(String textContent) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeChildrenImpl(new TextFilter());
            if (textContent != null && !"".equals(textContent)) {
                TextImpl t = new TextImpl(textContent);
                t.setOwnerDocument(this.document);
                t.setParentImpl(this);
                ArrayList<TextImpl> nl = this.nodeList;
                if (nl == null) {
                    this.nodeList = nl = new ArrayList<TextImpl>();
                }
                nl.add(t);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChildren(NodeFilter filter) {
        Object object = this.treeLock;
        synchronized (object) {
            this.removeChildrenImpl(filter);
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    protected void removeChildrenImpl(NodeFilter filter) {
        ArrayList nl = this.nodeList;
        if (nl != null) {
            int len;
            int i = len = nl.size();
            while (--i >= 0) {
                Node node = (Node)nl.get(i);
                if (!filter.accept(node)) continue;
                nl.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node insertAfter(Node newChild, Node refChild) {
        Object object = this.treeLock;
        synchronized (object) {
            int idx;
            ArrayList nl = this.nodeList;
            int n = idx = nl == null ? -1 : nl.indexOf(refChild);
            if (idx == -1) {
                throw new DOMException(8, "refChild not found");
            }
            nl.add(idx + 1, newChild);
            if (newChild instanceof NodeImpl) {
                ((NodeImpl)newChild).setParentImpl(this);
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Text replaceAdjacentTextNodes(Text node, String textContent) {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                ArrayList nl = this.nodeList;
                if (nl == null) {
                    throw new DOMException(8, "Node not a child");
                }
                int idx = nl.indexOf(node);
                if (idx == -1) {
                    throw new DOMException(8, "Node not a child");
                }
                int firstIdx = idx;
                LinkedList toDelete = new LinkedList();
                int adjIdx = idx;
                while (--adjIdx >= 0) {
                    Object child = this.nodeList.get(adjIdx);
                    if (!(child instanceof Text)) continue;
                    firstIdx = adjIdx;
                    toDelete.add(child);
                }
                int length = this.nodeList.size();
                int adjIdx2 = idx;
                while (++adjIdx2 < length) {
                    Object child = this.nodeList.get(adjIdx2);
                    if (!(child instanceof Text)) continue;
                    toDelete.add(child);
                }
                this.nodeList.removeAll(toDelete);
                TextImpl textNode = new TextImpl(textContent);
                textNode.setOwnerDocument(this.document);
                textNode.setParentImpl(this);
                this.nodeList.add(firstIdx, textNode);
                TextImpl textImpl = textNode;
                return textImpl;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Text replaceAdjacentTextNodes(Text node) {
        try {
            Object object = this.treeLock;
            synchronized (object) {
                ArrayList nl = this.nodeList;
                if (nl == null) {
                    throw new DOMException(8, "Node not a child");
                }
                int idx = nl.indexOf(node);
                if (idx == -1) {
                    throw new DOMException(8, "Node not a child");
                }
                StringBuffer textBuffer = new StringBuffer();
                int firstIdx = idx;
                LinkedList toDelete = new LinkedList();
                int adjIdx = idx;
                while (--adjIdx >= 0) {
                    Object child = this.nodeList.get(adjIdx);
                    if (!(child instanceof Text)) continue;
                    firstIdx = adjIdx;
                    toDelete.add(child);
                    textBuffer.append(((Text)child).getNodeValue());
                }
                int length = this.nodeList.size();
                int adjIdx2 = idx;
                while (++adjIdx2 < length) {
                    Object child = this.nodeList.get(adjIdx2);
                    if (!(child instanceof Text)) continue;
                    toDelete.add(child);
                    textBuffer.append(((Text)child).getNodeValue());
                }
                this.nodeList.removeAll(toDelete);
                TextImpl textNode = new TextImpl(textBuffer.toString());
                textNode.setOwnerDocument(this.document);
                textNode.setParentImpl(this);
                this.nodeList.add(firstIdx, textNode);
                TextImpl textImpl = textNode;
                return textImpl;
            }
        }
        finally {
            if (!this.notificationsSuspended) {
                this.informStructureInvalid();
            }
        }
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public boolean isSameNode(Node other) {
        return this == other;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return "HTML".equals(feature) && version.compareTo("4.01") <= 0;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public boolean equalAttributes(Node arg) {
        return false;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return arg instanceof NodeImpl && this.getNodeType() == arg.getNodeType() && Objects.equals(this.getNodeName(), arg.getNodeName()) && Objects.equals(this.getNodeValue(), arg.getNodeValue()) && Objects.equals(this.getLocalName(), arg.getLocalName()) && Objects.equals(this.nodeList, ((NodeImpl)arg).nodeList) && this.equalAttributes(arg);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return namespaceURI == null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normalize() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                Iterator i = nl.iterator();
                LinkedList<Node> textNodes = new LinkedList<Node>();
                boolean prevText = false;
                while (i.hasNext()) {
                    Node node = (Node)i.next();
                    if (node.getNodeType() == 3) {
                        if (prevText) continue;
                        prevText = true;
                        textNodes.add(node);
                        continue;
                    }
                    prevText = false;
                }
                for (Text text : textNodes) {
                    this.replaceAdjacentTextNodes(text);
                }
            }
        }
        if (!this.notificationsSuspended) {
            this.informStructureInvalid();
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    public UserAgentContext getUserAgentContext() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getUserAgentContext();
        }
        return null;
    }

    public HtmlRendererContext getHtmlRendererContext() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getHtmlRendererContext();
        }
        return null;
    }

    final void setParentImpl(Node parent) {
        this.parentNode = parent;
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    @Override
    public URL getFullURL(String spec) throws MalformedURLException {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getFullURL(spec);
        }
        return new URL(spec);
    }

    public URL getDocumentURL() {
        Document doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)doc).getDocumentURL();
        }
        return null;
    }

    @Override
    public Object getDocumentItem(String name) {
        Document document = this.document;
        return document == null ? null : document.getUserData(name);
    }

    @Override
    public void setDocumentItem(String name, Object value) {
        Document document = this.document;
        if (document == null) {
            return;
        }
        document.setUserData(name, value, null);
    }

    @Override
    public final boolean isEqualOrDescendentOf(ModelNode otherContext) {
        if (otherContext == this) {
            return true;
        }
        Node parent = this.getParentNode();
        if (parent instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)parent).isEqualOrDescendentOf(otherContext);
        }
        return false;
    }

    @Override
    public final ModelNode getParentModelNode() {
        return (ModelNode)((Object)this.parentNode);
    }

    @Override
    public void warn(String message, Throwable err) {
        logger.log(Level.WARNING, message, err);
    }

    public void warn(String message) {
        logger.log(Level.WARNING, message);
    }

    public void informSizeInvalid() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.sizeInvalidated(this);
        }
    }

    public void informLookInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.lookInvalidated(this);
        }
    }

    public void informPositionInvalid() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.positionInParentInvalidated(this);
        }
    }

    public void informInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.invalidated(this);
        }
    }

    public void informStructureInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.structureInvalidated(this);
        }
    }

    protected void informNodeLoaded() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.nodeLoaded(this);
        }
    }

    protected void informExternalScriptLoading() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.externalScriptLoading(this);
        }
    }

    public void informLayoutInvalid() {
        this.forgetRenderState();
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.invalidated(this);
        }
    }

    public void informDocumentInvalid() {
        HTMLDocumentImpl doc = (HTMLDocumentImpl)this.document;
        if (doc != null) {
            doc.allInvalidated(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenderState getRenderState() {
        Object object = this.treeLock;
        synchronized (object) {
            RenderState rs = this.renderState;
            if (rs != INVALID_RENDER_STATE) {
                return rs;
            }
            Node parent = this.parentNode;
            if (parent != null || this instanceof Document) {
                RenderState prs = this.getParentRenderState(parent);
                this.renderState = rs = this.createRenderState(prs);
                return rs;
            }
            return null;
        }
    }

    protected final RenderState getParentRenderState(Object parent) {
        if (parent instanceof NodeImpl) {
            return ((NodeImpl)parent).getRenderState();
        }
        return null;
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        return prevRenderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forgetRenderState() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.renderState != INVALID_RENDER_STATE) {
                this.renderState = INVALID_RENDER_STATE;
                ArrayList nl = this.nodeList;
                if (nl != null) {
                    Iterator i = nl.iterator();
                    while (i.hasNext()) {
                        ((NodeImpl)i.next()).forgetRenderState();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerHTML() {
        StringBuffer buffer = new StringBuffer();
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            this.appendInnerHTMLImpl(buffer);
        }
        return buffer.toString();
    }

    protected void appendInnerHTMLImpl(StringBuffer buffer) {
        int size;
        ArrayList nl = this.nodeList;
        if (nl != null && (size = nl.size()) > 0) {
            int i = 0;
            while (i < size) {
                Node child = (Node)nl.get(i);
                if (child instanceof HTMLElementImpl) {
                    ((HTMLElementImpl)child).appendOuterHTMLImpl(buffer);
                } else if (child instanceof Comment) {
                    buffer.append("<!--" + ((Comment)child).getTextContent() + "-->");
                } else if (child instanceof Text) {
                    String text = ((Text)child).getTextContent();
                    String encText = this.htmlEncodeChildText(text);
                    buffer.append(encText);
                } else if (child instanceof ProcessingInstruction) {
                    buffer.append(child.toString());
                }
                ++i;
            }
        }
    }

    protected String htmlEncodeChildText(String text) {
        return Strings.strictHtmlEncode(text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerText() {
        StringBuffer buffer = new StringBuffer();
        Object object = this.treeLock;
        synchronized (object) {
            this.appendInnerTextImpl(buffer);
        }
        return buffer.toString();
    }

    protected void appendInnerTextImpl(StringBuffer buffer) {
        ArrayList nl = this.nodeList;
        if (nl == null) {
            return;
        }
        int size = nl.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            Node child = (Node)nl.get(i);
            if (child instanceof ElementImpl) {
                ((ElementImpl)child).appendInnerTextImpl(buffer);
            }
            if (!(child instanceof Comment) && child instanceof Text) {
                buffer.append(((Text)child).getTextContent());
            }
            ++i;
        }
    }
}

