/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js.event;

import java.net.MalformedURLException;
import java.net.URL;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.js.Event;
import org.lobobrowser.html.js.SecurityControllerImpl;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.html.js.event.BasicEvent;
import org.lobobrowser.js.JavaScript;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.w3c.dom.Document;

public class JSEventListener {
    private NodeImpl owner;
    private String name;
    private Function callback;
    private boolean capture;
    private Window window;

    public NodeImpl getOwner() {
        return this.owner;
    }

    public void setOwner(NodeImpl owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Function getCallback() {
        return this.callback;
    }

    public void setCallback(Function callback) {
        this.callback = callback;
    }

    public boolean isCapture() {
        return this.capture;
    }

    public void setCapture(boolean capture) {
        this.capture = capture;
    }

    public JSEventListener(NodeImpl owner, String name, Function callback, boolean capture) {
        this.owner = owner;
        this.name = name;
        this.callback = callback;
        this.capture = capture;
    }

    public JSEventListener(Window window, String name, Function callback, boolean capture) {
        this.window = window;
        this.name = name;
        this.callback = callback;
        this.capture = capture;
    }

    public boolean dispatch(BasicEvent basicEvent) {
        if (basicEvent.getSrcElement() == null) {
            if (this.owner == null) {
                try {
                    return JSEventListener.executeFunction(this.window, this.callback, new Event(basicEvent.getType(), basicEvent.getSrcElement()));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                return JSEventListener.executeFunction(this.owner, this.callback, new Event(basicEvent.getType(), basicEvent.getSrcElement()));
            }
        }
        return false;
    }

    public static Context createContext(URL codeSource, UserAgentContext ucontext) {
        Context prev = Context.getCurrentContext();
        Context ctx = Context.enter();
        ctx.setOptimizationLevel(ucontext.getScriptingOptimizationLevel());
        if (prev == null) {
            ctx.setSecurityController((SecurityController)new SecurityControllerImpl(codeSource, ucontext.getSecurityPolicy()));
        }
        return ctx;
    }

    public static boolean executeFunction(Window element, Function f, Event event) throws MalformedURLException {
        try {
            Context ctx = JSEventListener.createContext(new URL(element.getDocumentNode().getDocumentURI()), element.getUserAgentContext());
            Scriptable scope = element.getWindowScope();
            if (scope == null) {
                throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
            }
            JavaScript js = JavaScript.getInstance();
            try {
                Scriptable eventScriptable = (Scriptable)js.getJavascriptObject(event, scope);
                ScriptableObject.defineProperty((Scriptable)scope, (String)"event", (Object)eventScriptable, (int)1);
                System.out.println("Run Function \r\n" + ctx.decompileFunction(f, 1));
                Object result = f.call(ctx, scope, scope, new Object[]{event});
                if (!(result instanceof Boolean)) {
                    return true;
                }
                boolean bl = (Boolean)result;
                return bl;
            }
            catch (Throwable thrown) {
                thrown.printStackTrace();
                return true;
            }
        }
        finally {
            Context.exit();
        }
    }

    public static boolean executeFunction(NodeImpl element, Function f, Event event) {
        Document doc = element.getOwnerDocument();
        if (doc == null) {
            throw new IllegalStateException("Element does not belong to a document.");
        }
        Context ctx = JSEventListener.createContext(element.getDocumentURL(), element.getUserAgentContext());
        try {
            Scriptable scope = (Scriptable)doc.getUserData("cobra.js.scope");
            if (scope == null) {
                throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
            }
            JavaScript js = JavaScript.getInstance();
            Scriptable thisScope = (Scriptable)js.getJavascriptObject(element, scope);
            try {
                Scriptable eventScriptable = (Scriptable)js.getJavascriptObject(event, thisScope);
                ScriptableObject.defineProperty((Scriptable)thisScope, (String)"event", (Object)eventScriptable, (int)1);
                System.out.println("Run Function \r\n" + ctx.decompileFunction(f, 1));
                Object result = f.call(ctx, thisScope, thisScope, new Object[]{event});
                if (!(result instanceof Boolean)) {
                    return true;
                }
                boolean bl = (Boolean)result;
                return bl;
            }
            catch (Throwable thrown) {
                thrown.printStackTrace();
                return true;
            }
        }
        finally {
            Context.exit();
        }
    }
}

