/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;

abstract class BaseRCollection
extends BaseBoundableRenderable
implements RCollection {
    private BoundableRenderable renderableWithMouse = null;

    public BaseRCollection(RenderableContainer container, ModelNode modelNode) {
        super(container, modelNode);
    }

    @Override
    public void focus() {
        this.container.focus();
    }

    @Override
    public void blur() {
        RCollection parent = this.parent;
        if (parent != null) {
            parent.focus();
        }
    }

    @Override
    public void updateWidgetBounds(int guiX, int guiY) {
        Iterator i = this.getRenderables();
        if (i != null) {
            while (i.hasNext()) {
                Object r = i.next();
                if (!(r instanceof RCollection)) continue;
                RCollection rc = (RCollection)r;
                rc.updateWidgetBounds(guiX + rc.getX(), guiY + rc.getY());
            }
        }
    }

    private boolean checkStartSelection(Rectangle bounds, Point selectionPoint) {
        if (bounds.y > selectionPoint.y) {
            return true;
        }
        return selectionPoint.y >= bounds.y && selectionPoint.y < bounds.y + bounds.height && bounds.x > selectionPoint.x;
    }

    private boolean checkEndSelection(Rectangle bounds, Point selectionPoint) {
        if (bounds.y > selectionPoint.y) {
            return true;
        }
        return selectionPoint.y >= bounds.y && selectionPoint.y < bounds.y + bounds.height && selectionPoint.x < bounds.x;
    }

    @Override
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Point checkPoint1 = null;
        Point checkPoint2 = null;
        if (!inSelection) {
            boolean isEnd;
            boolean isStart = startPoint.renderable == this;
            boolean bl = isEnd = endPoint.renderable == this;
            if (isStart && isEnd) {
                checkPoint1 = startPoint.getPoint();
                checkPoint2 = endPoint.getPoint();
            } else if (isStart) {
                checkPoint1 = startPoint.getPoint();
            } else if (isEnd) {
                checkPoint1 = endPoint.getPoint();
            }
        } else if (startPoint.renderable == this) {
            checkPoint1 = startPoint.getPoint();
        } else if (endPoint.renderable == this) {
            checkPoint1 = endPoint.getPoint();
        }
        Iterator i = this.getRenderables();
        if (i != null) {
            while (i.hasNext()) {
                Object robj = i.next();
                if (!(robj instanceof BoundableRenderable)) continue;
                BoundableRenderable renderable = (BoundableRenderable)robj;
                Rectangle bounds = renderable.getBounds();
                if (!inSelection) {
                    if (checkPoint1 != null && this.checkStartSelection(bounds, checkPoint1)) {
                        if (checkPoint2 != null) {
                            checkPoint1 = checkPoint2;
                            checkPoint2 = null;
                        } else {
                            checkPoint1 = null;
                        }
                        inSelection = true;
                    } else if (checkPoint2 != null && this.checkStartSelection(bounds, checkPoint2)) {
                        checkPoint1 = null;
                        checkPoint2 = null;
                        inSelection = true;
                    }
                } else if (inSelection && checkPoint1 != null && this.checkEndSelection(bounds, checkPoint1)) {
                    return false;
                }
                int offsetX = bounds.x;
                int offsetY = bounds.y;
                g.translate(offsetX, offsetY);
                try {
                    boolean newInSelection = renderable.paintSelection(g, inSelection, startPoint, endPoint);
                    if (inSelection && !newInSelection) {
                        return false;
                    }
                    inSelection = newInSelection;
                }
                finally {
                    g.translate(-offsetX, -offsetY);
                }
            }
        }
        if (inSelection && checkPoint1 != null) {
            return false;
        }
        if (!(inSelection || checkPoint1 == null && checkPoint2 == null || checkPoint1 != null && checkPoint2 != null)) {
            return true;
        }
        return inSelection;
    }

    @Override
    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Point checkPoint1 = null;
        Point checkPoint2 = null;
        if (!inSelection) {
            boolean isEnd;
            boolean isStart = startPoint.renderable == this;
            boolean bl = isEnd = endPoint.renderable == this;
            if (isStart && isEnd) {
                checkPoint1 = startPoint.getPoint();
                checkPoint2 = endPoint.getPoint();
            } else if (isStart) {
                checkPoint1 = startPoint.getPoint();
            } else if (isEnd) {
                checkPoint1 = endPoint.getPoint();
            }
        } else if (startPoint.renderable == this) {
            checkPoint1 = startPoint.getPoint();
        } else if (endPoint.renderable == this) {
            checkPoint1 = endPoint.getPoint();
        }
        Iterator i = this.getRenderables();
        if (i != null) {
            while (i.hasNext()) {
                Object robj = i.next();
                if (!(robj instanceof BoundableRenderable)) continue;
                BoundableRenderable renderable = (BoundableRenderable)robj;
                if (!inSelection) {
                    Rectangle bounds = renderable.getBounds();
                    if (checkPoint1 != null && this.checkStartSelection(bounds, checkPoint1)) {
                        if (checkPoint2 != null) {
                            checkPoint1 = checkPoint2;
                            checkPoint2 = null;
                        } else {
                            checkPoint1 = null;
                        }
                        inSelection = true;
                    } else if (checkPoint2 != null && this.checkStartSelection(bounds, checkPoint2)) {
                        checkPoint1 = null;
                        checkPoint2 = null;
                        inSelection = true;
                    }
                } else if (inSelection && checkPoint1 != null && this.checkEndSelection(renderable.getBounds(), checkPoint1)) {
                    return false;
                }
                boolean newInSelection = renderable.extractSelectionText(buffer, inSelection, startPoint, endPoint);
                if (inSelection && !newInSelection) {
                    return false;
                }
                inSelection = newInSelection;
            }
        }
        if (inSelection && checkPoint1 != null) {
            return false;
        }
        if (!(inSelection || checkPoint1 == null && checkPoint2 == null || checkPoint1 != null && checkPoint2 != null)) {
            return true;
        }
        return inSelection;
    }

    @Override
    public void invalidateLayoutDeep() {
        this.invalidateLayoutLocal();
        Iterator renderables = this.getRenderables();
        if (renderables != null) {
            while (renderables.hasNext()) {
                Object r = renderables.next();
                if (!(r instanceof RCollection)) continue;
                ((RCollection)r).invalidateLayoutDeep();
            }
        }
    }

    @Override
    public void onMouseMoved(MouseEvent event, int x, int y, boolean triggerEvent, ModelNode limit) {
        boolean changed;
        super.onMouseMoved(event, x, y, triggerEvent, limit);
        BoundableRenderable oldRenderable = this.renderableWithMouse;
        BoundableRenderable r = this.getRenderable(x, y);
        BoundableRenderable newRenderable = r instanceof BoundableRenderable ? r : null;
        ModelNode newLimit = this.isContainedByNode() ? this.modelNode : limit;
        boolean bl = changed = oldRenderable != newRenderable;
        if (changed) {
            if (oldRenderable != null) {
                oldRenderable.onMouseOut(event, x - oldRenderable.getX(), y - oldRenderable.getY(), newLimit);
            }
            this.renderableWithMouse = newRenderable;
        }
        if (newRenderable != null) {
            newRenderable.onMouseMoved(event, x - newRenderable.getX(), y - newRenderable.getY(), changed, newLimit);
        }
    }

    @Override
    public void onMouseOut(MouseEvent event, int x, int y, ModelNode limit) {
        super.onMouseOut(event, x, y, limit);
        BoundableRenderable oldRenderable = this.renderableWithMouse;
        if (oldRenderable != null) {
            this.renderableWithMouse = null;
            ModelNode newLimit = this.isContainedByNode() ? this.modelNode : limit;
            oldRenderable.onMouseOut(event, x - oldRenderable.getX(), y - oldRenderable.getY(), newLimit);
        }
    }

    public BoundableRenderable getRenderable(int x, int y) {
        Iterator i = this.getRenderables();
        if (i != null) {
            while (i.hasNext()) {
                Object r = i.next();
                if (!(r instanceof BoundableRenderable)) continue;
                BoundableRenderable br = (BoundableRenderable)r;
                int bx = br.getX();
                int by = br.getY();
                if (y < by || y >= by + br.getHeight() || x < bx || x >= bx + br.getWidth()) continue;
                return br;
            }
        }
        return null;
    }

    @Override
    public boolean onRightClick(MouseEvent event, int x, int y) {
        BoundableRenderable br = this.getRenderable(x, y);
        if (br == null) {
            return HtmlController.getInstance().onContextMenu(this.modelNode, event, x, y);
        }
        return br.onRightClick(event, x - br.getX(), y - br.getY());
    }
}

