/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class Bean {
    private final Class clazz;
    private Map propertyDescriptors = null;

    public Bean(Class clazz) {
        this.clazz = clazz;
    }

    private void populateDescriptors(Map map, Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < pds.length) {
            map.put(pds[i].getName(), pds[i]);
            ++i;
        }
        if (clazz.isInterface()) {
            Type[] interfaces = clazz.getGenericInterfaces();
            int i2 = 0;
            while (i2 < interfaces.length) {
                this.populateDescriptors(map, (Class)interfaces[i2]);
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws IntrospectionException {
        Bean bean = this;
        synchronized (bean) {
            if (this.propertyDescriptors == null) {
                this.propertyDescriptors = new HashMap();
                this.populateDescriptors(this.propertyDescriptors, this.clazz);
            }
            return (PropertyDescriptor)this.propertyDescriptors.get(propertyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPropertyDescriptorsMap() throws IntrospectionException {
        Bean bean = this;
        synchronized (bean) {
            if (this.propertyDescriptors == null) {
                this.propertyDescriptors = new HashMap();
                this.populateDescriptors(this.propertyDescriptors, this.clazz);
            }
            return this.propertyDescriptors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDescriptor[] getPropertyDescriptors() throws IntrospectionException {
        Bean bean = this;
        synchronized (bean) {
            return this.getPropertyDescriptorsMap().values().toArray(new PropertyDescriptor[0]);
        }
    }

    public void setPropertyForFQN(Object receiver, String fullyQualifiedPropertyName, Object value) throws Exception {
        int idx = fullyQualifiedPropertyName.indexOf(46);
        if (idx == -1) {
            PropertyDescriptor pd = this.getPropertyDescriptor(fullyQualifiedPropertyName);
            if (pd == null) {
                throw new IllegalStateException("Property '" + fullyQualifiedPropertyName + "' unknown");
            }
            Method method = pd.getWriteMethod();
            if (method == null) {
                throw new IllegalStateException("Property '" + fullyQualifiedPropertyName + "' not settable");
            }
            Object actualValue = Bean.convertValue(value, pd.getPropertyType());
            method.invoke(receiver, actualValue);
        } else {
            String prefix = fullyQualifiedPropertyName.substring(0, idx);
            PropertyDescriptor pinfo = this.getPropertyDescriptor(prefix);
            if (pinfo == null) {
                throw new IllegalStateException("Property '" + prefix + "' unknown");
            }
            Method readMethod = pinfo.getReadMethod();
            if (readMethod == null) {
                throw new IllegalStateException("Property '" + prefix + "' not readable");
            }
            Object newReceiver = readMethod.invoke(receiver, new Object[0]);
            String nameRest = fullyQualifiedPropertyName.substring(idx + 1);
            this.setPropertyForFQN(newReceiver, nameRest, value);
        }
    }

    private static Object convertValue(Object value, Class targetType) {
        boolean targetString = targetType.isAssignableFrom(String.class);
        if (!(value instanceof String) || !targetString) {
            if (targetString) {
                value = String.valueOf(value);
            } else if (!(value instanceof Byte || targetType != Byte.class && targetType != Byte.TYPE)) {
                value = Byte.valueOf(String.valueOf(value));
            } else if (!(value instanceof Boolean || targetType != Boolean.class && targetType != Boolean.TYPE)) {
                value = Boolean.valueOf(String.valueOf(value));
            } else if (!(value instanceof Short || targetType != Short.class && targetType != Short.TYPE)) {
                value = Short.valueOf(String.valueOf(value));
            } else if (!(value instanceof Integer || targetType != Integer.class && targetType != Integer.TYPE)) {
                value = Integer.valueOf(String.valueOf(value));
            } else if (!(value instanceof Long || targetType != Long.class && targetType != Long.TYPE)) {
                value = Long.valueOf(String.valueOf(value));
            }
        }
        return value;
    }
}

