/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

public class Objects {
    private Objects() {
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static boolean isBoxClass(Class clazz) {
        return clazz == Integer.class || clazz == Boolean.class || clazz == Double.class || clazz == Float.class || clazz == Long.class || clazz == Byte.class || clazz == Short.class || clazz == Character.class;
    }

    public static boolean areAssignableTo(Object[] objects, Class[] types, boolean acceptObjectToStringConversion) {
        int length = objects.length;
        if (length != types.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!Objects.isAssignableOrBox(objects[i], types[i], acceptObjectToStringConversion)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAssignableOrBox(Object value, Class clazz, boolean acceptObjectToStringConversion) {
        if (clazz.isInstance(value)) {
            return true;
        }
        if (clazz.isPrimitive() && (clazz == Double.TYPE && value instanceof Double || clazz == Integer.TYPE && value instanceof Integer || clazz == Long.TYPE && value instanceof Long || clazz == Boolean.TYPE && value instanceof Boolean || clazz == Byte.TYPE && value instanceof Byte || clazz == Character.TYPE && value instanceof Character || clazz == Short.TYPE && value instanceof Short || clazz == Float.TYPE && value instanceof Float)) {
            return true;
        }
        if (Objects.isNumeric(clazz) && Objects.isNumeric(value)) {
            return true;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return value == null || !value.getClass().isPrimitive() && acceptObjectToStringConversion;
        }
        return false;
    }

    private static boolean isNumeric(Class clazz) {
        return Number.class.isAssignableFrom(clazz) || clazz.isPrimitive() && (clazz == Integer.TYPE || clazz == Double.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Float.TYPE || clazz == Long.TYPE);
    }

    private static boolean isNumeric(Object value) {
        if (value == null) {
            return false;
        }
        return Objects.isNumeric(value.getClass());
    }
}

