/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Frame;
import java.awt.Graphics;

public class GUITasks {
    public static Frame getTopFrame() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].getFocusOwner() != null) {
                return frames[i];
            }
            ++i;
        }
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public static void drawDashed(Graphics g, int x1, int y1, int x2, int y2, int dashSize, int gapSize) {
        int temp;
        if (x2 < x1) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y2 < y1) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        int totalDash = dashSize + gapSize;
        if (y1 == y2) {
            int virtualStartX;
            int x = virtualStartX = x1 / totalDash * totalDash;
            while (x < x2) {
                int firstX;
                int topX = x + dashSize;
                if (topX > x2) {
                    topX = x2;
                }
                if ((firstX = x) < x1) {
                    firstX = x1;
                }
                if (firstX < topX) {
                    g.drawLine(firstX, y1, topX, y1);
                }
                x += totalDash;
            }
        } else if (x1 == x2) {
            int virtualStartY;
            int y = virtualStartY = y1 / totalDash * totalDash;
            while (y < y2) {
                int firstY;
                int topY = y + dashSize;
                if (topY > y2) {
                    topY = y2;
                }
                if ((firstY = y) < y1) {
                    firstY = y1;
                }
                if (firstY < topY) {
                    g.drawLine(x1, firstY, x1, topY);
                }
                y += totalDash;
            }
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }
}

