/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jd.PluginWrapper;
import jd.controlling.DownloadWatchDog;
import jd.controlling.SingleDownloadController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.nutils.Executer;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.plugins.DownloadLink;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginForHost;
import jd.plugins.PluginOptional;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9538 $", id="growl", interfaceversion=5, windows=false, linux=false)
public class JDGrowlNotification
extends PluginOptional {
    private static final String JDL_PREFIX = "jd.plugins.optional.JDGrowlNotification.";

    public JDGrowlNotification(PluginWrapper wrapper) {
        super(wrapper);
    }

    public boolean initAddon() {
        JDUtilities.getController().addControlListener((ControlListener)this);
        if (!JDIO.copyFile((File)JDUtilities.getResourceFile((String)"jd/osx/growlNotification.scpt"), (File)JDUtilities.getResourceFile((String)"tmp/growlNotification.scpt", (boolean)true))) {
            logger.info("Growl Failed");
            return false;
        }
        logger.info("Growl OK");
        return true;
    }

    public ArrayList<MenuAction> createMenuitems() {
        return null;
    }

    public void controlEvent(ControlEvent event) {
        switch (event.getID()) {
            case 30: {
                this.growlNotification(JDL.L((String)"jd.plugins.optional.JDGrowlNotification.started", (String)"jDownloader started..."), this.getDateAndTime(), JDL.L((String)"jd.plugins.optional.JDGrowlNotification.started.title", (String)"Programstart"));
                break;
            }
            case 1: {
                if (DownloadWatchDog.getInstance().getDownloadssincelastStart() <= 0) break;
                this.growlNotification(JDL.L((String)"jd.plugins.optional.JDGrowlNotification.allfinished", (String)"All downloads stopped"), "", JDL.L((String)"jd.plugins.optional.JDGrowlNotification.allfinished.title", (String)"All downloads finished"));
                break;
            }
            case 4: {
                if (!(event.getSource() instanceof PluginForHost)) {
                    return;
                }
                DownloadLink lastLink = ((SingleDownloadController)event.getParameter()).getDownloadLink();
                if (!lastLink.getLinkStatus().hasStatus(2)) break;
                this.growlNotification(JDL.L((String)"jd.plugins.optional.JDGrowlNotification.finished", (String)"Download stopped"), lastLink.getFinalFileName(), JDL.L((String)"jd.plugins.optional.JDGrowlNotification.finished.title", (String)"Download complete"));
                break;
            }
        }
        super.controlEvent(event);
    }

    private void growlNotification(String headline, String message, String title) {
        if (OSDetector.isMac()) {
            Executer exec = new Executer("/usr/bin/osascript");
            exec.addParameter(JDUtilities.getResourceFile((String)"tmp/growlNotification.scpt").getAbsolutePath());
            exec.addParameter(headline);
            exec.addParameter(message);
            exec.addParameter(title);
            exec.start();
        }
    }

    public void onExit() {
        JDUtilities.getController().removeControlListener((ControlListener)this);
    }

    private String getDateAndTime() {
        SimpleDateFormat dfmt = new SimpleDateFormat("EEEE dd.MM.yy hh:mm:ss");
        return dfmt.format(new Date());
    }
}

