/*
 * Decompiled with CFR 0.152.
 */
package jd.http.requests;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.RequestVariable;
import jd.parser.html.Form;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostRequest
extends Request {
    private ArrayList<RequestVariable> postData = new ArrayList();
    private String postDataString = null;

    public PostRequest(Form form) throws MalformedURLException {
        super(form.getAction(null));
    }

    public PostRequest(String url) throws MalformedURLException {
        super(Browser.correctURL(url));
    }

    public String getPostDataString() {
        if (this.postData.isEmpty()) {
            return this.postDataString;
        }
        StringBuilder buffer = new StringBuilder();
        for (RequestVariable rv : this.postData) {
            if (rv.getKey() == null) continue;
            buffer.append("&");
            buffer.append(rv.getKey());
            buffer.append("=");
            if (rv.getValue() != null) {
                buffer.append(rv.getValue());
                continue;
            }
            buffer.append("");
        }
        if (buffer.length() == 0) {
            return "";
        }
        return buffer.toString().substring(1);
    }

    public void setPostDataString(String post) {
        this.postDataString = post;
    }

    @Override
    public void postRequest(URLConnectionAdapter httpConnection) throws IOException {
        String parameter;
        httpConnection.setDoOutput(true);
        String string = parameter = this.postDataString != null ? this.postDataString : this.getPostDataString();
        if (parameter != null) {
            if (this.postDataString == null) {
                parameter = parameter.trim();
            }
            httpConnection.setRequestProperty("Content-Length", String.valueOf(parameter.length()));
            httpConnection.connect();
            OutputStreamWriter wr = new OutputStreamWriter(httpConnection.getOutputStream());
            if (parameter != null) {
                wr.write(parameter);
            }
            wr.flush();
            wr.close();
        } else {
            httpConnection.setRequestProperty("Content-Length", "0");
        }
    }

    @Override
    public void preRequest(URLConnectionAdapter httpConnection) throws IOException {
        httpConnection.setRequestMethod("POST");
    }

    public void addVariable(String key, String value) {
        this.postData.add(new RequestVariable(key, value));
    }

    public static ArrayList<RequestVariable> variableMaptoArray(LinkedHashMap<String, String> post) {
        ArrayList<RequestVariable> ret = new ArrayList<RequestVariable>();
        Map.Entry<String, String> next2 = null;
        for (Map.Entry<String, String> next2 : post.entrySet()) {
            ret.add(new RequestVariable(next2.getKey(), next2.getValue()));
        }
        return ret;
    }

    public void addAll(HashMap<String, String> post) {
    }

    public void addAll(ArrayList<RequestVariable> post) {
        this.postData.addAll(post);
    }
}

