/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jd.controlling.JDLogger;

public class DynByteBuffer {
    private ByteBuffer buffer;

    public DynByteBuffer(int l) {
        this.buffer = ByteBuffer.allocateDirect(l);
    }

    public void put(byte[] buffer, int read) {
        this.checkBufferSize(read);
        this.buffer.put(buffer);
    }

    public void put(byte b) {
        this.checkBufferSize(1);
        this.buffer.put(b);
    }

    public void put(byte[] bytes, int off, int len) {
        this.checkBufferSize(len);
        this.buffer.put(bytes, off, len);
    }

    public void clear() {
        this.buffer.clear();
    }

    public String toString() {
        return new String(this.getLast(this.buffer.position()));
    }

    public byte[] toByteArray() {
        return this.getLast(this.buffer.position());
    }

    public String toString(String codepage) {
        try {
            return new String(this.getLast(this.buffer.position()), codepage);
        }
        catch (UnsupportedEncodingException e) {
            JDLogger.exception((Throwable)e);
            return new String(this.getLast(this.buffer.position()));
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int limit() {
        return this.buffer.limit();
    }

    public int position() {
        return this.buffer.position();
    }

    private void checkBufferSize(int read) {
        ByteBuffer newbuffer;
        if (this.buffer.remaining() < read) {
            newbuffer = ByteBuffer.allocateDirect(this.buffer.capacity() * 2);
            this.buffer.flip();
            newbuffer.put(this.buffer);
            this.buffer = newbuffer;
        }
        if (this.buffer.remaining() < read) {
            newbuffer = ByteBuffer.allocateDirect(this.buffer.capacity() + read);
            this.buffer.flip();
            newbuffer.put(this.buffer);
            this.buffer = newbuffer;
        }
    }

    public byte get() {
        return this.buffer.get();
    }

    public Buffer flip() {
        return this.buffer.flip();
    }

    public ByteBuffer compact() {
        return this.buffer.compact();
    }

    public byte[] getLast(int num) {
        int posi = this.buffer.position();
        num = Math.min(posi, num);
        this.buffer.position(posi - num);
        byte[] b = new byte[num];
        this.buffer.get(b);
        this.buffer.position(posi);
        return b;
    }

    public byte[] getSub(int start, int end) {
        int posi = this.buffer.position();
        this.buffer.position(start);
        byte[] b = new byte[end - start];
        this.buffer.get(b);
        this.buffer.position(posi);
        return b;
    }

    public static PrintStream PrintStreamforDynByteBuffer(int l) {
        final OutputStream buf = DynByteBuffer.OutputStreamforDynByteBuffer(l);
        return new PrintStream(buf){

            public synchronized String toString() {
                return buf.toString();
            }
        };
    }

    public static OutputStream OutputStreamforDynByteBuffer(int l) {
        DynByteBuffer buf = new DynByteBuffer(l);
        return new OutputStream(){

            public synchronized void write(int b) throws IOException {
                DynByteBuffer.this.put((byte)b);
            }

            public synchronized void write(byte[] bytes, int off, int len) throws IOException {
                DynByteBuffer.this.put(bytes, off, len);
            }

            public synchronized String toString() {
                return DynByteBuffer.this.toString();
            }
        };
    }
}

