/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

public final class OSDetector {
    private static final byte OS_ID;
    private static final String OS_STRING;
    public static final byte OS_LINUX_OTHER = 6;
    public static final byte OS_MAC_OTHER = 5;
    public static final byte OS_WINDOWS_OTHER = 4;
    public static final byte OS_WINDOWS_NT = 3;
    public static final byte OS_WINDOWS_2000 = 2;
    public static final byte OS_WINDOWS_XP = 0;
    public static final byte OS_WINDOWS_2003 = 7;
    public static final byte OS_WINDOWS_VISTA = 1;
    public static final byte OS_WINDOWS_7 = 8;

    static {
        OS_STRING = System.getProperty("os.name");
        String OS = OS_STRING.toLowerCase();
        OS_ID = OS.contains("windows 7") ? (byte)8 : (OS.contains("windows xp") ? (byte)0 : (OS.contains("windows vista") ? (byte)1 : (OS.contains("windows 2000") ? (byte)2 : (OS.contains("windows 2003") ? (byte)7 : (OS.contains("nt") ? (byte)3 : (OS.contains("windows") ? (byte)4 : (OS.contains("mac") ? (byte)5 : (byte)6)))))));
    }

    private OSDetector() {
    }

    public static String getOSString() {
        return OS_STRING;
    }

    public static byte getOSID() {
        return OS_ID;
    }

    public static boolean isLinux() {
        return OSDetector.getOSID() == 6;
    }

    public static boolean isMac() {
        return OSDetector.getOSID() == 5;
    }

    public static boolean isWindows() {
        switch (OSDetector.getOSID()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGnome() {
        if (!OSDetector.isLinux()) {
            return false;
        }
        String gdmSession = System.getenv("GDMSESSION");
        if (gdmSession != null && gdmSession.toLowerCase().contains("gnome")) {
            return true;
        }
        String desktopSession = System.getenv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.toLowerCase().contains("gnome")) {
            return true;
        }
        String gnomeDesktopSessionId = System.getenv("GNOME_DESKTOP_SESSION_ID");
        return gnomeDesktopSessionId != null && gnomeDesktopSessionId.trim().length() > 0;
    }

    public static boolean isKDE() {
        if (!OSDetector.isLinux()) {
            return false;
        }
        String gdmSession = System.getenv("GDMSESSION");
        if (gdmSession != null && gdmSession.toLowerCase().contains("kde")) {
            return true;
        }
        String desktopSession = System.getenv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.toLowerCase().contains("kde")) {
            return true;
        }
        String windowManager = System.getenv("WINDOW_MANAGER");
        return windowManager != null && windowManager.trim().toLowerCase().endsWith("kde");
    }
}

