/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.synth.SynthContext;

public class ArrowButtonPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ArrowButtonPainter";

    protected ArrowButtonPainter() {
    }

    public static ArrowButtonPainter getInstance() {
        return ArrowButtonPainter.getInstance(null);
    }

    public static ArrowButtonPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(ArrowButtonPainter.getPainterClassName(synthContext, ArrowButtonPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = ArrowButtonPainter.getInstance(synthContext, ArrowButtonPainter.class, UI_KEY);
        }
        return (ArrowButtonPainter)syntheticaComponentPainter;
    }

    public void paintArrowButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JButton jButton = (JButton)synthContext.getComponent();
        Container container = jButton.getParent();
        String string = jButton.getName();
        int n5 = 0;
        if (container instanceof JComboBox) {
            n5 = ((JComboBox)container).isEditable() ? 0 : SyntheticaState.State.LOCKED.toInt();
        }
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext, n5, false);
        if (string != null && string.startsWith("SplitPaneDivider.")) {
            return;
        }
        int n6 = (Integer)jButton.getClientProperty("__arrow_direction__");
        boolean bl = true;
        if (container instanceof JComboBox || string != null && string.startsWith("ComboBox.arrowButton")) {
            jButton.putClientProperty("Synthetica.flipHorizontal", !jButton.getComponentOrientation().isLeftToRight());
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.comboBox.hoverAndPressed.enabled", container)) {
                syntheticaPainterState = new SyntheticaPainterState(synthContext, n5, false, true);
            }
            n6 = 7;
        } else if (container instanceof JSpinner || "Spinner.nextButton".equals(string) || "Spinner.previousButton".equals(string)) {
            jButton.putClientProperty("Synthetica.flipHorizontal", !jButton.getComponentOrientation().isLeftToRight());
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.spinner.hoverAndPressed.enabled", container)) {
                syntheticaPainterState = new SyntheticaPainterState(synthContext, n5, false, true);
            }
            n6 = 7;
        }
        Insets insets = null;
        UIKey uIKey = new UIKey("arrowButton.y.background", syntheticaPainterState);
        if (bl) {
            if (n3 <= 12 || n4 <= 12) {
                uIKey = new UIKey("arrowButton.8x8.background", syntheticaPainterState);
            } else if (n6 == 3 || n6 == 7) {
                uIKey = new UIKey("arrowButton.x.background", syntheticaPainterState);
            }
            insets = (Insets)uIKey.findProperty(synthContext, "insets", true, 2);
        }
        String string2 = (String)uIKey.findProperty(synthContext, null, true, 1);
        Insets insets2 = insets;
        int n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jButton, 1);
        int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jButton, 50);
        int n9 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jButton, 2);
        if (syntheticaPainterState.isSet(SyntheticaState.State.HOVER)) {
            n9 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jButton, 1);
        }
        ImagePainter imagePainter = new ImagePainter((JComponent)jButton, n7, n8, n9, syntheticaPainterState.getState(), graphics, n, n2, n3, n4, string2, insets, insets2, 0, 0);
        imagePainter.draw();
    }

    public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        UIKey uIKey = new UIKey("arrow", syntheticaPainterState, n5, -1, -1);
        if (n3 < 16 || n4 < 16) {
            uIKey = new UIKey("arrow.8x8", syntheticaPainterState, n5, -1, -1);
            n += (n3 - 8 + 1) / 2;
            n2 += (n4 - 8 + 1) / 2;
            n3 = 8;
            n4 = 8;
        } else if (n3 != 16 || n4 != 16) {
            n += (n3 - 16) / 2;
            n2 += (n4 - 16 + 1) / 2;
            n3 = 16;
            n4 = 16;
        }
        n += jComponent.getClientProperty("Synthetica.arrow.xOffset") == null ? 0 : (Integer)jComponent.getClientProperty("Synthetica.arrow.xOffset");
        n2 += jComponent.getClientProperty("Synthetica.arrow.yOffset") == null ? 0 : (Integer)jComponent.getClientProperty("Synthetica.arrow.yOffset");
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        String string = SyntheticaLookAndFeel.getString(uIKey.get(), jComponent);
        if (string != null) {
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets2, 0, 0);
            imagePainter.draw();
        }
    }
}

