/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import jd.controlling.JDLogger;
import jd.gui.action.JDAction;
import jd.plugins.Plugin;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuAction
extends JDAction {
    public static final int CONTAINER = 0;
    public static final int NORMAL = 1;
    public static final int SEPARATOR = 3;
    private static final long serialVersionUID = 9205555751462125274L;
    public static final int TOGGLE = 2;
    private static final String MENUITEMS = "MENUITEMS";
    private int id = 1;
    private ArrayList<MenuAction> items;
    private Plugin plugin;

    public MenuAction(int id) {
        this(id, null, -1);
    }

    public MenuAction setActionListener(ActionListener actionListener) {
        return (MenuAction)super.setActionListener(actionListener);
    }

    public MenuAction(int id, String title, int actionID) {
        super(title, actionID);
        this.id = id;
        if (id == 2) {
            this.setSelected(false);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public MenuAction(String title, int actionID) {
        this(1, title, actionID);
    }

    public MenuAction(String menukey, String iconkey) {
        super(JDL.L((String)("gui.menu." + menukey + ".name"), (String)menukey), JDTheme.II(iconkey, 16, 16));
        this.setMnemonic(JDL.L((String)("gui.menu." + menukey + ".mnem"), (String)"-"));
        this.setAccelerator(JDL.L((String)("gui.menu." + menukey + ".accel"), (String)"-"));
    }

    public void addMenuItem(MenuAction m) {
        if (this.id != 0) {
            JDLogger.getLogger().severe("I am not a Container MenuAction!!");
        }
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(m);
        this.firePropertyChange(MENUITEMS, null, this.items);
    }

    public MenuAction get(int i) {
        if (this.items == null) {
            return null;
        }
        return this.items.get(i);
    }

    public int getType() {
        return this.id;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public int getSize() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public MenuAction setItems(ArrayList<MenuAction> createMenuitems) {
        this.items = createMenuitems;
        return this;
    }

    public MenuAction setPlugin(Plugin plugin) {
        this.plugin = plugin;
        return this;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.getActionListener() == null) {
            JDLogger.getLogger().warning("no Actionlistener for " + this.getTitle());
            return;
        }
        this.getActionListener().actionPerformed(new ActionEvent((Object)this, this.getActionID(), this.getTitle()));
    }
}

