/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import jd.HostPluginWrapper;
import jd.config.SubConfiguration;
import jd.controlling.AccountControllerBroadcaster;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.AccountProvider;
import jd.controlling.AccountProviderBroadcaster;
import jd.controlling.JDController;
import jd.gui.swing.components.Balloon;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.PluginForHost;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountController
extends SubConfiguration
implements ActionListener,
AccountControllerListener {
    private static final long serialVersionUID = -7560087582989096645L;
    private static TreeMap<String, ArrayList<Account>> hosteraccounts = null;
    private static AccountController INSTANCE = null;
    private AccountControllerBroadcaster broadcaster = new AccountControllerBroadcaster();
    private AccountProviderBroadcaster provider = new AccountProviderBroadcaster();
    private Timer asyncSaveIntervalTimer;
    private boolean saveinprogress = false;
    private long lastballoon = 0L;
    private long waittimeAccountInfoUpdate = 900000L;
    private long ballooninterval = 1800000L;
    private ProviderMode providemode = ProviderMode.RR;
    private static Comparator<Account> compare_RR = new Comparator<Account>(){

        @Override
        public int compare(Account o1, Account o2) {
            AccountInfo I1 = o1.getAccountInfo();
            AccountInfo I2 = o2.getAccountInfo();
            if (I1 != null && I2 != null) {
                if (I1.getTrafficLeft() < I2.getTrafficLeft()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    };

    public long getUpdateTime() {
        return this.waittimeAccountInfoUpdate;
    }

    public void setUpdateTime(long time) {
        this.waittimeAccountInfoUpdate = time;
    }

    private AccountController() {
        super("AccountController");
        hosteraccounts = this.loadAccounts();
        this.importOld();
        this.asyncSaveIntervalTimer = new Timer(2000, this);
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.setRepeats(false);
        this.broadcaster.addListener(this);
    }

    public AccountInfo updateAccountInfo(PluginForHost host, Account account, boolean forceupdate) {
        return this.updateAccountInfo(host.getHost(), account, forceupdate);
    }

    public AccountInfo updateAccountInfo(String host, Account account, boolean forceupdate) {
        AccountInfo ai;
        String hostname;
        block13: {
            String string = hostname = host != null ? host : this.getHosterName(account);
            if (hostname == null) {
                account.setAccountInfo(null);
                this.logger.severe("Cannot update AccountInfo, no Hostername available!");
                return null;
            }
            PluginForHost plugin = JDUtilities.getNewPluginForHostInstance(hostname);
            if (plugin == null) {
                account.setAccountInfo(null);
                this.logger.severe("Cannot update AccountInfo, no HosterPlugin available!");
                return null;
            }
            ai = account.getAccountInfo();
            if (!forceupdate) {
                if (account.lastUpdateTime() != 0L && ai != null && ai.isExpired()) {
                    return ai;
                }
                if (!account.isValid() && account.lastUpdateTime() != 0L) {
                    return ai;
                }
                if (System.currentTimeMillis() - account.lastUpdateTime() < this.waittimeAccountInfoUpdate) {
                    return ai;
                }
            }
            account.setUpdateTime(System.currentTimeMillis());
            account.setValid(true);
            ai = plugin.fetchAccountInfo(account);
            if (ai != null) break block13;
            account.setAccountInfo(null);
            this.broadcaster.fireEvent(new AccountControllerEvent(this, 20, hostname, account));
            return null;
        }
        try {
            account.setAccountInfo(ai);
            if (ai.isExpired()) {
                account.setEnabled(false);
                this.broadcaster.fireEvent(new AccountControllerEvent(this, 31, hostname, account));
            } else if (!account.isValid()) {
                account.setEnabled(false);
                this.broadcaster.fireEvent(new AccountControllerEvent(this, 30, hostname, account));
            } else {
                this.broadcaster.fireEvent(new AccountControllerEvent(this, 20, hostname, account));
            }
        }
        catch (Exception e) {
            account.setAccountInfo(null);
            account.setEnabled(false);
            account.setValid(false);
            this.broadcaster.fireEvent(new AccountControllerEvent(this, 30, hostname, account));
        }
        return ai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHosterName(Account account) {
        if (account.getHoster() != null) {
            return account.getHoster();
        }
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            for (String host : hosteraccounts.keySet()) {
                if (!hosteraccounts.get(host).contains(account)) continue;
                account.setHoster(host);
                return host;
            }
        }
        return null;
    }

    public void setProviderMode(ProviderMode mode) {
        this.providemode = mode;
    }

    public ProviderMode getProviderMode() {
        return this.providemode;
    }

    public static synchronized AccountController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AccountController();
        }
        return INSTANCE;
    }

    public void addListener(AccountControllerListener l) {
        this.broadcaster.addListener(l);
    }

    public void removeListener(AccountControllerListener l) {
        this.broadcaster.removeListener(l);
    }

    public void addAccountProvider(AccountProvider l) {
        this.provider.addListener(l);
    }

    public void removeAccountProvider(AccountProvider l) {
        this.provider.removeListener(l);
    }

    private TreeMap<String, ArrayList<Account>> loadAccounts() {
        return this.getGenericProperty("accountlist", new TreeMap());
    }

    private void importOld() {
        try {
            this.importOldAccounts();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.importOldAccounts2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importOldAccounts() {
        if (this.getBooleanProperty("oldimported21", false).booleanValue()) {
            return;
        }
        for (HostPluginWrapper wrapper : JDUtilities.getPluginsForHost()) {
            ArrayList list = wrapper.getPluginConfig().getGenericProperty("PREMIUM", new ArrayList());
            for (Account acc : list) {
                this.addAccount(wrapper.getHost(), acc);
            }
        }
        this.setProperty("oldimported21", true);
        this.saveSync();
    }

    private void importOldAccounts2() {
        if (this.getBooleanProperty("oldimported22", false).booleanValue()) {
            return;
        }
        SubConfiguration sub = SubConfiguration.getConfig("AccountManager");
        for (HostPluginWrapper wrapper : JDUtilities.getPluginsForHost()) {
            ArrayList list = sub.getGenericProperty(wrapper.getHost(), new ArrayList());
            for (Account acc : list) {
                this.addAccount(wrapper.getHost(), acc);
            }
        }
        this.setProperty("oldimported22", true);
        this.saveSync();
    }

    public void addAccount(PluginForHost pluginForHost, Account account) {
        String host = pluginForHost.getHost();
        this.addAccount(host, account);
    }

    public boolean hasAccounts(String host) {
        return !this.getAllAccounts(host).isEmpty();
    }

    public ArrayList<Account> getAllAccounts(PluginForHost pluginForHost) {
        if (pluginForHost == null) {
            return new ArrayList<Account>();
        }
        return this.getAllAccounts(pluginForHost.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Account> getAllAccounts(String host) {
        if (host == null) {
            return new ArrayList<Account>();
        }
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            if (hosteraccounts.containsKey(host)) {
                return hosteraccounts.get(host);
            }
            ArrayList<Account> haccounts = new ArrayList<Account>();
            hosteraccounts.put(host, haccounts);
            return haccounts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validAccounts() {
        int count = 0;
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            for (ArrayList<Account> accs : hosteraccounts.values()) {
                for (Account acc : accs) {
                    if (!acc.isEnabled()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAccount(String host, Account account) {
        if (host == null) {
            return;
        }
        if (account == null) {
            return;
        }
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            if (hosteraccounts.containsKey(host)) {
                ArrayList<Account> haccounts;
                ArrayList<Account> arrayList = haccounts = hosteraccounts.get(host);
                synchronized (arrayList) {
                    boolean b = haccounts.contains(account);
                    if (!b) {
                        boolean b2 = false;
                        ArrayList<Account> temp = new ArrayList<Account>(haccounts);
                        for (Account acc : temp) {
                            if (!acc.equals(account)) continue;
                            b2 = true;
                            break;
                        }
                        if (!b2) {
                            haccounts.add(account);
                            b = true;
                        }
                    }
                    if (b) {
                        this.broadcaster.fireEvent(new AccountControllerEvent(this, 10, host, account));
                    }
                }
            } else {
                ArrayList<Account> haccounts = new ArrayList<Account>();
                haccounts.add(account);
                hosteraccounts.put(host, haccounts);
                this.broadcaster.fireEvent(new AccountControllerEvent(this, 10, host, account));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccount(String hostname, Account account) {
        if (account == null) {
            return false;
        }
        String host = hostname;
        if (host == null) {
            host = this.getHosterName(account);
        }
        if (host == null) {
            return false;
        }
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            ArrayList<Account> haccounts;
            block13: {
                if (hosteraccounts.containsKey(host)) break block13;
                return false;
            }
            ArrayList<Account> arrayList = haccounts = hosteraccounts.get(host);
            synchronized (arrayList) {
                boolean b = haccounts.remove(account);
                if (!b) {
                    ArrayList<Account> temp = new ArrayList<Account>(haccounts);
                    for (Account acc : temp) {
                        if (!acc.equals(account)) continue;
                        account = acc;
                        b = haccounts.remove(account);
                        break;
                    }
                }
                if (b) {
                    this.broadcaster.fireEvent(new AccountControllerEvent(this, 11, host, account));
                }
                return b;
            }
        }
    }

    public boolean removeAccount(PluginForHost pluginForHost, Account account) {
        if (account == null) {
            return false;
        }
        if (pluginForHost == null) {
            return this.removeAccount((String)null, account);
        }
        return this.removeAccount(pluginForHost.getHost(), account);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.asyncSaveIntervalTimer) {
            this.saveSync();
        }
    }

    @Override
    public void onAccountControllerEvent(AccountControllerEvent event) {
        switch (event.getID()) {
            case 10: {
                JDUtilities.getConfiguration().setProperty("USE_PREMIUM_V3", true);
                JDUtilities.getConfiguration().save();
                this.saveAsync();
                break;
            }
            case 11: 
            case 20: 
            case 30: 
            case 31: {
                this.saveAsync();
                break;
            }
        }
    }

    public void throwUpdateEvent(PluginForHost pluginForHost, Account account) {
        if (pluginForHost != null) {
            this.broadcaster.fireEvent(new AccountControllerEvent(this, 20, pluginForHost.getHost(), account));
        } else {
            this.broadcaster.fireEvent(new AccountControllerEvent(this, 20, null, account));
        }
    }

    public void saveAsync() {
        this.asyncSaveIntervalTimer.restart();
    }

    public void saveSync() {
        if (this.saveinprogress) {
            return;
        }
        this.saveinprogress = true;
        new Thread(){

            public void run() {
                AccountController.this.saveSyncnonThread();
                AccountController.this.saveinprogress = false;
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSyncnonThread() {
        String id = JDController.requestDelayExit("accountcontroller");
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            this.save();
        }
        JDController.releaseDelayExit(id);
    }

    @Override
    public boolean vetoAccountGetEvent(String host, Account account) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getValidAccount(PluginForHost pluginForHost) {
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            ArrayList<Account> accounts = new ArrayList<Account>();
            accounts.addAll(this.provider.collectAccountsFor(pluginForHost));
            accounts.addAll(this.getAllAccounts(pluginForHost));
            Account ret = null;
            switch (this.providemode) {
                case FIFO: {
                    break;
                }
                case RR: {
                    Collections.sort(accounts, compare_RR);
                    break;
                }
            }
            ArrayList<Account> arrayList = accounts;
            synchronized (arrayList) {
                int i = 0;
                while (i < accounts.size()) {
                    Account next = (Account)accounts.get(i);
                    if (!next.isTempDisabled() && next.isEnabled() && next.isValid() && !this.broadcaster.fireEvent(new AccountControllerEvent(this, 12, pluginForHost.getHost(), next))) {
                        ret = next;
                        break;
                    }
                    ++i;
                }
            }
            if (ret != null && !JDUtilities.getConfiguration().getBooleanProperty("USE_PREMIUM_V3", true).booleanValue()) {
                if (System.currentTimeMillis() - this.lastballoon > this.ballooninterval) {
                    this.lastballoon = System.currentTimeMillis();
                    Balloon.show((String)JDL.L((String)"gui.ballon.accountmanager.title", (String)"Accountmanager"), (ImageIcon)JDTheme.II("gui.images.accounts", 32, 32), (String)JDL.L((String)"gui.accountcontroller.globpremdisabled", (String)"Premiumaccounts are globally disabled!<br/>Click <a href='http://jdownloader.org/knowledge/wiki/gui/premiummenu'>here</a> for help."));
                }
                ret = null;
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProviderMode {
        FIFO,
        RR;

    }
}

