/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jd.controlling.ByteBufferEntry;
import jd.controlling.JDLogger;
import jd.nutils.Formatter;

public class ByteBufferController {
    private ArrayList<ByteBufferEntry> bufferpool;
    public static final String MAXBUFFERSIZE = "MAX_BUFFER_SIZE_V3";
    private static ByteBufferController INSTANCE;
    private Comparator<ByteBufferEntry> bytebuffercomp = new Comparator<ByteBufferEntry>(){

        @Override
        public int compare(ByteBufferEntry a, ByteBufferEntry b) {
            return a.capacity() == b.capacity() ? 0 : (a.capacity() > b.capacity() ? 1 : -1);
        }
    };
    protected long bufferEntries = 0L;

    public static synchronized ByteBufferController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ByteBufferController();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDebug() {
        long free = 0L;
        ArrayList<ByteBufferEntry> arrayList = this.bufferpool;
        synchronized (arrayList) {
            for (ByteBufferEntry entry : this.bufferpool) {
                free += (long)entry.capacity();
            }
        }
        JDLogger.getLogger().info("ByteBufferController: Used: " + Formatter.formatReadable(this.bufferEntries - free) + " Free: " + Formatter.formatReadable(free));
    }

    private ByteBufferController() {
        this.bufferpool = new ArrayList();
        Thread thread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        2.sleep(600000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    ByteBufferController.getInstance().printDebug();
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferEntry getByteBufferEntry(int size) {
        ByteBufferEntry ret = null;
        ArrayList<ByteBufferEntry> arrayList = this.bufferpool;
        synchronized (arrayList) {
            for (ByteBufferEntry entry : this.bufferpool) {
                if (entry.capacity() < size) continue;
                ret = entry;
                this.bufferpool.remove(entry);
                return ret.getbytebufferentry(size);
            }
        }
        this.bufferEntries += (long)size;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putByteBufferEntry(ByteBufferEntry entry) {
        ArrayList<ByteBufferEntry> arrayList = this.bufferpool;
        synchronized (arrayList) {
            if (!this.bufferpool.contains(entry)) {
                this.bufferpool.add(entry);
            }
            Collections.sort(this.bufferpool, this.bytebuffercomp);
        }
    }
}

