/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.nio.ByteBuffer;
import jd.controlling.ByteBufferController;

public class ByteBufferEntry {
    public ByteBuffer buffer = null;
    private int size = 0;
    private boolean unused = true;

    public static ByteBufferEntry getByteBufferEntry(int size) {
        ByteBufferEntry ret = ByteBufferController.getInstance().getByteBufferEntry(size);
        if (ret != null) {
            return ret.getbytebufferentry(size);
        }
        return new ByteBufferEntry(size).getbytebufferentry(size);
    }

    private ByteBufferEntry(int size) {
        this.size = size;
        this.buffer = ByteBuffer.allocateDirect(size);
        this.clear();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public void clear() {
        this.buffer.clear();
        this.buffer.limit(this.size);
    }

    public void clear(int size) {
        this.size = size;
        this.buffer.clear();
        this.buffer.limit(size);
    }

    public int size() {
        return this.size;
    }

    public void limit(int size) {
        this.size = size;
        this.buffer.limit(size);
    }

    protected ByteBufferEntry getbytebufferentry(int size) {
        this.unused = false;
        this.size = size;
        this.clear();
        return this;
    }

    public void setUnused() {
        if (this.unused) {
            return;
        }
        this.unused = true;
        ByteBufferController.getInstance().putByteBufferEntry(this);
    }
}

