/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;
import jd.config.SubConfiguration;
import jd.controlling.JDController;
import jd.controlling.ListController;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTACCESSController
implements ActionListener,
ListController {
    private static transient SubConfiguration CONFIG = null;
    private transient HashMap<String, String[]> LIST;
    private static transient HTACCESSController INSTANCE = null;
    private Timer asyncSaveIntervalTimer;
    private boolean saveinprogress;

    public static synchronized HTACCESSController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HTACCESSController();
        }
        return INSTANCE;
    }

    private HTACCESSController() {
        CONFIG = SubConfiguration.getConfig("HTACCESSLIST");
        HashMap<String, String[]> defaultentry = new HashMap<String, String[]>();
        defaultentry.put("example.com", new String[]{"username", "passwd"});
        this.LIST = CONFIG.getGenericProperty("LIST2", defaultentry);
        this.asyncSaveIntervalTimer = new Timer(2000, this);
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.setRepeats(false);
        this.asyncSaveIntervalTimer.stop();
        this.saveSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String url, String username, String passwd) {
        if (url == null || url.length() == 0) {
            return;
        }
        String host = Browser.getHost(url.trim()).toLowerCase();
        if (username == null) {
            username = "";
        }
        if (passwd == null) {
            passwd = "";
        }
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            this.LIST.remove(host);
            this.LIST.put(host, new String[]{username.trim(), passwd.trim()});
        }
    }

    public static String[] getUserDatafromBasicauth(String basicauth) {
        if (basicauth == null || basicauth.length() == 0) {
            return null;
        }
        if (basicauth.startsWith("Basic")) {
            basicauth = new Regex(basicauth, "Basic (.*?)$").getMatch(0);
        }
        basicauth = Encoding.Base64Decode(basicauth);
        String[] dat = new Regex(basicauth, "(.*?):(.*?)$").getRow(0);
        return new String[]{dat[0], dat[1]};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String url, String basicauth) {
        if (url == null || url.length() == 0) {
            return;
        }
        String host = Browser.getHost(url.trim()).toLowerCase();
        String[] user = HTACCESSController.getUserDatafromBasicauth(basicauth);
        if (user == null) {
            return;
        }
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            this.LIST.remove(host);
            this.LIST.put(host, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        String host = Browser.getHost(url.trim()).toLowerCase();
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            block5: {
                if (this.LIST.containsKey(host)) break block5;
                return null;
            }
            return "Basic " + Encoding.Base64Encode(String.valueOf(this.LIST.get(host)[0]) + ":" + this.LIST.get(host)[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String url) {
        if (url == null || url.length() == 0) {
            return;
        }
        String host = Browser.getHost(url.trim()).toLowerCase();
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            this.LIST.remove(host);
        }
    }

    public HashMap<String, String[]> getPasswordList() {
        return this.LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setList(String list) {
        String[] pws = Regex.getLines(list);
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            this.LIST.clear();
            String[] stringArray = pws;
            int n = pws.length;
            int n2 = 0;
            while (n2 < n) {
                String pw = stringArray[n2];
                String[] dat = new Regex(pw, "(.*?)%%%%(.*?)%%%%(.*?)$").getRow(0);
                if (dat != null) {
                    this.add(dat[0], dat[1], dat[2]);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getList() {
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            StringBuilder sb = new StringBuilder();
            for (String host : this.LIST.keySet()) {
                String[] auth = this.LIST.get(host);
                sb.append(String.valueOf(host) + " %%%% " + auth[0] + " %%%% " + auth[1]);
            }
            return sb.toString().trim();
        }
    }

    public void save() {
        this.asyncSaveIntervalTimer.restart();
    }

    public void saveAsync() {
        if (this.saveinprogress) {
            return;
        }
        new Thread(){

            public void run() {
                this.setName("PasswordList: Saving");
                HTACCESSController.this.saveinprogress = true;
                HTACCESSController.this.saveSync();
                HTACCESSController.this.saveinprogress = false;
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSync() {
        String id = JDController.requestDelayExit("htaccesscontroller");
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            CONFIG.setProperty("LIST", this.LIST);
            CONFIG.save();
        }
        JDController.releaseDelayExit(id);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.asyncSaveIntervalTimer) {
            this.saveAsync();
        }
    }
}

