/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import jd.CPluginWrapper;
import jd.config.SubConfiguration;
import jd.controlling.AccountController;
import jd.controlling.DistributeData;
import jd.controlling.DownloadController;
import jd.controlling.DownloadWatchDog;
import jd.controlling.HTACCESSController;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.controlling.PasswordListController;
import jd.controlling.ProgressController;
import jd.controlling.SingleDownloadController;
import jd.controlling.interaction.Interaction;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIO;
import jd.http.Browser;
import jd.nutils.JDFlags;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import jd.update.FileUpdate;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDController
implements ControlListener {
    public static final int DOWNLOAD_NOT_RUNNING = 3;
    public static final int DOWNLOAD_RUNNING = 2;
    public static final int DOWNLOAD_TERMINATION_IN_PROGRESS = 0;
    public static final int INIT_STATUS_COMPLETE = 0;
    private transient ArrayList<ControlListener> controlListener = new ArrayList();
    private transient ArrayList<ControlListener> removeList = new ArrayList();
    private int downloadStatus = 3;
    private ArrayList<ControlEvent> eventQueue = new ArrayList();
    private EventSender eventSender = null;
    private ArrayList<DownloadLink> finishedLinks = new ArrayList();
    private int initStatus = -1;
    private DownloadLink lastDownloadFinished;
    private Logger logger = JDLogger.getLogger();
    private ArrayList<FileUpdate> waitingUpdates = new ArrayList();
    private DownloadWatchDog watchdog;
    private final Object StartStopSync = new Object();
    private static ArrayList<String> delayMap = new ArrayList();
    private static JDController INSTANCE;

    public static JDController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JDController();
        }
        return INSTANCE;
    }

    public JDController() {
        this.eventSender = this.getEventSender();
        JDUtilities.setController(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlListener(ControlListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList<ControlListener> arrayList = this.controlListener;
        synchronized (arrayList) {
            ArrayList<ControlListener> arrayList2 = this.removeList;
            synchronized (arrayList2) {
                if (this.removeList.contains(listener)) {
                    this.removeList.remove(listener);
                }
            }
            if (!this.controlListener.contains(listener)) {
                this.controlListener.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFinished(DownloadLink lastDownloadFinished) {
        ArrayList<DownloadLink> arrayList = this.finishedLinks;
        synchronized (arrayList) {
            this.finishedLinks.add(lastDownloadFinished);
        }
    }

    private String callService(String service, String key) throws Exception {
        this.logger.finer("Call " + service);
        Browser br = new Browser();
        br.postPage(service, "jd=1&srcType=plain&data=" + key);
        this.logger.info("Call re: " + br.toString());
        if (!br.getHttpConnection().isOK() || !br.containsHTML("<rc>")) {
            return null;
        }
        String dlcKey = br.getRegex("<rc>(.*?)</rc>").getMatch(0);
        if (dlcKey.trim().length() < 80) {
            return null;
        }
        return dlcKey;
    }

    @Override
    public void controlEvent(ControlEvent event) {
        if (event == null) {
            this.logger.warning("event= NULL");
            return;
        }
        switch (event.getID()) {
            case 30: {
                this.watchdog = DownloadWatchDog.getInstance();
                break;
            }
            case 33: {
                File[] list;
                File[] fileArray = list = (File[])event.getParameter();
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (this.isContainerFile(file) && JDUtilities.getConfiguration().getBooleanProperty("RELOADCONTAINER", true).booleanValue()) {
                        this.loadContainerFile(file);
                    }
                    ++n2;
                }
                break;
            }
            case 29: {
                break;
            }
            case 26: {
                break;
            }
            case 4: {
                if (!(event.getSource() instanceof PluginForHost)) {
                    return;
                }
                this.lastDownloadFinished = ((SingleDownloadController)event.getParameter()).getDownloadLink();
                this.addToFinished(this.lastDownloadFinished);
                if (this.lastDownloadFinished.getFilePackage().getRemainingLinks() == 0) {
                    Interaction.handleInteraction(Interaction.INTERACTION_DOWNLOAD_PACKAGE_FINISHED, this);
                    if (JDUtilities.getConfiguration().getIntegerProperty("FINISHED_DOWNLOADS_ACTION") == 2) {
                        JDUtilities.getDownloadController().removePackage(this.lastDownloadFinished.getFilePackage());
                        break;
                    }
                }
                if (!this.lastDownloadFinished.getLinkStatus().isFinished() || JDUtilities.getConfiguration().getIntegerProperty("FINISHED_DOWNLOADS_ACTION") != 0) break;
                this.lastDownloadFinished.getFilePackage().remove(this.lastDownloadFinished);
            }
        }
    }

    public String encryptDLC(String xml) {
        String dlcKey;
        block4: {
            String[] encrypt = JDUtilities.encrypt(xml, "dlc");
            if (encrypt == null) {
                this.logger.severe("Container Encryption failed.");
                return null;
            }
            String key = encrypt[1];
            xml = encrypt[0];
            String service = "http://service.jdownloader.org/dlcrypt/service.php";
            try {
                dlcKey = this.callService(service, key);
                if (dlcKey != null) break block4;
                return null;
            }
            catch (Exception e) {
                JDLogger.exception(e);
                return null;
            }
        }
        return String.valueOf(xml) + dlcKey;
    }

    public void exit() {
        new Thread(new Runnable(){

            public void run() {
                JDController.this.prepareShutdown();
                System.exit(0);
            }
        }).start();
    }

    public void prepareShutdown() {
        this.logger.info("Stop all running downloads");
        this.stopDownloads();
        this.logger.info("Call Exit event");
        this.fireControlEventDirect(new ControlEvent(this, 26, this));
        this.logger.info("Save Downloadlist");
        JDUtilities.getDownloadController().saveDownloadLinksSyncnonThread();
        this.logger.info("Save Accountlist");
        AccountController.getInstance().saveSyncnonThread();
        this.logger.info("Save Passwordlist");
        PasswordListController.getInstance().saveSync();
        this.logger.info("Save HTACCESSlist");
        HTACCESSController.getInstance().saveSync();
        this.logger.info("Call Exit interactions");
        Interaction.handleInteraction(Interaction.INTERACTION_EXIT, null);
        this.logger.info("Wait for delayExit");
        this.waitDelayExit();
        this.logger.info("Shutdown Database");
        JDUtilities.getDatabaseConnector().shutdownDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestDelayExit(String name) {
        if (name == null) {
            name = "unknown";
        }
        ArrayList<String> arrayList = delayMap;
        synchronized (arrayList) {
            String id = "ID: " + name + " TIME: " + System.currentTimeMillis();
            while (delayMap.contains(id)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                id = "ID: " + name + " TIME: " + System.currentTimeMillis();
            }
            delayMap.add(id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseDelayExit(String id) {
        ArrayList<String> arrayList = delayMap;
        synchronized (arrayList) {
            if (!delayMap.remove(id)) {
                JDLogger.getLogger().severe(String.valueOf(id) + " not found in delayMap!");
            }
        }
    }

    private void waitDelayExit() {
        long maxdelay = 10000L;
        while (maxdelay > 0L) {
            if (delayMap.size() <= 0) {
                return;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            maxdelay -= 200L;
        }
        this.logger.severe("Unable to satisfy all delayExit requests! " + delayMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireControlEvent(ControlEvent controlEvent) {
        if (controlEvent == null) {
            return;
        }
        try {
            ArrayList<ControlEvent> arrayList = this.eventQueue;
            synchronized (arrayList) {
                this.eventQueue.add(controlEvent);
                EventSender eventSender = this.eventSender;
                synchronized (eventSender) {
                    if (this.eventSender.waitFlag) {
                        this.eventSender.waitFlag = false;
                        this.eventSender.notify();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireControlEventDirect(ControlEvent controlEvent) {
        if (controlEvent == null) {
            return;
        }
        try {
            ArrayList<ControlListener> arrayList = this.controlListener;
            synchronized (arrayList) {
                ArrayList<ControlListener> arrayList2 = this.removeList;
                synchronized (arrayList2) {
                    this.controlListener.removeAll(this.removeList);
                    this.removeList.clear();
                }
                if (this.controlListener.size() > 0) {
                    for (ControlListener cl : this.controlListener) {
                        cl.controlEvent(controlEvent);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fireControlEvent(int controlID, Object param) {
        ControlEvent c = new ControlEvent(this, controlID, param);
        this.fireControlEvent(c);
    }

    public int getDownloadStatus() {
        if (this.watchdog == null || this.watchdog.isAborted() && this.downloadStatus == 2) {
            this.setDownloadStatus(3);
        }
        return this.downloadStatus;
    }

    private EventSender getEventSender() {
        if (this.eventSender != null && this.eventSender.isAlive()) {
            return this.eventSender;
        }
        EventSender th = new EventSender();
        th.start();
        return th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadLink> getFinishedLinks() {
        ArrayList<DownloadLink> arrayList = this.finishedLinks;
        synchronized (arrayList) {
            return this.finishedLinks;
        }
    }

    public int getForbiddenReconnectDownloadNum() {
        boolean allowinterrupt = SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("PARAM_DOWNLOAD_AUTORESUME_ON_RECONNECT", true);
        int ret = 0;
        ArrayList<DownloadLink> links = DownloadWatchDog.getInstance().getRunningDownloads();
        for (DownloadLink link : links) {
            if (!link.getLinkStatus().hasStatus(1024) || link.getTransferStatus().supportsResume() && allowinterrupt) continue;
            ++ret;
        }
        return ret;
    }

    public int getInitStatus() {
        return this.initStatus;
    }

    public DownloadLink getLastFinishedDownloadLink() {
        return this.lastDownloadFinished;
    }

    public String getLastFinishedFile() {
        if (this.lastDownloadFinished == null) {
            return "";
        }
        return this.lastDownloadFinished.getFileOutput();
    }

    public ArrayList<FilePackage> getPackages() {
        return JDUtilities.getDownloadController().getPackages();
    }

    public int getSpeedMeter() {
        if (this.getWatchdog() == null || !this.getWatchdog().isAlive()) {
            return 0;
        }
        return this.getWatchdog().getTotalSpeed();
    }

    public ArrayList<FileUpdate> getWaitingUpdates() {
        return this.waitingUpdates;
    }

    public DownloadWatchDog getWatchdog() {
        return this.watchdog;
    }

    public boolean isContainerFile(File file) {
        ArrayList pluginsForContainer = CPluginWrapper.getCWrapper();
        int i = 0;
        while (i < pluginsForContainer.size()) {
            CPluginWrapper pContainer = (CPluginWrapper)pluginsForContainer.get(i);
            if (pContainer.canHandle(file.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList<DownloadLink> getContainerLinks(File file) {
        ArrayList pluginsForContainer = CPluginWrapper.getCWrapper();
        ArrayList downloadLinks = new ArrayList();
        ProgressController progress = new ProgressController("Containerloader", pluginsForContainer.size());
        this.logger.info("load Container: " + file);
        int i = 0;
        while (i < pluginsForContainer.size()) {
            block5: {
                CPluginWrapper wrapper = (CPluginWrapper)pluginsForContainer.get(i);
                progress.setStatusText("Containerplugin: " + wrapper.getHost());
                if (wrapper.canHandle(file.getName())) {
                    PluginsC pContainer = (PluginsC)wrapper.getNewPluginInstance();
                    try {
                        progress.setSource(pContainer);
                        pContainer.initContainer(file.getAbsolutePath());
                        ArrayList links = pContainer.getContainedDownloadlinks();
                        if (links == null || links.size() == 0) {
                            this.logger.severe("Container Decryption failed (1)");
                            break block5;
                        }
                        downloadLinks = links;
                        break;
                    }
                    catch (Throwable e) {
                        JDLogger.exception(e);
                    }
                }
            }
            progress.increase(1L);
            ++i;
        }
        progress.setStatusText(String.valueOf(downloadLinks.size()) + " links found");
        progress.doFinalize();
        return downloadLinks;
    }

    public boolean isPaused() {
        if (this.watchdog == null) {
            return false;
        }
        return this.watchdog.isPaused();
    }

    public void pauseDownloads(boolean value) {
        if (this.watchdog == null) {
            return;
        }
        this.watchdog.pause(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeControlListener(ControlListener listener) {
        ArrayList<ControlListener> arrayList = this.removeList;
        synchronized (arrayList) {
            if (!this.removeList.contains(listener)) {
                this.removeList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllLinks() {
        ArrayList<FilePackage> packages;
        ArrayList<FilePackage> arrayList = packages = JDUtilities.getDownloadController().getPackages();
        synchronized (arrayList) {
            ArrayList<DownloadLink> al = new ArrayList<DownloadLink>();
            Iterator<FilePackage> iterator = packages.iterator();
            FilePackage fp = null;
            while (iterator.hasNext()) {
                fp = iterator.next();
                for (DownloadLink nextDownloadLink : fp.getDownloadLinkList()) {
                    if (nextDownloadLink.getLinkStatus().isPluginActive()) continue;
                    nextDownloadLink.getLinkStatus().setStatus(1);
                    nextDownloadLink.getLinkStatus().setStatusText("");
                    nextDownloadLink.getLinkStatus().reset();
                    nextDownloadLink.getPlugin().resetPluginGlobals();
                    al.add(nextDownloadLink);
                }
            }
            DownloadController.getInstance().fireDownloadLinkUpdate(al);
        }
    }

    public void loadContainerFile(File file) {
        this.loadContainerFile(file, false, false);
    }

    public void loadContainerFile(final File file, final boolean hideGrabber, final boolean autostart) {
        System.out.println("load container");
        new Thread(){

            public void run() {
                ArrayList pluginsForContainer = CPluginWrapper.getCWrapper();
                ArrayList downloadLinks = new ArrayList();
                ProgressController progress = new ProgressController("Containerloader", pluginsForContainer.size());
                JDController.this.logger.info("load Container: " + file);
                int i = 0;
                while (i < pluginsForContainer.size()) {
                    block9: {
                        CPluginWrapper wrapper = (CPluginWrapper)pluginsForContainer.get(i);
                        progress.setStatusText("Containerplugin: " + wrapper.getHost());
                        if (wrapper.canHandle(file.getName())) {
                            PluginsC pContainer = (PluginsC)wrapper.getNewPluginInstance();
                            try {
                                progress.setSource(pContainer);
                                pContainer.initContainer(file.getAbsolutePath());
                                ArrayList links = pContainer.getContainedDownloadlinks();
                                if (links == null || links.size() == 0) {
                                    JDController.this.logger.severe("Container Decryption failed (1)");
                                    break block9;
                                }
                                downloadLinks = links;
                                break;
                            }
                            catch (Exception e) {
                                JDLogger.exception(e);
                            }
                        }
                    }
                    progress.increase(1L);
                    ++i;
                }
                progress.setStatusText(String.valueOf(downloadLinks.size()) + " links found");
                if (downloadLinks.size() > 0) {
                    if (SubConfiguration.getConfig("GUI").getBooleanProperty("SHOW_CONTAINER_ONLOAD_OVERVIEW", false).booleanValue()) {
                        String app;
                        String uploader;
                        String html = "<style>p { font-size:9px;margin:1px; padding:0px;}div {font-family:Geneva, Arial, Helvetica, sans-serif; width:400px;background-color:#ffffff; padding:2px;}h1 { vertical-align:top; text-align:left;font-size:10px; margin:0px; display:block;font-weight:bold; padding:0px;}</style><div> <div align='center'> <p><img src='http://jdownloader.org/img/%s.gif'> </p> </div> <h1>%s</h1><hr> <table width='100%%' border='0' cellspacing='5'> <tr> <td><p>%s</p></td> <td style='width:100%%'><p>%s</p></td> </tr> <tr> <td><p>%s</p></td> <td style='width:100%%'><p>%s</p></td> </tr> <tr> <td><p>%s</p></td> <td style='width:100%%'><p>%s</p></td> </tr> <tr> <td><p>%s</p></td> <td style='width:100%%'><p>%s</p></td> </tr> </table> </div>";
                        if (((DownloadLink)downloadLinks.get(0)).getFilePackage().getProperty("header", null) != null) {
                            HashMap header = (HashMap)downloadLinks.get(0).getFilePackage().getGenericProperty("header", new HashMap());
                            uploader = (String)header.get("tribute");
                            app = String.valueOf((String)header.get("generator.app")) + " v." + (String)header.get("generator.version") + " (" + (String)header.get("generator.url") + ")";
                        } else {
                            app = "n.A.";
                            uploader = "n.A";
                        }
                        String comment = downloadLinks.get(0).getFilePackage().getComment();
                        String password = ((DownloadLink)downloadLinks.get(0)).getFilePackage().getPassword();
                        JDFlags.hasAllFlags(UserIO.getInstance().requestConfirmDialog(132, JDL.L((String)"container.message.title", (String)"DownloadLinkContainer loaded"), String.format(html, JDIO.getFileExtension(file).toLowerCase(), JDL.L((String)"container.message.title", (String)"DownloadLinkContainer loaded"), JDL.L((String)"container.message.uploaded", (String)"Brought to you by"), uploader, JDL.L((String)"container.message.created", (String)"Created with"), app, JDL.L((String)"container.message.comment", (String)"Comment"), comment, JDL.L((String)"container.message.password", (String)"Password"), password)), 2);
                    }
                    LinkGrabberController.getInstance().addLinks(downloadLinks, hideGrabber, autostart);
                }
                progress.doFinalize();
            }
        }.start();
    }

    public void saveDLC(File file, ArrayList<DownloadLink> links) {
        String xml = JDUtilities.createContainerString(links, "dlc");
        String cipher = this.encryptDLC(xml);
        if (cipher != null) {
            SubConfiguration cfg = SubConfiguration.getConfig("DLCrypt");
            JDIO.writeLocalFile(file, cipher);
            if (cfg.getBooleanProperty("SHOW_INFO_AFTER_CREATE", false).booleanValue() && JDFlags.hasSomeFlags(UserIO.getInstance().requestConfirmDialog(4, JDL.L((String)"sys.dlc.success", (String)"DLC encryption successfull. Run Testdecrypt now?")), 2)) {
                this.loadContainerFile(file);
                return;
            }
            return;
        }
        this.logger.severe("Container creation failed");
        UserIO.getInstance().requestMessageDialog("Container encryption failed");
    }

    public void setDownloadStatus(int downloadStatus) {
        this.downloadStatus = downloadStatus;
    }

    public void setInitStatus(int initStatus) {
        this.initStatus = initStatus;
    }

    public void setWaitingUpdates(ArrayList<FileUpdate> files) {
        this.waitingUpdates = files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDownloads() {
        if (this.getDownloadStatus() == 0) {
            return false;
        }
        Object object = this.StartStopSync;
        synchronized (object) {
            block5: {
                if (this.getDownloadStatus() != 3) break block5;
                this.setDownloadStatus(2);
                this.fireControlEvent(new ControlEvent(this, 13, this));
                this.logger.info("StartDownloads");
                this.watchdog = DownloadWatchDog.getInstance();
                this.watchdog.start();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopDownloads() {
        if (this.getDownloadStatus() == 0) {
            return false;
        }
        Object object = this.StartStopSync;
        synchronized (object) {
            block10: {
                ArrayList<FilePackage> packages;
                if (this.getDownloadStatus() != 2) break block10;
                this.setDownloadStatus(0);
                this.fireControlEvent(new ControlEvent(this, 17, this));
                this.watchdog.abort();
                ArrayList<FilePackage> arrayList = packages = JDUtilities.getDownloadController().getPackages();
                synchronized (arrayList) {
                    for (FilePackage fp : packages) {
                        for (DownloadLink link : fp.getDownloadLinkList()) {
                            if (!link.getLinkStatus().hasStatus(2048)) continue;
                            link.getLinkStatus().removeStatus(2048);
                            link.setEnabled(true);
                        }
                    }
                }
                this.logger.info("termination broadcast");
                this.fireControlEvent(new ControlEvent(this, 18, this));
                this.fireControlEvent(new ControlEvent(this, 6, this));
                this.setDownloadStatus(3);
                return true;
            }
            return false;
        }
    }

    public void toggleStartStop() {
        if (!this.startDownloads()) {
            this.stopDownloads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadLink> getDownloadLinks(PluginForHost pluginForHost) {
        ArrayList<FilePackage> packages;
        ArrayList<DownloadLink> al = new ArrayList<DownloadLink>();
        ArrayList<FilePackage> arrayList = packages = JDUtilities.getDownloadController().getPackages();
        synchronized (arrayList) {
            for (FilePackage fp : packages) {
                for (DownloadLink nextDownloadLink : fp.getDownloadLinkList()) {
                    if (nextDownloadLink.getPlugin().getClass() != pluginForHost.getClass()) continue;
                    al.add(nextDownloadLink);
                }
            }
        }
        return al;
    }

    public DownloadLink getDownloadLinkByFileOutput(File file, Integer Linkstatus) {
        ArrayList<DownloadLink> links = JDUtilities.getDownloadController().getAllDownloadLinks();
        try {
            for (DownloadLink nextDownloadLink : links) {
                if (!new File(nextDownloadLink.getFileOutput()).getAbsoluteFile().equals(file.getAbsoluteFile())) continue;
                if (Linkstatus != null) {
                    if (!nextDownloadLink.getLinkStatus().hasStatus(Linkstatus.intValue())) continue;
                    return nextDownloadLink;
                }
                return nextDownloadLink;
            }
        }
        catch (Exception e) {
            JDLogger.exception(e);
        }
        return null;
    }

    public ArrayList<DownloadLink> getDownloadLinksByNamePattern(String matcher) {
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        ArrayList<FilePackage> packages = JDUtilities.getDownloadController().getPackages();
        try {
            Iterator<FilePackage> iterator = packages.iterator();
            FilePackage fp = null;
            while (iterator.hasNext()) {
                fp = iterator.next();
                for (DownloadLink nextDownloadLink : fp.getDownloadLinkList()) {
                    String name = new File(nextDownloadLink.getFileOutput()).getName();
                    if (!new Regex(name, matcher, 2).matches()) continue;
                    ret.add(nextDownloadLink);
                }
            }
        }
        catch (Exception e) {
            JDLogger.exception(e);
        }
        return ret;
    }

    public ArrayList<DownloadLink> getDownloadLinksByPathPattern(String matcher) {
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        ArrayList<FilePackage> packages = JDUtilities.getDownloadController().getPackages();
        try {
            Iterator<FilePackage> iterator = packages.iterator();
            FilePackage fp = null;
            while (iterator.hasNext()) {
                fp = iterator.next();
                for (DownloadLink nextDownloadLink : fp.getDownloadLinkList()) {
                    String path = nextDownloadLink.getFileOutput();
                    if (!new Regex(path, matcher, 2).matches()) continue;
                    ret.add(nextDownloadLink);
                }
            }
        }
        catch (Exception e) {
            JDLogger.exception(e);
        }
        return ret;
    }

    public void distributeLinks(String data) {
        new DistributeData(data).start();
    }

    private class EventSender
    extends Thread {
        protected static final long MAX_EVENT_TIME = 10000L;
        private ControlListener currentListener;
        private ControlEvent event;
        private long eventStart;
        public boolean waitFlag;
        private Thread watchDog;

        public EventSender() {
            super("EventSender");
            this.eventStart = 0L;
            this.waitFlag = true;
            this.watchDog = new Thread("EventSenderWatchDog"){

                public void run() {
                    while (true) {
                        if (EventSender.this.eventStart > 0L && System.currentTimeMillis() - EventSender.this.eventStart > 10000L) {
                            JDController.this.logger.finer("WATCHDOG: Execution Limit reached");
                            JDController.this.logger.finer("ControlListener: " + EventSender.this.currentListener);
                            JDController.this.logger.finer("Event: " + EventSender.this.event);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            JDLogger.exception(e);
                            return;
                        }
                    }
                }
            };
            this.watchDog.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                Object object = this;
                synchronized (object) {
                    while (this.waitFlag) {
                        try {
                            this.wait();
                        }
                        catch (Exception e) {
                            JDLogger.exception(e);
                        }
                    }
                }
                try {
                    object = JDController.this.eventQueue;
                    synchronized (object) {
                        if (JDController.this.eventQueue.size() > 0) {
                            this.event = (ControlEvent)JDController.this.eventQueue.remove(0);
                        } else {
                            this.eventStart = 0L;
                            this.waitFlag = true;
                        }
                    }
                    if (this.event == null || this.waitFlag) continue;
                    this.eventStart = System.currentTimeMillis();
                    this.currentListener = JDController.this;
                    try {
                        JDController.this.controlEvent(this.event);
                    }
                    catch (Exception e) {
                        JDLogger.exception(e);
                    }
                    this.eventStart = 0L;
                    ArrayList e = JDController.this.controlListener;
                    synchronized (e) {
                        if (JDController.this.controlListener.size() > 0) {
                            for (ControlListener cl : JDController.this.controlListener) {
                                this.eventStart = System.currentTimeMillis();
                                try {
                                    cl.controlEvent(this.event);
                                }
                                catch (Exception e2) {
                                    JDLogger.exception(e2);
                                }
                                this.eventStart = 0L;
                            }
                        }
                        ArrayList arrayList = JDController.this.removeList;
                        synchronized (arrayList) {
                            JDController.this.controlListener.removeAll(JDController.this.removeList);
                            JDController.this.removeList.clear();
                        }
                    }
                }
                catch (Exception e) {
                    JDLogger.exception(e);
                    this.eventStart = 0L;
                    continue;
                }
                break;
            }
        }
    }
}

