/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import jd.config.ConfigPropertyListener;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberControllerBroadcaster;
import jd.controlling.LinkGrabberControllerEvent;
import jd.controlling.LinkGrabberControllerListener;
import jd.controlling.LinkGrabberDistributeEvent;
import jd.parser.Regex;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkGrabberFilePackage;
import jd.plugins.LinkGrabberFilePackageEvent;
import jd.plugins.LinkGrabberFilePackageListener;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkGrabberController
implements LinkGrabberFilePackageListener,
LinkGrabberControllerListener {
    public static final Object ControllerLock = new Object();
    public static final byte MOVE_BEFORE = 1;
    public static final byte MOVE_AFTER = 2;
    public static final byte MOVE_BEGIN = 3;
    public static final byte MOVE_END = 4;
    public static final byte MOVE_TOP = 5;
    public static final byte MOVE_BOTTOM = 6;
    public static final String PARAM_ONLINECHECK = "PARAM_ONLINECHECK";
    public static final String CONFIG = "LINKGRABBER";
    public static final String IGNORE_LIST = "IGNORE_LIST";
    public static final String DONTFORCEPACKAGENAME = "dontforcename";
    private static ArrayList<LinkGrabberFilePackage> packages = new ArrayList();
    private static final HashSet<String> extensionFilter = new HashSet();
    private static LinkGrabberController INSTANCE = null;
    private LinkGrabberControllerBroadcaster broadcaster;
    private static String[] filter;
    private ConfigPropertyListener cpl;
    private LinkGrabberFilePackage FP_UNSORTED;
    private LinkGrabberFilePackage FP_UNCHECKED;
    private LinkGrabberFilePackage FP_UNCHECKABLE;
    private LinkGrabberFilePackage FP_OFFLINE;
    private LinkGrabberFilePackage FP_FILTERED;
    private LinkGrabberDistributeEvent distributer = null;
    private Logger logger = JDLogger.getLogger();

    public static synchronized LinkGrabberController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LinkGrabberController();
        }
        return INSTANCE;
    }

    public LinkGrabberFilePackage getFILTERPACKAGE() {
        return this.FP_FILTERED;
    }

    public void setDistributer(LinkGrabberDistributeEvent dist) {
        this.distributer = dist;
    }

    public void addLinks(ArrayList<DownloadLink> links, boolean hidegrabber, boolean autostart) {
        if (this.distributer != null) {
            this.distributer.addLinks(links, hidegrabber, autostart);
        } else {
            JDLogger.getLogger().info("No Distributer set, using minimal version");
            ArrayList<FilePackage> fps = new ArrayList<FilePackage>();
            FilePackage fp = FilePackage.getInstance();
            fp.setName("Added");
            for (DownloadLink link : links) {
                if (link.getFilePackage() == FilePackage.getDefaultFilePackage()) {
                    fp.add(link);
                    if (fps.contains(fp)) continue;
                    fps.add(fp);
                    continue;
                }
                if (fps.contains(link.getFilePackage())) continue;
                fps.add(link.getFilePackage());
            }
            DownloadController.getInstance().addAllAt(fps, 0);
            if (autostart) {
                JDController.getInstance().startDownloads();
            }
        }
    }

    public void addListener(LinkGrabberControllerListener l) {
        this.broadcaster.addListener(l);
    }

    public void removeListener(LinkGrabberControllerListener l) {
        this.broadcaster.removeListener(l);
    }

    private LinkGrabberController() {
        this.broadcaster = new LinkGrabberControllerBroadcaster();
        this.broadcaster.addListener(this);
        filter = this.getLinkFilterPattern();
        this.cpl = new ConfigPropertyListener(new String[]{IGNORE_LIST}){

            public void onPropertyChanged(Property source, String propertyName) {
                filter = LinkGrabberController.this.getLinkFilterPattern();
            }
        };
        JDController.getInstance().addControlListener(this.cpl);
        this.FP_UNSORTED = new LinkGrabberFilePackage(JDL.L((String)"gui.linkgrabber.package.unsorted", (String)"various"), (LinkGrabberFilePackageListener)this);
        this.FP_UNCHECKED = new LinkGrabberFilePackage(JDL.L((String)"gui.linkgrabber.package.unchecked", (String)"unchecked"), (LinkGrabberFilePackageListener)this);
        this.FP_UNCHECKABLE = new LinkGrabberFilePackage(JDL.L((String)"gui.linkgrabber.package.uncheckable", (String)"uncheckable"), (LinkGrabberFilePackageListener)this);
        this.FP_UNCHECKABLE.setIgnore(true);
        this.FP_OFFLINE = new LinkGrabberFilePackage(JDL.L((String)"gui.linkgrabber.package.offline", (String)"offline"), (LinkGrabberFilePackageListener)this);
        this.FP_OFFLINE.setIgnore(true);
        this.FP_FILTERED = new LinkGrabberFilePackage(JDL.L((String)"gui.linkgrabber.package.filtered", (String)"filtered"));
        this.FP_FILTERED.setIgnore(true);
    }

    public HashSet<String> getExtensionFilter() {
        return extensionFilter;
    }

    public boolean isLinkCheckEnabled() {
        return SubConfiguration.getConfig(CONFIG).getBooleanProperty(PARAM_ONLINECHECK, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExtensionFilter() {
        HashSet<String> hashSet = extensionFilter;
        synchronized (hashSet) {
            extensionFilter.clear();
        }
        this.FP_FILTERED.setDownloadLinks(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void filterExtension(String ext, boolean b) {
        boolean c = false;
        HashSet<String> hashSet = extensionFilter;
        synchronized (hashSet) {
            if (!b) {
                if (extensionFilter.contains(ext)) {
                    return;
                }
                extensionFilter.add(ext);
                c = true;
            } else {
                if (!extensionFilter.contains(ext)) {
                    return;
                }
                extensionFilter.remove(ext);
                c = true;
            }
        }
        if (c) {
            this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 9));
        }
    }

    public String[] getLinkFilterPattern() {
        String filter = SubConfiguration.getConfig(CONFIG).getStringProperty(IGNORE_LIST, null);
        if (filter == null || filter.length() == 0) {
            return null;
        }
        String[] lines = Regex.getLines(filter);
        ArrayList<String> ret = new ArrayList<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().startsWith("#") && line.trim().length() != 0) {
                ret.add(line.trim());
            }
            ++n2;
        }
        return ret.toArray(new String[0]);
    }

    protected void finalize() {
        JDController.getInstance().removeControlListener(this.cpl);
        System.out.println("REMOVED LISTENER " + this.cpl);
    }

    public ArrayList<LinkGrabberFilePackage> getPackages() {
        return packages;
    }

    public int indexOf(LinkGrabberFilePackage fp) {
        return packages.indexOf(fp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExtensionFiltered(DownloadLink link) {
        HashSet<String> hashSet = extensionFilter;
        synchronized (hashSet) {
            String ext;
            Iterator<String> iterator = extensionFilter.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                ext = iterator.next();
            } while (!link.getName().endsWith(ext));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkGrabberFilePackage getFPwithName(String name) {
        ArrayList<LinkGrabberFilePackage> arrayList = packages;
        synchronized (arrayList) {
            block6: {
                if (name != null) break block6;
                return null;
            }
            for (LinkGrabberFilePackage fp : packages) {
                if (!fp.getName().equalsIgnoreCase(name)) continue;
                return fp;
            }
            if (this.FP_FILTERED.getName().equalsIgnoreCase(name)) {
                return this.FP_FILTERED;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkGrabberFilePackage getFPwithLink(DownloadLink link) {
        ArrayList<LinkGrabberFilePackage> arrayList = packages;
        synchronized (arrayList) {
            block6: {
                if (link != null) break block6;
                return null;
            }
            for (LinkGrabberFilePackage fp : packages) {
                if (!fp.contains(link)) continue;
                return fp;
            }
            if (this.FP_FILTERED.contains(link)) {
                return this.FP_FILTERED;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postprocessing() {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                ArrayList<LinkGrabberFilePackage> fps = new ArrayList<LinkGrabberFilePackage>(packages);
                for (LinkGrabberFilePackage fp : fps) {
                    boolean remove = false;
                    if (fp.countFailedLinks(true) == fp.size()) {
                        remove = true;
                    }
                    ArrayList links = new ArrayList(fp.getDownloadLinks());
                    for (DownloadLink dl : links) {
                        if (dl.isAvailabilityStatusChecked() && dl.getAvailableStatus() == DownloadLink.AvailableStatus.UNCHECKABLE && links.size() == 1) {
                            this.FP_UNCHECKABLE.add(dl);
                            continue;
                        }
                        if (!dl.isAvailabilityStatusChecked() || dl.isAvailable() || links.size() != 1 && !remove) continue;
                        this.FP_OFFLINE.add(dl);
                    }
                    Collections.sort(fp.getDownloadLinks(), new Comparator<DownloadLink>(){

                        @Override
                        public int compare(DownloadLink a, DownloadLink b) {
                            return a.getName().compareToIgnoreCase(b.getName());
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDupe(DownloadLink link) {
        ArrayList<LinkGrabberFilePackage> arrayList = packages;
        synchronized (arrayList) {
            if (link == null) {
                return false;
            }
            if (link.getBooleanProperty("ALLOW_DUPE", false).booleanValue()) {
                return false;
            }
            LinkGrabberFilePackage fp = null;
            DownloadLink dl = null;
            Iterator<LinkGrabberFilePackage> it = packages.iterator();
            block3: while (true) {
                if (!it.hasNext()) {
                    return false;
                }
                fp = it.next();
                Iterator it2 = fp.getDownloadLinks().iterator();
                do {
                    if (!it2.hasNext()) continue block3;
                } while ((dl = (DownloadLink)it2.next()).compareTo(link) != 0);
                break;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(LinkGrabberFilePackage fp) {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                if (!packages.contains(fp)) {
                    packages.add(fp);
                    fp.addListener((LinkGrabberFilePackageListener)this);
                    this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 2, fp));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllAt(ArrayList<LinkGrabberFilePackage> links, int index) {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                int repos = 0;
                int i = 0;
                while (i < links.size()) {
                    repos = this.addPackageAt(links.get(i), index + i, repos);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPackageAt(LinkGrabberFilePackage fp, int index, int repos) {
        if (fp == null) {
            return repos;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                if (packages.size() == 0) {
                    this.addPackage(fp);
                    return repos;
                }
                boolean newadded = false;
                if (packages.contains(fp)) {
                    int posa = this.indexOf(fp);
                    if (posa < index) {
                        index -= ++repos;
                    }
                    packages.remove(fp);
                    if (index > packages.size() - 1) {
                        packages.add(fp);
                    } else if (index < 0) {
                        packages.add(0, fp);
                    } else {
                        packages.add(index, fp);
                    }
                } else if (index > packages.size() - 1) {
                    packages.add(fp);
                } else if (index < 0) {
                    packages.add(0, fp);
                } else {
                    packages.add(index, fp);
                }
                if (newadded) {
                    fp.addListener((LinkGrabberFilePackageListener)this);
                    this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 2, fp));
                } else {
                    this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1, fp));
                }
            }
        }
        return repos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(LinkGrabberFilePackage fp) {
        if (fp == null) {
            return;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                if (fp != this.FP_FILTERED && fp != this.FP_OFFLINE && fp != this.FP_UNCHECKED && fp != this.FP_UNSORTED) {
                    fp.removeListener((LinkGrabberFilePackageListener)this);
                }
                packages.remove(fp);
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 3, fp));
            }
        }
    }

    public void throwRefresh() {
        this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterPackages() {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                ArrayList<LinkGrabberFilePackage> fps = new ArrayList<LinkGrabberFilePackage>(packages);
                fps.add(this.FP_FILTERED);
                for (LinkGrabberFilePackage fp : fps) {
                    if (fp == this.FP_UNCHECKED || fp == this.FP_OFFLINE || fp == this.FP_UNSORTED) continue;
                    ArrayList links = new ArrayList(fp.getDownloadLinks());
                    for (DownloadLink dl : links) {
                        if (this.isExtensionFiltered(dl)) {
                            this.FP_FILTERED.add(dl);
                            continue;
                        }
                        this.attachToPackagesSecondStage(dl);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToPackagesFirstStage(DownloadLink link) {
        Object object = ControllerLock;
        synchronized (object) {
            LinkGrabberFilePackage fp = null;
            if (this.isExtensionFiltered(link)) {
                fp = this.FP_FILTERED;
            } else if (link.getFilePackage() != FilePackage.getDefaultFilePackage()) {
                String packageName = link.getFilePackage().getName();
                fp = this.getFPwithName(packageName);
                if (fp == null) {
                    fp = new LinkGrabberFilePackage(packageName, (LinkGrabberFilePackageListener)this);
                }
                fp.setDownloadDirectory(link.getFilePackage().getDownloadDirectory());
                fp.setPassword(link.getFilePackage().getPassword());
            }
            if (fp == null) {
                fp = this.isLinkCheckEnabled() ? this.FP_UNCHECKED : this.FP_UNSORTED;
            }
            fp.add(link);
        }
    }

    public int size() {
        return packages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToPackagesSecondStage(DownloadLink link) {
        Object object = ControllerLock;
        synchronized (object) {
            String packageName;
            boolean autoPackage = false;
            if (this.isExtensionFiltered(link)) {
                this.FP_FILTERED.add(link);
                return;
            }
            if (link.getFilePackage() != FilePackage.getDefaultFilePackage()) {
                if (link.getFilePackage().getStringProperty(DONTFORCEPACKAGENAME, null) != null) {
                    autoPackage = true;
                    packageName = LinkGrabberController.cleanFileName(link.getName());
                } else {
                    packageName = link.getFilePackage().getName();
                }
            } else {
                autoPackage = true;
                packageName = LinkGrabberController.cleanFileName(link.getName());
            }
            int bestSim = 0;
            LinkGrabberFilePackage bestp = null;
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                int i = 0;
                while (i < packages.size()) {
                    int sim = LinkGrabberController.comparepackages(packages.get(i).getName(), packageName);
                    if (sim > bestSim) {
                        bestSim = sim;
                        bestp = packages.get(i);
                    }
                    ++i;
                }
            }
            if (bestSim < 99) {
                LinkGrabberFilePackage fp = new LinkGrabberFilePackage(packageName, (LinkGrabberFilePackageListener)this);
                fp.setPassword(link.getFilePackage().getPassword());
                fp.setDownloadDirectory(link.getFilePackage().getDownloadDirectory());
                fp.add(link);
            } else {
                String newPackageName = autoPackage ? this.getSimString(bestp.getName(), packageName) : packageName;
                bestp.setName(newPackageName);
                bestp.add(link);
            }
        }
    }

    private String getSimString(String a, String b) {
        String aa = a.toLowerCase();
        String bb = b.toLowerCase();
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < Math.min(aa.length(), bb.length())) {
            if (aa.charAt(i) == bb.charAt(i)) {
                ret.append(a.charAt(i));
            }
            ++i;
        }
        return ret.toString();
    }

    public static String cleanFileName(String name) {
        String extension;
        name = LinkGrabberController.getNameMatch(name, "(.*)\\.part[0]*[1].rar$");
        name = LinkGrabberController.getNameMatch(name, "(.*)\\.part[0-9]+.rar$");
        name = LinkGrabberController.getNameMatch(name, "(.*)\\.rar$");
        name = LinkGrabberController.getNameMatch(name, "(.*)\\.r\\d+$");
        name = LinkGrabberController.getNameMatch(name, "(.*)(\\.|_)\\d+$");
        name = LinkGrabberController.getNameMatch(name, "(?is).*\\.7z\\.[\\d]+$");
        name = LinkGrabberController.getNameMatch(name, "(.*)\\.a.$");
        int lastPoint = (name = LinkGrabberController.getNameMatch(name, "(.*)(\\.|_)[\\d]+($|\\.(otrkey|ac3|3gp|7zip|7z|aiff|aif|aifc|au|avi|bin|bz2|ccf|cue|deb|divx|dlc|doc|docx|dot|exe|flv|gif|gz|iso|java|jpg|jpeg|mkv|mp2|mp3|mp4|mov|movie|mpe|mpeg|mpg|msi|msu|nfo|pkg|png|pdf|ppt|pptx|pps|ppz|pot|qt|rmvb|rar|r\\d+|\\d+|rpm|run|rsdf|rtf|sh|srt|snd|sfv|tar|tif|tiff|viv|vivo|wav|wmv|xla|xls|zip|ts|load)$)")).lastIndexOf(".");
        if (lastPoint <= 0) {
            lastPoint = name.lastIndexOf("_");
        }
        if (lastPoint > 0 && (extension = name.substring(name.length() - lastPoint + 1)).length() < 3) {
            name = name.substring(0, lastPoint);
        }
        return JDUtilities.removeEndingPoints(name);
    }

    private static String getNameMatch(String name, String pattern) {
        String match = new Regex(name, pattern).getMatch(0);
        if (match != null) {
            return match;
        }
        return name;
    }

    private static int comparepackages(String a, String b) {
        int c = 0;
        String aa = a.toLowerCase();
        String bb = b.toLowerCase();
        int i = 0;
        while (i < Math.min(aa.length(), bb.length())) {
            if (aa.charAt(i) == bb.charAt(i)) {
                ++c;
            }
            ++i;
        }
        if (Math.min(aa.length(), bb.length()) == 0) {
            return 0;
        }
        return c * 100 / Math.max(aa.length(), bb.length());
    }

    public void handle_LinkGrabberFilePackageEvent(LinkGrabberFilePackageEvent event) {
        switch (event.getID()) {
            case 999: {
                this.removePackage((LinkGrabberFilePackage)event.getSource());
                if (packages.size() != 0 || this.FP_FILTERED.size() != 0) break;
                this.clearExtensionFilter();
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 4));
                break;
            }
            case 2: 
            case 3: {
                if (!packages.contains((LinkGrabberFilePackage)event.getSource())) {
                    this.addPackage((LinkGrabberFilePackage)event.getSource());
                    break;
                }
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1, event.getSource()));
                break;
            }
            case 1: {
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1, event.getSource()));
                break;
            }
        }
    }

    public void throwLinksAdded() {
        this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 5));
    }

    @Override
    public void onLinkGrabberControllerEvent(LinkGrabberControllerEvent event) {
        switch (event.getID()) {
            case 2: 
            case 3: {
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1));
                break;
            }
            case 9: {
                this.filterPackages();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFiltered(DownloadLink element) {
        if (filter == null || filter.length == 0) {
            return false;
        }
        String[] stringArray = filter;
        synchronized (filter) {
            String[] stringArray2 = filter;
            int n = filter.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                String f = stringArray2[n2];
                if (element.getDownloadURL().matches(f) || element.getName().matches(f)) {
                    JDLogger.getLogger().finer("Filtered link: " + element.getName() + " due to filter entry " + f);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFiltered(CryptedLink element) {
        if (filter == null || filter.length == 0) {
            return false;
        }
        String[] stringArray = filter;
        synchronized (filter) {
            String[] stringArray2 = filter;
            int n = filter.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                String f = stringArray2[n2];
                String t = element.getCryptedUrl().replaceAll("httpviajd://", "http://").replaceAll("httpsviajd://", "https://");
                if (t.matches(f)) {
                    JDLogger.getLogger().finer("Filtered link: due to filter entry " + f);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Object src2, Object dst, byte mode) {
        boolean type = false;
        Object src = null;
        LinkGrabberFilePackage fp = null;
        if (src2 instanceof ArrayList) {
            Object check = ((ArrayList)src2).get(0);
            if (check == null) {
                this.logger.warning("Null src, cannot move!");
                return;
            }
            if (check instanceof DownloadLink) {
                src = src2;
                type = false;
            } else if (check instanceof LinkGrabberFilePackage) {
                src = src2;
                type = true;
            }
        } else if (src2 instanceof DownloadLink) {
            type = false;
            src = new ArrayList<DownloadLink>();
            ((ArrayList)src).add((DownloadLink)src2);
        } else if (src2 instanceof LinkGrabberFilePackage) {
            type = true;
            src = new ArrayList<LinkGrabberFilePackage>();
            ((ArrayList)src).add((LinkGrabberFilePackage)src2);
        }
        if (src == null) {
            this.logger.warning("Unknown src, cannot move!");
            return;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                if (dst != null) {
                    if (!type) {
                        if (dst instanceof LinkGrabberFilePackage) {
                            switch (mode) {
                                case 3: {
                                    fp = (LinkGrabberFilePackage)dst;
                                    fp.addAllAt((ArrayList)src, 0);
                                    return;
                                }
                                case 4: {
                                    fp = (LinkGrabberFilePackage)dst;
                                    fp.addAllAt((ArrayList)src, fp.size());
                                    return;
                                }
                            }
                            this.logger.warning("Unsupported mode, cannot move!");
                            return;
                        }
                        if (dst instanceof DownloadLink) {
                            switch (mode) {
                                case 1: {
                                    fp = this.getFPwithLink((DownloadLink)dst);
                                    fp.addAllAt((ArrayList)src, fp.indexOf((DownloadLink)dst));
                                    return;
                                }
                                case 2: {
                                    fp = this.getFPwithLink((DownloadLink)dst);
                                    fp.addAllAt((ArrayList)src, fp.indexOf((DownloadLink)dst) + 1);
                                    return;
                                }
                            }
                            this.logger.warning("Unsupported mode, cannot move!");
                            return;
                        }
                        this.logger.warning("Unsupported dst, cannot move!");
                        return;
                    }
                    if (dst instanceof LinkGrabberFilePackage) {
                        switch (mode) {
                            case 1: {
                                this.addAllAt((ArrayList)src, this.indexOf((LinkGrabberFilePackage)dst));
                                return;
                            }
                            case 2: {
                                this.addAllAt((ArrayList)src, this.indexOf((LinkGrabberFilePackage)dst) + 1);
                                return;
                            }
                        }
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                    if (dst instanceof DownloadLink) {
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                } else if (type) {
                    switch (mode) {
                        case 5: {
                            this.addAllAt((ArrayList)src, 0);
                            return;
                        }
                        case 6: {
                            this.addAllAt((ArrayList)src, this.size() + 1);
                            return;
                        }
                    }
                    this.logger.warning("Unsupported mode, cannot move!");
                    return;
                }
            }
        }
    }
}

