/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import jd.controlling.JDLogger;
import jd.nutils.Formatter;

public class LogFormatter
extends SimpleFormatter {
    private Object[] args = new Object[1];
    Date dat = new Date();
    private String lineSeparator = System.getProperty("line.separator");
    private StringBuilder sb;

    public synchronized String format(LogRecord record) {
        this.sb = new StringBuilder();
        this.dat.setTime(record.getMillis());
        this.args[0] = this.dat;
        String message = this.formatMessage(record);
        if (JDLogger.getLogger().getLevel() == Level.ALL) {
            this.sb.append(Formatter.formatMilliseconds(record.getMillis() - JDLogger.INIT_TIME));
            this.sb.append(" - ");
            this.sb.append(record.getLevel().getName());
            this.sb.append(" [");
            if (record.getSourceClassName() != null) {
                this.sb.append(record.getSourceClassName());
            } else {
                this.sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                this.sb.append("(");
                this.sb.append(record.getSourceMethodName());
                this.sb.append(")");
            }
            this.sb.append("] ");
            this.sb.append("-> ");
        } else {
            if (record.getSourceClassName() != null) {
                this.sb.append(record.getSourceClassName().substring(record.getSourceClassName().lastIndexOf(".") + 1));
            } else {
                this.sb.append(record.getLoggerName());
            }
            this.sb.append("-> ");
        }
        this.sb.append(message);
        this.sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            this.sb.append(JDLogger.getStackTrace(record.getThrown()));
        }
        return this.sb.toString();
    }
}

