/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.http.RandomUserAgent;

public class IPCheck {
    private static final String FALLBACK_CHECK_SITE = "http://service.jdownloader.org/tools/getip.php";
    private static final String FALLBACK_CHECK_REGEX = "<ip>([\\d+\\.]+?)</ip>";
    public static ArrayList<String[]> IP_CHECK_SERVICES = new ArrayList();
    private static int IP_CHECK_INDEX = 0;
    private static final Object LOCK = new Object();
    public static String LATEST_IP;

    static {
        IP_CHECK_SERVICES.add(new String[]{"http://www.wieistmeineip.de/", "Ihre IP-Adresse.*?class=\"ip\">([\\d+\\.]+?)</h1>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.whatismyip.com/", "<h1>Your IP Address Is: ([\\d+\\.]+?)</h1>"});
        IP_CHECK_SERVICES.add(new String[]{"http://whatismyipaddress.com/", "<B>Your IP address is ([\\d+\\.]+?)</B>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.ipaddressworld.com/", "Your computer.*?size=\\+6>([\\d+\\.]+?)</FONT>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.showmyip.com/", "IP Address properties of your Internet Connection ([\\d+\\.]+?) --> "});
        IP_CHECK_SERVICES.add(new String[]{"http://www.myip.ch/", "Current IP Address: ([\\d+\\.]+?)</body>"});
        IP_CHECK_SERVICES.add(new String[]{"http://ipcheckit.com/", "Your IP address is:<br/><B>([\\d+\\.]+?)</B>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.findmyipaddress.info/", "My IP is.*?class=\"heading_color\">([\\d+\\.]+?)<"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.meineip.de/", "<th>Das ist Deine IP-Adresse.*?>([\\d+\\.]+?) </td>"});
        IP_CHECK_SERVICES.add(new String[]{"http://checkip.dyndns.org/", "Current IP Address: ([\\d+\\.]+?)</body"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.anonym-surfen.com/anonym-surfen/test/", "ber Sie:</td></tr>.*?IP\\:</td><td>([\\d+\\.]+?)</td>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.init7.net/support/ip-adress-test.php", "Adresse: <b>([\\d+\\.]+?)</b>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.ip-adress.com/IP_adresse/", "<h2>Meine IP: ([\\d+\\.]+?)</h2>"});
        IP_CHECK_SERVICES.add(new String[]{"http://myip.tsql.de/", "<b>IP\\-Adresse :</b>\\s*?([\\d+\\.]+?)<"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.tracemyip.org/", "name\\s*?=\\s*?\"IP\" onclick\\s*?=\\s*?\".*?\"\\s*?value\\s*?=\\s*?\"([\\d+\\.]+?)\""});
        IP_CHECK_SERVICES.add(new String[]{"http://www.cmyip.com/", "My IP is[^\\d]*([\\d+\\.]+?)</h1>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.univie.ac.at/cgi-bin/ip.cgi", "<font color=\"#dd0000\">([\\d+\\.]+?)</font>"});
        IP_CHECK_SERVICES.add(new String[]{"http://checkmyip.com/", "Your local IP address is.*?([\\d+\\.]+).*?<"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.knowmyip.com/", "Your ip is:.*?<b> ([\\d+\\.]+)</b></font>"});
        IP_CHECK_SERVICES.add(new String[]{"http://whatsmyip.net/", "Address is: <span>([\\d+\\.]+)</span>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.faqs.org/ip.php", "Your IP address is: ([\\d+\\.]+).*?</p>"});
        IP_CHECK_SERVICES.add(new String[]{"http://showip.net/", "boxmaincontent\" id=\"ipaddress\">.*?([\\d+\\.]+)<di"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.ipaddresslocation.org/", "My IP Address.*?<span class=\"pb\"><b>([\\d+\\.]+)</b></span>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.spyber.com/", "<font size=.*?><b>.*?IP: ([\\d+\\.]+)</b>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.formyip.com/", "<strong>Your IP is ([\\d+\\.]+)</strong>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.whatismyipv6.net/", "Your IP is ([\\d+\\.]+)<"});
        IP_CHECK_SERVICES.add(new String[]{"http://myipinfo.net/", "computer.*?IP address is:.*?<p><b>([\\d+\\.]+)</b>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.moanmyip.com/", "Your external IP address</h2>.*?<div class=.*?>([\\d+\\.]+)</div>"});
        IP_CHECK_SERVICES.add(new String[]{"http://www.ip2stuff.com/", "your IP address\">.*?([\\d+\\.]+) -"});
        Collections.shuffle(IP_CHECK_SERVICES);
        LATEST_IP = null;
    }

    public static String getIPAddress(Browser br) {
        if (br == null) {
            br = new Browser();
            br.getHeaders().put("User-Agent", RandomUserAgent.generate());
            br.setConnectTimeout(15000);
            br.setReadTimeout(15000);
        }
        if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("GLOBAL_IP_BALANCE2", true).booleanValue()) {
            String ip = IPCheck.getBalancedIP(br);
            if (ip == null) {
                ip = IPCheck.getBalancedIP(br);
            }
            if (ip != null) {
                LATEST_IP = ip;
                return LATEST_IP;
            }
        } else {
            String site = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("GLOBAL_IP_CHECK_SITE2", IP_CHECK_SERVICES.get(0)[0]);
            String patt = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("GLOBAL_IP_PATTERN2", IP_CHECK_SERVICES.get(0)[1]);
            try {
                JDLogger.getLogger().finer("UserDefined IP Check via " + site);
                Pattern pattern = Pattern.compile(patt);
                Matcher matcher = pattern.matcher(br.getPage(site));
                if (matcher.find() && matcher.groupCount() > 0) {
                    LATEST_IP = matcher.group(1);
                    return LATEST_IP;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LATEST_IP = null;
            JDLogger.getLogger().finer("UserDefined IP Check failed. IP not found via regex: " + patt + " on " + site);
        }
        try {
            JDLogger.getLogger().finer("Fallback IP Check via JDownloader-IPCheck");
            Pattern pattern = Pattern.compile(FALLBACK_CHECK_REGEX);
            Matcher matcher = pattern.matcher(br.getPage(FALLBACK_CHECK_SITE));
            if (matcher.find() && matcher.groupCount() > 0) {
                LATEST_IP = matcher.group(1);
                return LATEST_IP;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LATEST_IP = null;
        JDLogger.getLogger().finer("Fallback IP Check failed.");
        return "offline";
    }

    public static String getLatestIP() {
        if (LATEST_IP == null) {
            IPCheck.getIPAddress(null);
        }
        return LATEST_IP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBalancedIP(Browser br) {
        if (IP_CHECK_SERVICES.size() == 0) {
            return null;
        }
        if (br == null) {
            br = new Browser();
            br.getHeaders().put("User-Agent", RandomUserAgent.generate());
            br.setConnectTimeout(10000);
            br.setReadTimeout(10000);
        }
        Object object = LOCK;
        synchronized (object) {
            String[] ipcheck;
            block9: {
                ipcheck = IP_CHECK_SERVICES.get(IP_CHECK_INDEX %= IP_CHECK_SERVICES.size());
                ++IP_CHECK_INDEX;
                if (ipcheck.length == 2) break block9;
                return null;
            }
            try {
                Pattern pattern = Pattern.compile(ipcheck[1], 34);
                Matcher matcher = pattern.matcher(br.getPage(ipcheck[0]));
                if (matcher.find() && matcher.groupCount() > 0) {
                    LATEST_IP = matcher.group(1);
                    return LATEST_IP;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            JDLogger.getLogger().finer("Balance IP Check failed. IP not found via regex: " + ipcheck[1] + " on " + ipcheck[0]);
        }
        return null;
    }
}

