/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import jd.parser.Regex;

public class JDProxy
extends Proxy {
    private String user = null;
    private String pass = null;
    private int port = 80;
    private String host;
    private boolean direct = false;
    public static JDProxy NO_PROXY = new JDProxy();

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public int getPort() {
        return this.port;
    }

    public JDProxy(Proxy.Type type, SocketAddress sa) {
        super(type, sa);
        this.host = new Regex(sa.toString(), "(.*)\\/").getMatch(0);
    }

    public JDProxy(Proxy.Type type, String host, int port) {
        super(type, new InetSocketAddress(host, port));
        this.port = port;
        this.host = host;
    }

    public JDProxy(String hostAndPort) {
        super(Proxy.Type.HTTP, new InetSocketAddress(hostAndPort.split("\\:")[0], Integer.parseInt(hostAndPort.split("\\:")[1])));
        this.port = Integer.parseInt(hostAndPort.split("\\:")[1]);
        this.host = hostAndPort.split("\\:")[0];
    }

    public JDProxy(String host, int port, String user, String pass) {
        super(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        this.port = port;
        this.user = user;
        this.pass = pass;
        this.host = host;
    }

    private JDProxy() {
        super(Proxy.Type.HTTP, new InetSocketAddress(80));
        this.direct = true;
    }

    public Proxy.Type type() {
        if (this.direct) {
            return Proxy.Type.DIRECT;
        }
        return super.type();
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        return "JDProxy: " + super.toString();
    }
}

