/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.JDProxy;
import jd.http.RequestHeader;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Request {
    private int connectTimeout;
    private Cookies cookies = null;
    private int followCounter = 0;
    private boolean followRedirects = false;
    private RequestHeader headers;
    private String htmlCode;
    protected URLConnectionAdapter httpConnection;
    private long readTime = -1L;
    private int readTimeout;
    private boolean requested = false;
    private long requestTime = -1L;
    private URL url;
    private JDProxy proxy;
    private URL orgURL;
    private String customCharset = null;

    public static LinkedHashMap<String, String> parseQuery(String query) throws MalformedURLException {
        if (query == null) {
            return null;
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (query.toLowerCase().trim().startsWith("http")) {
            query = new URL(query).getQuery();
        }
        if (query == null) {
            return ret;
        }
        String[][] split = new Regex(query.trim(), "&?(.*?)=(.*?)($|&(?=.*?=.+))").getMatches();
        if (split != null) {
            int i = 0;
            while (i < split.length) {
                ret.put(split[i][0], split[i][1]);
                ++i;
            }
        }
        return ret;
    }

    private static String http2JDP(String string) {
        if (string.startsWith("http")) {
            return "jdp" + string.substring(4);
        }
        return string;
    }

    private static String jdp2http(String string) {
        if (string.startsWith("jdp")) {
            return "http" + string.substring(3);
        }
        return string;
    }

    public void setCustomCharset(String charset) {
        this.customCharset = charset;
    }

    public Request(String url) throws MalformedURLException {
        this.url = new URL(Encoding.urlEncode_light(Request.http2JDP(url)));
        this.orgURL = new URL(Request.jdp2http(url));
        this.initDefaultHeader();
    }

    public void setProxy(JDProxy proxy) {
        this.proxy = proxy;
    }

    public JDProxy getProxy() {
        return this.proxy;
    }

    public String printHeaders() {
        return this.httpConnection.toString();
    }

    public Request(URLConnectionAdapter con) {
        this.httpConnection = con;
        this.collectCookiesFromConnection();
    }

    private void collectCookiesFromConnection() {
        List cookieHeaders = (List)this.httpConnection.getHeaderFields().get("Set-Cookie");
        String Date2 = this.httpConnection.getHeaderField("Date");
        if (cookieHeaders == null) {
            return;
        }
        if (this.cookies == null) {
            this.cookies = new Cookies();
        }
        String host = Browser.getHost(this.httpConnection.getURL());
        int i = cookieHeaders.size() - 1;
        while (i >= 0) {
            String header = (String)cookieHeaders.get(i);
            this.cookies.add(Cookies.parseCookies(header, host, Date2));
            --i;
        }
    }

    protected Request connect() throws IOException {
        this.requested = true;
        this.openConnection();
        this.postRequest(this.httpConnection);
        try {
            this.collectCookiesFromConnection();
        }
        catch (NullPointerException e) {
            throw new IOException("Malformed url?", e);
        }
        return this;
    }

    public boolean containsHTML(String html) {
        if (this.htmlCode == null) {
            return false;
        }
        return this.htmlCode.contains(html);
    }

    public void setCookies(Cookies cookies) {
        this.cookies = cookies;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getContentLength() {
        if (this.httpConnection == null) {
            return -1L;
        }
        return this.httpConnection.getLongContentLength();
    }

    public Cookies getCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies();
        }
        return this.cookies;
    }

    public String getCookieString() {
        return Request.getCookieString(this.cookies);
    }

    public static String getCookieString(Cookies cookies) {
        if (cookies == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        LinkedList<Cookie> cookies2 = new LinkedList<Cookie>(cookies.getCookies());
        for (Cookie cookie : cookies2) {
            if (cookie.isExpired()) continue;
            if (first) {
                first = false;
            } else {
                buffer.append("; ");
            }
            buffer.append(cookie.getKey());
            buffer.append("=");
            buffer.append(cookie.getValue());
        }
        return buffer.toString();
    }

    public int getFollowCounter() {
        return this.followCounter;
    }

    public RequestHeader getHeaders() {
        return this.headers;
    }

    public String getHtmlCode() {
        return this.htmlCode;
    }

    public URLConnectionAdapter getHttpConnection() {
        return this.httpConnection;
    }

    public String getLocation() {
        if (this.httpConnection == null) {
            return null;
        }
        String red = this.httpConnection.getHeaderField("Location");
        String encoding = this.httpConnection.getHeaderField("Content-Type");
        if (red == null || red.length() == 0) {
            return null;
        }
        if (encoding != null && encoding.contains("UTF-8")) {
            red = Encoding.UTF8Decode(red, "ISO-8859-1");
        }
        try {
            new URL(red);
        }
        catch (Exception e) {
            String path = this.getHttpConnection().getURL().getFile();
            if (!path.endsWith("/")) {
                int lastSlash = path.lastIndexOf("/");
                path = lastSlash > 0 ? path.substring(0, path.lastIndexOf("/")) : "";
            }
            red = "http://" + this.getHttpConnection().getURL().getHost() + (red.charAt(0) == '/' ? red : String.valueOf(path) + "/" + red);
        }
        return Encoding.urlEncode_light(red);
    }

    public long getReadTime() {
        return this.readTime;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String getResponseHeader(String key) {
        if (this.httpConnection == null) {
            return null;
        }
        return this.httpConnection.getHeaderField(key);
    }

    public Map<String, ArrayList<String>> getResponseHeaders() {
        if (this.httpConnection == null) {
            return null;
        }
        return this.httpConnection.getHeaderFields();
    }

    public URL getUrl() {
        return this.orgURL;
    }

    public URL getJDPUrl() {
        return this.url;
    }

    private boolean hasCookies() {
        return this.cookies != null && !this.cookies.isEmpty();
    }

    private void initDefaultHeader() {
        this.headers = new RequestHeader();
        this.headers.put("User-Agent", "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.0.10) Gecko/2009042523 Ubuntu/9.04 (jaunty) Firefox/3.0.10");
        this.headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.headers.put("Accept-Language", "de, en-gb;q=0.9, en;q=0.8");
        this.headers.put("Accept-Encoding", "gzip,deflate");
        this.headers.put("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        this.headers.put("Cache-Control", "no-cache");
        this.headers.put("Pragma", "no-cache");
        this.headers.put("Connection", "close");
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public String load() throws IOException {
        this.requestConnection();
        return this.htmlCode;
    }

    public boolean matches(Pattern pat) {
        return new Regex(this.htmlCode, pat).matches();
    }

    public boolean matches(String pat) {
        return new Regex(this.htmlCode, pat).matches();
    }

    private void openConnection() throws IOException {
        long tima = System.currentTimeMillis();
        if (!this.headers.contains("Host")) {
            if (this.url.getPort() != 80 && this.url.getPort() > 0) {
                this.headers.setAt(0, "Host", String.valueOf(this.url.getHost()) + ":" + this.url.getPort());
            } else {
                this.headers.setAt(0, "Host", this.url.getHost());
            }
        }
        this.httpConnection = this.proxy != null ? (URLConnectionAdapter)((Object)this.url.openConnection(this.proxy)) : (URLConnectionAdapter)((Object)this.url.openConnection());
        this.httpConnection.setRequest(this);
        this.httpConnection.setInstanceFollowRedirects(this.followRedirects);
        this.requestTime = System.currentTimeMillis() - tima;
        this.httpConnection.setReadTimeout(this.readTimeout);
        this.httpConnection.setConnectTimeout(this.connectTimeout);
        if (this.headers != null) {
            int i = 0;
            while (i < this.headers.size()) {
                this.httpConnection.setRequestProperty(this.headers.getKey(i), this.headers.getValue(i));
                ++i;
            }
        }
        this.preRequest(this.httpConnection);
        if (this.hasCookies()) {
            this.httpConnection.setRequestProperty("Cookie", this.getCookieString());
        }
    }

    public abstract void postRequest(URLConnectionAdapter var1) throws IOException;

    public abstract void preRequest(URLConnectionAdapter var1) throws IOException;

    public String read() throws IOException {
        long tima = System.currentTimeMillis();
        this.httpConnection.setCharset(this.customCharset);
        this.htmlCode = Request.read(this.httpConnection);
        this.readTime = System.currentTimeMillis() - tima;
        return this.htmlCode.toString();
    }

    public static String read(URLConnectionAdapter con) throws IOException {
        StringBuilder htmlCode;
        block23: {
            InputStreamReader isr;
            InputStream is = con.getHeaderField("Content-Encoding") != null && con.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip") ? new GZIPInputStream(con.getInputStream()) : con.getInputStream();
            String cs = con.getCharset();
            if (cs == null) {
                isr = new InputStreamReader(is, "ISO-8859-1");
            } else {
                cs = cs.toUpperCase();
                try {
                    isr = new InputStreamReader(is, cs);
                }
                catch (Exception e) {
                    JDLogger.getLogger().log(Level.SEVERE, "Could not Handle Charset " + cs, e);
                    try {
                        isr = new InputStreamReader(is, cs.replace("-", ""));
                    }
                    catch (Exception e2) {
                        JDLogger.getLogger().log(Level.SEVERE, "Could not Handle Charset " + cs, e);
                        isr = new InputStreamReader(is);
                    }
                }
            }
            BufferedReader rd = new BufferedReader(isr);
            htmlCode = new StringBuilder();
            try {
                String line;
                while ((line = rd.readLine()) != null) {
                    htmlCode.append(String.valueOf(line) + "\r\n");
                }
            }
            catch (EOFException e) {
                JDLogger.getLogger().log(Level.SEVERE, "Try workaround for ", e);
                try {
                    rd.close();
                }
                catch (Exception exception) {}
                break block23;
            }
            catch (IOException e) {
                try {
                    if (e.toString().contains("end of ZLIB") || e.toString().contains("Premature")) {
                        JDLogger.getLogger().log(Level.SEVERE, "Try workaround for ", e);
                        break block23;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        rd.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                rd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return htmlCode.toString();
    }

    private void requestConnection() throws IOException {
        this.connect();
        this.htmlCode = this.read();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String toString() {
        if (!this.requested) {
            return "Request not sent yet";
        }
        if (this.htmlCode == null || this.htmlCode.length() == 0) {
            if (this.getLocation() != null) {
                return "Not HTML Code. Redirect to: " + this.getLocation();
            }
            return "No htmlCode read";
        }
        return this.htmlCode;
    }

    public void setHtmlCode(String htmlCode) {
        this.htmlCode = htmlCode;
    }

    public Request toHeadRequest() throws MalformedURLException {
        Request ret = new Request("" + this.getUrl()){

            public void postRequest(URLConnectionAdapter httpConnection) throws IOException {
            }

            public void preRequest(URLConnectionAdapter httpConnection) throws IOException {
                httpConnection.setRequestMethod("HEAD");
            }
        };
        ret.connectTimeout = this.connectTimeout;
        ret.cookies = new Cookies(this.getCookies());
        ret.followRedirects = this.followRedirects;
        ret.headers = (RequestHeader)this.getHeaders().clone();
        ret.setProxy(this.proxy);
        ret.readTime = this.readTimeout;
        ret.httpConnection = this.httpConnection;
        return ret;
    }

    public Request cloneRequest() {
        return null;
    }
}

