/*
 * Decompiled with CFR 0.152.
 */
package jd.http.download;

import java.io.File;
import java.util.ArrayList;
import jd.http.download.DownloadEvent;
import jd.http.download.DownloadListener;

public abstract class DownloadInterface {
    private int flags = 0;
    private ArrayList<DownloadListener> downloadListener;
    private File outputFile;

    public DownloadInterface(int flags, File file) {
        this.flags = flags;
        this.outputFile = file;
        this.downloadListener = new ArrayList();
    }

    protected void fireEvent(DownloadEvent downloadEvent) {
        for (DownloadListener dl : this.downloadListener) {
            dl.onStatus(downloadEvent);
        }
    }

    protected void fireEvent(int eventID) {
        this.fireEvent(new DownloadEvent(eventID, this));
    }

    public abstract void setBandwidthLimit(long var1);

    public abstract long getFileSize();

    public abstract long getBandwidthLimit();

    public void addDownloadListener(DownloadListener downloadListener) {
        this.removeDownloadListener(downloadListener);
        this.downloadListener.add(downloadListener);
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public abstract long getSpeed();

    public void removeDownloadListener(DownloadListener downloadListener) {
        this.downloadListener.remove(downloadListener);
    }

    public void addStatus(int status) {
        this.flags |= status;
    }

    public boolean hasStatus(int status) {
        return (this.flags & status) > 0;
    }

    public void removeStatus(int status) {
        int mask = -1;
        this.flags &= (mask &= ~status);
    }
}

