/*
 * Decompiled with CFR 0.152.
 */
package jd.http.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Comparator;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.http.Request;
import jd.http.download.BrowserException;
import jd.http.download.ChunkProgress;
import jd.http.download.DownloadChunk;
import jd.http.download.DownloadEvent;
import jd.http.download.DownloadInterface;
import jd.http.download.DownloadListener;
import jd.http.download.DownloadProgress;
import jd.nutils.Threader;
import jd.nutils.jobber.JDRunnable;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPDownload
extends DownloadInterface {
    public static final int FLAG_RESUME = 1;
    private static final int FLAG_FILESIZE_CORRECT = 2;
    private Request orgRequest;
    private int desiredChunkNum;
    private Threader chunks;
    private long fileSize;
    private RandomAccessFile outputRAF;
    private FileChannel outputChannel;
    private long bandwidthLimit;
    private int activeChunks = 0;
    private DownloadProgress downloadProgress;
    private Browser browser;

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public synchronized int getActiveChunks() {
        return this.activeChunks;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public HTTPDownload(Request request, Browser br, File file, int flags) {
        super(flags, file);
        this.orgRequest = request;
        this.browser = br;
        this.downloadProgress = new DownloadProgress(file);
    }

    public HTTPDownload(Request request, Browser br, File file) {
        super(0, file);
        this.orgRequest = request;
        this.browser = br;
        this.downloadProgress = new DownloadProgress(file);
    }

    public static void debug(String msg) {
        try {
            throw new Exception();
        }
        catch (Exception ee) {
            System.err.println(String.valueOf(ee.getStackTrace()[1].getClassName()) + "." + ee.getStackTrace()[1].getMethodName() + "[" + ee.getStackTrace()[1].getLineNumber() + "] " + msg);
            return;
        }
    }

    public static void main(String[] args) {
        block6: {
            try {
                String destPath = "c:/test.download";
                Browser br = new Browser();
                br.setDebug(true);
                Request request = br.createGetRequest("http://service.jdownloader.org/testfiles/25bmtest.zip");
                HTTPDownload dl = new HTTPDownload(request, br, new File(destPath), 1);
                dl.setDesiredChunkNum(3);
                dl.addDownloadListener(new DownloadListener(){

                    public void onStatus(DownloadEvent downloadEvent) {
                        System.out.print("New eventid: " + downloadEvent.getId());
                    }
                });
                try {
                    new Thread(){

                        public void run() {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (Exception e) {
                                JDLogger.exception(e);
                            }
                        }
                    }.start();
                    dl.start();
                    long crc = JDUtilities.getCRC(new File(destPath));
                    if ("862E7007".trim().endsWith(Long.toHexString(crc).toUpperCase())) {
                        System.out.println("CRC OK");
                        break block6;
                    }
                    System.out.println("CRC FAULT");
                }
                catch (BrowserException e) {
                    JDLogger.exception(e);
                    if (e.getType() == 4) {
                        new File(destPath).delete();
                        JDLogger.exception(e);
                    }
                }
            }
            catch (Exception e) {
                JDLogger.exception(e);
            }
        }
    }

    @Override
    public void setBandwidthLimit(long bytesPerSecond) {
        this.bandwidthLimit = bytesPerSecond;
    }

    public void setDesiredChunkNum(int i) throws BrowserException, InterruptedException {
        if (i == this.desiredChunkNum) {
            return;
        }
        this.desiredChunkNum = i;
        this.updateChunks();
    }

    private void updateChunks() throws BrowserException, InterruptedException {
        if (this.chunks == null || !this.chunks.isHasStarted()) {
            return;
        }
        int num = this.getActiveChunks();
        if (num == this.desiredChunkNum) {
            return;
        }
        int i = this.chunks.size() - 1;
        while (i >= 0) {
            DownloadChunk dc = (DownloadChunk)this.chunks.get(i);
            if (!dc.isConnectionRequested()) {
                return;
            }
            --i;
        }
        if (num < this.desiredChunkNum) {
            System.out.println("AddChunk");
            this.addChunksDyn(1);
        }
        if (num > this.desiredChunkNum) {
            System.out.println("RemoveChunk");
            this.removeChunksDyn(1);
        }
    }

    private void removeChunksDyn(int i) throws InterruptedException {
        while (i-- > 0) {
            this.removeChunk();
        }
    }

    private void removeChunk() throws InterruptedException {
        DownloadChunk slowest = null;
        int i = this.chunks.size() - 1;
        while (i >= 0) {
            DownloadChunk dc = (DownloadChunk)this.chunks.get(i);
            if (dc.isAlive()) {
                slowest = dc;
                break;
            }
            --i;
        }
        if (slowest == null) {
            return;
        }
        System.out.println("Disconnect chunk " + slowest + " remaining: " + slowest.getRemainingChunkBytes() + " " + slowest.getChunkBytes());
        slowest.setChunkEnd(slowest.getChunkStart() + slowest.getChunkBytes());
        while (slowest.isAlive()) {
            System.out.print("|");
            Thread.sleep(50L);
        }
        System.out.println("Disconnected");
    }

    private void addChunksDyn(int i) throws BrowserException {
        while (i-- > 0) {
            this.addChunk();
        }
    }

    private void addChunk() throws BrowserException {
        DownloadChunk biggestRemaining = null;
        int i = 0;
        while (i < this.chunks.size()) {
            System.out.println(this.chunks.get(i) + ":" + ((DownloadChunk)this.chunks.get(i)).getRemainingChunkBytes());
            if (biggestRemaining == null || biggestRemaining.getRemainingChunkBytes() < ((DownloadChunk)this.chunks.get(i)).getRemainingChunkBytes()) {
                biggestRemaining = (DownloadChunk)this.chunks.get(i);
            }
            ++i;
        }
        if (biggestRemaining.getRemainingChunkBytes() < Math.max(0x20000000L, this.getSpeed() * 10L)) {
            System.out.println(biggestRemaining + " New size(to small)");
            return;
        }
        long newSize = biggestRemaining.getRemainingChunkBytes() / 2L;
        System.out.println(biggestRemaining + " New size: " + newSize);
        long old = biggestRemaining.getChunkEnd();
        biggestRemaining.setChunkEnd(biggestRemaining.getChunkStart() + biggestRemaining.getChunkBytes() + newSize);
        DownloadChunk newChunk = new DownloadChunk(this, biggestRemaining.getChunkEnd() + 1L, old);
        System.out.println("SPLIT: " + biggestRemaining + " + " + newChunk);
        this.chunks.add(newChunk);
    }

    public void start() throws IOException, BrowserException {
        this.fireEvent(4);
        this.initOutputChannel();
        if (this.hasStatus(1) || !this.importResumeInfos()) {
            this.initChunks();
        }
        this.fireEvent(1);
        this.download();
        this.fireEvent(2);
        System.out.println("Close and UNlock file");
        this.closeFileDiscriptors();
        this.clean();
        this.fireEvent(8);
    }

    private void closeFileDiscriptors() {
        try {
            this.outputChannel.force(false);
        }
        catch (Exception e) {
            JDLogger.exception(e);
        }
        try {
            this.outputRAF.close();
        }
        catch (Exception e) {
            JDLogger.exception(e);
        }
        try {
            this.outputChannel.close();
        }
        catch (Exception e) {
            JDLogger.exception(e);
        }
    }

    private void clean() throws BrowserException {
        if (!new File(String.valueOf(this.getOutputFile().getAbsolutePath()) + ".part").renameTo(this.getOutputFile())) {
            throw new BrowserException(JDL.L((String)"exceptions.browserexception.couldnotrenam", (String)"Could not rename getOutputFile()"), 4);
        }
        if (!new File(String.valueOf(this.getOutputFile().getAbsolutePath()) + ".jdp").delete()) {
            new File(String.valueOf(this.getOutputFile().getAbsolutePath()) + ".jdp").deleteOnExit();
        }
    }

    private void download() {
        this.chunks.startAndWait();
    }

    private void initOutputChannel() throws FileNotFoundException, BrowserException {
        if (this.getOutputFile().exists()) {
            throw new BrowserException(JDL.L((String)"exceptions.browserexception.alreadyexists", (String)"getOutputFile() already exists"), 4);
        }
        if (new File(String.valueOf(this.getOutputFile().getAbsolutePath()) + ".part").exists() && !this.hasStatus(1) && !new File(String.valueOf(this.getOutputFile().getAbsolutePath()) + ".part").delete()) {
            throw new BrowserException("Could not delete *.part file", 4);
        }
        if (!this.getOutputFile().getParentFile().exists()) {
            this.getOutputFile().getParentFile().mkdirs();
        }
        this.outputRAF = new RandomAccessFile(String.valueOf(this.getOutputFile().getAbsolutePath()) + ".part", "rw");
        this.outputChannel = this.outputRAF.getChannel();
    }

    private synchronized void checkForMissingParts() throws BrowserException {
        ArrayList<Long[]> missing = this.getMissingParts();
        if (missing.size() == 0) {
            return;
        }
        int activeChunks = this.chunks.getAlive().size();
        System.out.println("Active chunks: " + activeChunks);
        System.out.println("Missing parts: " + missing.size());
        int i = 0;
        while (i < missing.size()) {
            System.out.println("Missing: " + missing.get(i)[0] + "-" + missing.get(i)[1]);
            ++i;
        }
        i = 0;
        while (activeChunks < this.desiredChunkNum && missing.size() > i) {
            DownloadChunk newChunk = new DownloadChunk(this, missing.get(i)[0], missing.get(i)[1]);
            System.out.println("New chunk: " + newChunk);
            this.chunks.add(newChunk);
            ++i;
            ++activeChunks;
        }
    }

    private ArrayList<Long[]> getMissingParts() {
        ArrayList<Long[]> missing = new ArrayList<Long[]>();
        this.chunks.sort(new Comparator<Threader.Worker>(){

            @Override
            public int compare(Threader.Worker o1, Threader.Worker o2) {
                return Long.valueOf(((DownloadChunk)o1.getRunnable()).getChunkStart()).compareTo(((DownloadChunk)o2.getRunnable()).getChunkStart());
            }
        });
        DownloadChunk lastChunk = (DownloadChunk)this.chunks.get(0);
        if (lastChunk.getChunkStart() > 0L) {
            missing.add(new Long[]{0L, lastChunk.getChunkStart() - 1L});
        }
        int i = 1;
        while (i < this.chunks.size()) {
            DownloadChunk chunk = (DownloadChunk)this.chunks.get(i);
            if (chunk.getChunkStart() != lastChunk.getChunkEnd() + 1L) {
                if (chunk.getChunkStart() < lastChunk.getChunkEnd() + 1L) {
                    System.err.println("Overlap  Chunks: " + chunk + " - " + lastChunk);
                } else {
                    Long[] add = new Long[]{lastChunk.getChunkEnd() + 1L, ((DownloadChunk)this.chunks.get(i)).getChunkStart() - 1L};
                    missing.add(add);
                    if (add[0] == 0L && add[1] == -1L) {
                        add[0] = 0L;
                    }
                }
            }
            lastChunk = chunk;
            ++i;
        }
        if (lastChunk.getChunkEnd() != -1L && lastChunk.getChunkEnd() != this.fileSize - 1L) {
            missing.add(new Long[]{lastChunk.getChunkEnd() + 1L, -1L});
        }
        return missing;
    }

    private void initChunks() throws IOException, BrowserException {
        this.chunks = new Threader();
        this.chunks.getBroadcaster().addListener(new Threader.WorkerListener(this.chunks){

            public void onThreadException(Threader th, JDRunnable job, Exception e) {
                System.err.println(job);
                JDLogger.exception(e);
            }

            public void onThreadFinished(Threader th, JDRunnable job) {
                try {
                    HTTPDownload.this.updateActiveChunkCount(-1);
                    HTTPDownload.this.fireEvent(new DownloadEvent(16, HTTPDownload.this, (DownloadChunk)job));
                    HTTPDownload.this.checkForMissingParts();
                    HTTPDownload.this.updateChunks();
                }
                catch (BrowserException e) {
                    JDLogger.exception(e);
                }
                catch (InterruptedException e) {
                    JDLogger.exception(e);
                }
                this.updateSpeedMeters();
            }

            private void updateSpeedMeters() {
                if (HTTPDownload.this.chunks == null || HTTPDownload.this.activeChunks == 0) {
                    return;
                }
                int i = 0;
                while (i < HTTPDownload.this.chunks.size()) {
                    ((DownloadChunk)HTTPDownload.this.chunks.get(i)).resetSpeedMeter();
                    ++i;
                }
            }

            public void onThreadStarts(Threader threader, JDRunnable runnable) {
                HTTPDownload.this.updateActiveChunkCount(1);
                HTTPDownload.this.fireEvent(new DownloadEvent(32, HTTPDownload.this, (DownloadChunk)runnable));
                try {
                    HTTPDownload.this.updateChunks();
                }
                catch (BrowserException e) {
                    JDLogger.exception(e);
                }
                catch (InterruptedException e) {
                    JDLogger.exception(e);
                }
            }
        });
        DownloadChunk chunk = new DownloadChunk(this);
        this.orgRequest.getHeaders().remove("Range");
        chunk.connect();
        System.out.println(this.orgRequest.printHeaders());
        if (this.orgRequest.getContentLength() > 0L) {
            this.fileSize = this.orgRequest.getContentLength();
            this.addStatus(2);
        }
        System.out.println("Chunksize: " + this.fileSize / (long)this.desiredChunkNum);
        chunk.setRange(0L, this.fileSize / (long)this.desiredChunkNum + 1L);
        this.chunks.add(chunk);
        int i = 1;
        while (i < this.desiredChunkNum) {
            chunk = i < this.desiredChunkNum - 1 ? new DownloadChunk(this, chunk.getChunkEnd(), this.fileSize * (long)(i + 1) / (long)this.desiredChunkNum + 1L) : new DownloadChunk(this, chunk.getChunkEnd(), -1L);
            this.chunks.add(chunk);
            ++i;
        }
    }

    protected synchronized void updateActiveChunkCount(int i) {
        this.activeChunks += i;
        System.out.println("Active CHunks " + this.activeChunks + "(" + i + ")");
    }

    private boolean importResumeInfos() {
        return false;
    }

    private synchronized void updateDownloadProgress() {
        this.downloadProgress.reset(this.chunks.size());
        this.downloadProgress.totalLoaded = 0;
        int i = 0;
        while (i < this.chunks.size()) {
            DownloadChunk chunk = (DownloadChunk)this.chunks.get(i);
            ChunkProgress cp = chunk.getChunkProgress();
            this.downloadProgress.add(cp);
            this.downloadProgress.totalLoaded = (int)((long)this.downloadProgress.totalLoaded + (cp.getEnd() - cp.getStart() - 1L));
            ++i;
        }
    }

    public DownloadProgress getDownloadProgress() {
        return this.downloadProgress;
    }

    public FileChannel getOutputChannel() {
        return this.outputChannel;
    }

    public Request getRequest() {
        return this.orgRequest;
    }

    public long getChunkBandwidth() {
        if (this.bandwidthLimit <= 0L) {
            return -1L;
        }
        return Math.max(1L, this.bandwidthLimit / (long)this.getActiveChunks() + this.bandwidthLimit);
    }

    protected void onBufferWritten(DownloadChunk downloadChunk) {
        this.fireEvent(new DownloadEvent(64, this, downloadChunk));
        this.updateDownloadProgress();
    }

    @Override
    public long getSpeed() {
        long speed = 0L;
        if (this.chunks == null || this.activeChunks == 0) {
            return 0L;
        }
        int i = 0;
        while (i < this.chunks.size()) {
            speed += ((DownloadChunk)this.chunks.get(i)).getSpeed();
            ++i;
        }
        return speed;
    }

    @Override
    public long getBandwidthLimit() {
        return this.bandwidthLimit;
    }
}

