/*
 * Decompiled with CFR 0.152.
 */
package jd.http.requests;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.FormData;

public class PostFormDataRequest
extends Request {
    private String boundary;
    private ArrayList<FormData> formDatas;
    private OutputStream output;
    private String encodeType = "multipart/form-data";

    public String getEncodeType() {
        return this.encodeType;
    }

    public void setEncodeType(String encodeType) {
        this.encodeType = encodeType;
    }

    public PostFormDataRequest(String url) throws MalformedURLException {
        super(url);
        this.generateBoundary();
        this.formDatas = new ArrayList();
    }

    public void postRequest(URLConnectionAdapter httpConnection) throws IOException {
        httpConnection.setDoOutput(true);
        this.output = httpConnection.getOutputStream();
        int i = 0;
        while (i < this.formDatas.size()) {
            this.write(this.formDatas.get(i));
            ++i;
        }
        OutputStreamWriter writer = new OutputStreamWriter(this.output);
        writer.write(this.boundary);
        writer.write("--\r\n");
        writer.flush();
        if (this.output != null) {
            this.output.flush();
            this.output.close();
        }
    }

    private void write(FormData formData) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(this.output);
        writer.write(this.boundary);
        writer.write("\r\n");
        switch (formData.getType()) {
            case VARIABLE: {
                writer.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"");
                writer.write("\r\n\r\n");
                writer.write(String.valueOf(formData.getValue()) + "\r\n");
                break;
            }
            case DATA: {
                writer.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + formData.getValue() + "\"");
                writer.write("\r\nContent-Type: " + formData.getDataType() + "\r\n\r\n");
                writer.flush();
                BufferedOutputStream outputByteWriter = new BufferedOutputStream(this.output);
                outputByteWriter.write(formData.getData(), 0, formData.getData().length);
                writer.write("\r\n");
                writer.flush();
                outputByteWriter.flush();
                break;
            }
            case FILE: {
                int n;
                writer.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + formData.getValue() + "\"");
                writer.write("\r\nContent-Type: " + formData.getDataType() + "\r\n\r\n");
                writer.flush();
                byte[] b = new byte[1024];
                FileInputStream in = new FileInputStream(formData.getFile());
                BufferedOutputStream outputByteWriter = new BufferedOutputStream(this.output);
                while ((n = ((InputStream)in).read(b)) > -1) {
                    outputByteWriter.write(b, 0, n);
                }
                outputByteWriter.flush();
                ((InputStream)in).close();
                writer.write("\r\n");
                writer.flush();
            }
        }
        writer.flush();
    }

    public void preRequest(URLConnectionAdapter httpConnection) throws IOException {
        httpConnection.setRequestMethod("POST");
        httpConnection.setRequestProperty("Content-Type", String.valueOf(this.encodeType) + "; boundary=" + this.boundary.substring(2));
    }

    private void generateBoundary() {
        long range = 899999999999999L;
        long rand = (long)(Math.random() * (double)range) + 100000000000000L;
        this.boundary = "---------------------" + rand;
    }

    public static void main(String[] args) throws IOException {
        try {
            Browser br = new Browser();
            br.setDebug(true);
            String[] data = br.getPage("http://rapidshare.com/cgi-bin/upload.cgi?intsysdata=1").split("\\,");
            PostFormDataRequest r = (PostFormDataRequest)br.createPostFormDataRequest("http://rs" + data[0].trim() + "cg.rapidshare.com/cgi-bin/upload.cgi");
            File file = new File("G:\\pluginressourcen\\JDLowSpeed_2009-02-11_v3 (LIGHT).jdu");
            r.addFormData(new FormData("toolmode2", "1"));
            r.addFormData(new FormData("filecontent", file.getName(), file));
            r.addFormData(new FormData("freeaccountid", ""));
            r.addFormData(new FormData("password", ""));
            r.connect();
            System.out.println(r.getHttpConnection());
            String code = r.read();
            System.out.println(code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addFormData(FormData fd) {
        this.formDatas.add(fd);
    }

    public String getPostDataString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.formDatas.size()) {
            this.write(this.formDatas.get(i), sb);
            ++i;
        }
        sb.append(this.boundary);
        sb.append("--\r\n");
        return "" + sb;
    }

    private void write(FormData formData, StringBuffer sb) {
        sb.append(this.boundary);
        sb.append("\r\n");
        switch (formData.getType()) {
            case VARIABLE: {
                sb.append("Content-Disposition: form-data; name=\"" + formData.getName() + "\"");
                sb.append("\r\n\r\n");
                sb.append(String.valueOf(formData.getValue()) + "\r\n");
                break;
            }
            case DATA: {
                sb.append("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + formData.getValue() + "\"");
                sb.append("\r\nContent-Type: " + formData.getDataType() + "\r\n\r\n");
                sb.append("[....." + formData.getData().length + " Byte DATA....]\r\n");
                break;
            }
            case FILE: {
                sb.append("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + formData.getValue() + "\"");
                sb.append("\r\nContent-Type: " + formData.getDataType() + "\r\n\r\n");
                sb.append("[....." + formData.getFile().length() + " FileByte DATA....]");
                sb.append("\r\n");
            }
        }
    }
}

