/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    public static ArrayList<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        return ClassFinder.getClasses(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static ArrayList<Class<?>> getClasses(String packageName, ClassLoader classLoader) throws ClassNotFoundException, IOException {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            try {
                classes.addAll(ClassFinder.findPlugins(resources.nextElement(), packageName, classLoader));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    private static List<Class<?>> findPlugins(URL directory, String packageName, ClassLoader classLoader) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        File[] files = null;
        try {
            files = new File(directory.toURI().getPath()).listFiles();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (files == null) {
            try {
                JarEntry e;
                String path = directory.toString().substring(4);
                String[] splitted = path.split("!");
                splitted[1] = splitted[1].substring(1);
                File file = new File(new URL(splitted[0]).toURI());
                JarInputStream jarFile = new JarInputStream(new FileInputStream(file));
                while ((e = jarFile.getNextJarEntry()) != null) {
                    Class<?> c;
                    if (!e.getName().startsWith(splitted[1]) || (c = classLoader.loadClass(e.getName().substring(0, e.getName().length() - 6).replace("/", "."))) == null) continue;
                    classes.add(c);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    try {
                        classes.addAll(ClassFinder.findPlugins(file.toURI().toURL(), String.valueOf(packageName) + "." + file.getName(), classLoader));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                } else if (file.getName().endsWith(".class")) {
                    Class<?> c = classLoader.loadClass(String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6));
                    classes.add(c);
                }
                ++n2;
            }
        }
        return classes;
    }
}

