/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import jd.controlling.JDLogger;

public class JDHash {
    public static String HASH_TYPE_MD5 = "md5";
    public static String HASH_TYPE_SHA1 = "SHA-1";

    public static String getFileHash(File arg, String type) {
        if (arg == null || !arg.exists() || arg.isDirectory()) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] b = new byte[1024];
            FileInputStream in = new FileInputStream(arg);
            int n = 0;
            while ((n = ((InputStream)in).read(b)) > -1) {
                md.update(b, 0, n);
            }
            ((InputStream)in).close();
            byte[] digest = md.digest();
            return JDHash.byteArrayToHex(digest);
        }
        catch (Exception e) {
            JDLogger.exception(e);
            return null;
        }
    }

    public static String getStringHash(String arg, String type) {
        if (arg == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] digest = md.digest(arg.getBytes());
            return JDHash.byteArrayToHex(digest);
        }
        catch (Exception e) {
            JDLogger.exception(e);
            return null;
        }
    }

    public static String byteArrayToHex(byte[] digest) {
        StringBuilder ret = new StringBuilder();
        byte[] byArray = digest;
        int n = digest.length;
        int n2 = 0;
        while (n2 < n) {
            byte d = byArray[n2];
            String tmp = Integer.toHexString(d & 0xFF);
            if (tmp.length() < 2) {
                ret.append('0');
            }
            ret.append(tmp);
            ++n2;
        }
        return ret.toString();
    }

    public static String getMD5(String arg) {
        return JDHash.getStringHash(arg, HASH_TYPE_MD5);
    }

    public static String getMD5(File arg) {
        return JDHash.getFileHash(arg, HASH_TYPE_MD5);
    }

    public static String getSHA1(String arg) {
        return JDHash.getStringHash(arg, HASH_TYPE_SHA1);
    }

    public static String getSHA1(File arg) {
        return JDHash.getFileHash(arg, HASH_TYPE_SHA1);
    }
}

