/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.svn;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class ExportEditor
implements ISVNEditor {
    private File myRootDirectory;
    private SVNDeltaProcessor myDeltaProcessor;

    public ExportEditor(File root) {
        this.myRootDirectory = root;
        this.myDeltaProcessor = new SVNDeltaProcessor();
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void openRoot(long revision) throws SVNException {
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        File newDir = new File(this.myRootDirectory, path);
        if (!newDir.exists() && !newDir.mkdirs()) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"error: failed to add the directory ''{0}''.", (Object)newDir);
            throw new SVNException(err);
        }
    }

    public void openDir(String path, long revision) throws SVNException {
    }

    public void changeDirProperty(String name, SVNPropertyValue property) throws SVNException {
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        File file = new File(this.myRootDirectory, path);
        if (file.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"error: exported file ''{0}'' already exists!", (Object)file);
            throw new SVNException(err);
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"error: cannot create new  file ''{0}''", (Object)file);
            throw new SVNException(err);
        }
    }

    public void openFile(String path, long revision) throws SVNException {
    }

    public void changeFileProperty(String path, String name, SVNPropertyValue property) throws SVNException {
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myDeltaProcessor.applyTextDelta(null, new File(this.myRootDirectory, path), false);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
    }

    public void closeDir() throws SVNException {
    }

    public void deleteEntry(String path, long revision) throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void abortEdit() throws SVNException {
    }
}

