/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import java.io.File;
import java.util.ArrayList;
import jd.event.JDBroadcaster;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.JDHash;
import jd.parser.Regex;
import jd.update.Server;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUpdate {
    public static final int DOWNLOAD_SOURCE = 1;
    public static final int ERROR = 2;
    public static final int SERVER_STATS = 3;
    public static final int SUCCESS = 4;
    private static final long WAITTIME_ON_ERROR = 15000L;
    private String localPath;
    private String url;
    private String hash;
    private ArrayList<Server> serverList;
    private Server currentServer;
    private String relURL;
    private File workingDir;
    private JDBroadcaster<MessageListener, MessageEvent> broadcaster;

    public FileUpdate(String serverString, String hash) {
        this.hash = hash;
        serverString = serverString.replace("http://78.143.20.68/update/jd/", "");
        String[] dat = new Regex(serverString, "(.*)\\?(.*)").getRow(0);
        this.relURL = serverString;
        if (dat == null) {
            this.localPath = serverString;
        } else {
            this.localPath = dat[0];
            this.url = dat[1];
        }
        this.initBroadcaster();
    }

    public FileUpdate(String serverString, String hash, File workingdir) {
        this(serverString, hash);
        this.workingDir = workingdir;
        this.relURL = serverString;
        this.initBroadcaster();
    }

    private void initBroadcaster() {
        this.broadcaster = new JDBroadcaster<MessageListener, MessageEvent>(){

            @Override
            protected void fireEvent(MessageListener listener, MessageEvent event) {
                listener.onMessage(event);
            }
        };
    }

    public JDBroadcaster<MessageListener, MessageEvent> getBroadcaster() {
        return this.broadcaster;
    }

    public String toString() {
        return this.localPath;
    }

    public String getRelURL() {
        return this.relURL;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getRawUrl() {
        return this.url;
    }

    public String getRemoteHash() {
        return this.hash;
    }

    public boolean exists() {
        return this.getLocalFile().exists() || this.getLocalTmpFile().exists();
    }

    public boolean equals() {
        if (!this.exists()) {
            return false;
        }
        String localHash = this.getLocalHash();
        if (localHash == null) {
            return false;
        }
        return localHash.equalsIgnoreCase(this.hash);
    }

    private String getLocalHash() {
        if (this.getLocalTmpFile().exists()) {
            return JDHash.getMD5(this.getLocalTmpFile());
        }
        return JDHash.getMD5(this.getLocalFile());
    }

    public File getLocalFile() {
        if (this.workingDir != null) {
            return new File(this.workingDir + this.getLocalPath());
        }
        return JDUtilities.getResourceFile(this.getLocalPath());
    }

    public void reset(ArrayList<Server> availableServers) {
        this.serverList = new ArrayList();
        this.serverList.addAll(availableServers);
    }

    public boolean hasServer() {
        return this.serverList.size() > 0;
    }

    public boolean update(ArrayList<Server> availableServers) {
        Browser br = new Browser();
        br.setReadTimeout(20000);
        br.setConnectTimeout(10000);
        int retry = 0;
        while (retry < 3) {
            if (availableServers == null || availableServers.size() == 0) {
                System.err.println("no downloadsource available!");
                return false;
            }
            this.reset(availableServers);
            while (this.hasServer()) {
                String url = this.getURL();
                File tmpFile = this.workingDir != null ? new File(this.workingDir + this.getLocalPath() + ".tmp") : JDUtilities.getResourceFile(String.valueOf(this.getLocalPath()) + ".tmp");
                tmpFile.delete();
                File updatetmp = this.getLocalTmpFile();
                if (updatetmp.exists() && JDHash.getMD5(updatetmp).equals(this.hash)) {
                    return true;
                }
                this.getLocalTmpFile().delete();
                url = url.contains("?") ? String.valueOf(url) + "&r=" + System.currentTimeMillis() : String.valueOf(url) + "?r=" + System.currentTimeMillis();
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 1, "Downloadsource: " + url));
                long startTime = System.currentTimeMillis();
                URLConnectionAdapter con = null;
                int response = -1;
                try {
                    con = br.openGetConnection(url);
                    long endTime = System.currentTimeMillis();
                    response = con.getResponseCode();
                    this.currentServer.setRequestTime(endTime - startTime);
                }
                catch (Exception e) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Connection error"));
                    this.currentServer.setRequestTime(100000L);
                    try {
                        con.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.errorWait();
                    continue;
                }
                if (response != 200) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Connection error " + response));
                    this.currentServer.setRequestTime(500000L);
                    try {
                        con.disconnect();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.errorWait();
                    continue;
                }
                try {
                    Browser.download(tmpFile, con);
                }
                catch (Exception e) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Connection broken"));
                    this.currentServer.setRequestTime(100000L);
                    try {
                        con.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.errorWait();
                    continue;
                }
                try {
                    con.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 3, this.currentServer + " requesttimeAVG=" + this.currentServer.getRequestTime()));
                String downloadedHash = JDHash.getMD5(tmpFile);
                if (downloadedHash != null && downloadedHash.equalsIgnoreCase(this.hash)) {
                    boolean ret;
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 4, "Hash OK"));
                    this.getLocalTmpFile().delete();
                    if (tmpFile.getName().startsWith("tinyupdate")) {
                        this.getLocalFile().delete();
                        ret = tmpFile.renameTo(this.getLocalFile());
                    } else {
                        ret = tmpFile.renameTo(this.getLocalTmpFile());
                    }
                    if (ret) {
                        return ret;
                    }
                    this.getLocalTmpFile().getParentFile().mkdirs();
                    ret = tmpFile.renameTo(this.getLocalTmpFile());
                    if (!ret) {
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Rename failed"));
                        this.errorWait();
                        continue;
                    }
                    return ret;
                }
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Hash Failed"));
                if (this.hasServer()) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Retry"));
                } else {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Updateserver down"));
                }
                tmpFile.delete();
                this.errorWait();
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++retry;
        }
        return false;
    }

    private void errorWait() {
        try {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Server Busy. Wait 15 Seconds"));
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public File getLocalTmpFile() {
        if (this.workingDir != null) {
            return new File(new File(this.workingDir, "update") + this.getLocalPath());
        }
        return new File(JDUtilities.getResourceFile("update") + this.getLocalPath());
    }

    private String mergeUrl(String server, String file) {
        String ret = "";
        ret = server.endsWith("/") || file.startsWith("/") ? String.valueOf(server) + file : String.valueOf(server) + "/" + file;
        ret = ret.replaceAll("//", "/");
        return ret.replaceAll("http:/", "http://");
    }

    private String getURL() {
        Server serv;
        if (this.url == null || this.url.trim().length() == 0) {
            Server serv2;
            this.currentServer = serv2 = Server.selectServer(this.serverList);
            this.serverList.remove(serv2);
            return this.mergeUrl(serv2.getPath(), this.relURL);
        }
        if (this.url.toLowerCase().startsWith("http://")) {
            return this.url;
        }
        this.currentServer = serv = Server.selectServer(this.serverList);
        this.serverList.remove(serv);
        return this.mergeUrl(serv.getPath(), this.url);
    }

    public boolean needsRestart() {
        String hash = JDHash.getMD5(this.getLocalTmpFile());
        if (hash == null) {
            return false;
        }
        return hash.equalsIgnoreCase(hash);
    }
}

