/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JProgressBar;
import jd.config.CFGConfig;
import jd.config.SubConfiguration;
import jd.controlling.ProgressController;
import jd.event.JDBroadcaster;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.http.Browser;
import jd.nutils.JDHash;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.nutils.zip.UnZip;
import jd.parser.Regex;
import jd.update.FileUpdate;
import jd.update.Main;
import jd.update.Server;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUpdater
implements Serializable {
    public static final int DO_UPDATE_FAILED = 40;
    public static final int DO_UPDATE_FILE = 42;
    public static final int DO_UPDATE_SUCCESS = 43;
    private static HashMap<String, File> fileMap;
    private static final int NEW_FILE = 0;
    public static HashMap<String, FileUpdate> PLUGIN_LIST;
    private static final long serialVersionUID = 1946622313175234371L;
    private static final int UPDATE_FILE = 1;
    public static final String[] UPDATE_MIRROR;
    private static final String UPDATE_ZIP_LOCAL_PATH = "tmp/update.zip";
    private Browser br;
    private String[] branches;
    private transient JDBroadcaster<MessageListener, MessageEvent> broadcaster;
    private Integer errors = 0;
    private boolean ignorePlugins = true;
    private StringBuilder logger;
    private boolean OSFilter = true;
    private JProgressBar progressload = null;
    public byte[] sum;
    private File workingdir;

    static {
        PLUGIN_LIST = null;
        UPDATE_MIRROR = new String[]{"http://update0.jdownloader.org/", "http://update0.jdownloader.org/", "http://update1.jdownloader.org/", "http://update2.jdownloader.org/"};
    }

    public static SubConfiguration getConfig(String string) {
        SubConfiguration guiConfig = SubConfiguration.getConfig(string);
        CFGConfig gui = CFGConfig.getConfig(string);
        if (gui.getProperties().size() != 0) {
            guiConfig.getProperties().putAll(gui.getProperties());
            gui.getProperties().clear();
            gui.save();
        }
        guiConfig.save();
        return guiConfig;
    }

    public static HashMap<String, File> getFileMap() {
        return fileMap;
    }

    public static HashMap<String, FileUpdate> getPluginList() {
        if (PLUGIN_LIST == null && JDUtilities.getResourceFile("tmp/hashlist.lst").exists()) {
            PLUGIN_LIST = new HashMap();
            WebUpdater updater = new WebUpdater();
            updater.ignorePlugins(false);
            updater.parseFileList(JDUtilities.getResourceFile("tmp/hashlist.lst"), null, PLUGIN_LIST);
        }
        return PLUGIN_LIST;
    }

    public static void randomizeMirrors() {
        ArrayList<String> mirrors = new ArrayList<String>();
        String[] stringArray = UPDATE_MIRROR;
        int n = UPDATE_MIRROR.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            mirrors.add(m);
            ++n2;
        }
        int i = 0;
        while (i < UPDATE_MIRROR.length) {
            WebUpdater.UPDATE_MIRROR[i] = (String)mirrors.remove((int)(Math.random() * (double)(UPDATE_MIRROR.length - 1 - i)));
            ++i;
        }
    }

    public WebUpdater() {
        WebUpdater.randomizeMirrors();
        this.logger = new StringBuilder();
        this.br = new Browser();
        this.br.setReadTimeout(20000);
        this.br.setConnectTimeout(10000);
        this.errors = 0;
        this.initBroadcaster();
    }

    public void filterAvailableUpdates(ArrayList<FileUpdate> files) {
        Iterator<FileUpdate> it = files.iterator();
        while (it.hasNext()) {
            FileUpdate file = it.next();
            if (new File(file.getLocalFile(), ".noupdate").exists()) {
                System.out.println("User excluded. " + file.getLocalPath());
                it.remove();
                continue;
            }
            if (!file.exists()) {
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 0, "New: " + WebUpdater.formatPathReadable(file.getLocalPath())));
                continue;
            }
            if (!file.equals()) {
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 1, "Update: " + WebUpdater.formatPathReadable(file.getLocalPath())));
                continue;
            }
            it.remove();
        }
    }

    public ArrayList<FileUpdate> getAvailableFiles() throws Exception {
        HashMap<String, FileUpdate> plugins = new HashMap<String, FileUpdate>();
        ArrayList<FileUpdate> ret = new ArrayList<FileUpdate>();
        this.updateAvailableServers();
        this.loadUpdateList();
        this.parseFileList(fileMap.get("hashlist.lst"), ret, plugins);
        return ret;
    }

    private ArrayList<Server> getAvailableServers() {
        if (Main.clone) {
            return Main.clonePrefix;
        }
        try {
            return (ArrayList)WebUpdater.getConfig("WEBUPDATE").getProperty("SERVERLIST");
        }
        catch (Exception e) {
            WebUpdater.getConfig("WEBUPDATE").setProperty("SERVERLIST", new ArrayList());
            return (ArrayList)WebUpdater.getConfig("WEBUPDATE").getProperty("SERVERLIST");
        }
    }

    public String getBranch() {
        String latestBranch = this.getLatestBranch();
        String ret = WebUpdater.getConfig("WEBUPDATE").getStringProperty("BRANCH");
        if (ret == null) {
            ret = latestBranch;
        }
        WebUpdater.getConfig("WEBUPDATE").setProperty("BRANCHINUSE", ret);
        WebUpdater.getConfig("WEBUPDATE").save();
        if (ret == null || ret.contains("%") || ret.contains(" ")) {
            return null;
        }
        return ret;
    }

    private String[] getBranches() {
        ArrayList<String> mirrors = new ArrayList<String>();
        String[] stringArray = UPDATE_MIRROR;
        int n = UPDATE_MIRROR.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            mirrors.add(m);
            ++n2;
        }
        int i = 0;
        while (i < UPDATE_MIRROR.length) {
            String serv = (String)mirrors.remove((int)(Math.random() * (double)(UPDATE_MIRROR.length - 1 - i)));
            try {
                this.br.getPage(String.valueOf(serv) + "branches.lst");
                if (this.br.getRequest().getHttpConnection().isOK()) {
                    this.branches = Regex.getLines(this.br.toString());
                    System.out.println("Found branches on " + serv + ":\r\n" + this.br);
                    return this.branches;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorWait();
            }
            System.err.println("No branches found on " + serv);
            ++i;
        }
        this.branches = new String[0];
        return this.branches;
    }

    public JDBroadcaster<MessageListener, MessageEvent> getBroadcaster() {
        return this.broadcaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrors() {
        Integer n = this.errors;
        synchronized (n) {
            return this.errors;
        }
    }

    private synchronized String getLatestBranch() {
        if (this.branches == null) {
            this.getBranches();
        }
        if (this.branches == null || this.branches.length == 0) {
            return null;
        }
        return this.branches[0];
    }

    private String getListPath(int trycount) {
        if (this.getBranch() == null) {
            return null;
        }
        return String.valueOf(UPDATE_MIRROR[trycount % UPDATE_MIRROR.length]) + this.getBranch() + "_server.list";
    }

    public StringBuilder getLogger() {
        return this.logger;
    }

    public boolean getOSFilter() {
        return this.OSFilter;
    }

    public File getWorkingdir() {
        return this.workingdir;
    }

    private String getZipMD5(int trycount) {
        return String.valueOf(UPDATE_MIRROR[trycount % UPDATE_MIRROR.length]) + this.getBranch() + "_update.md5";
    }

    private String getZipUrl(int trycount) {
        return String.valueOf(UPDATE_MIRROR[trycount % UPDATE_MIRROR.length]) + this.getBranch() + "_update.zip";
    }

    public void ignorePlugins(boolean b) {
        this.ignorePlugins = b;
    }

    private void initBroadcaster() {
        this.broadcaster = new JDBroadcaster<MessageListener, MessageEvent>(){

            @Override
            protected void fireEvent(MessageListener listener, MessageEvent event) {
                listener.onMessage(event);
            }
        };
    }

    public boolean isIgnorePlugins() {
        return this.ignorePlugins;
    }

    private void loadUpdateList() throws Exception {
        int trycount = 0;
        while (trycount < 10) {
            block8: {
                try {
                    String localHash;
                    String path = this.getZipMD5(trycount);
                    if (path == null) break block8;
                    String serverHash = this.br.getPage(String.valueOf(path) + "?t=" + System.currentTimeMillis()).trim();
                    if (!serverHash.equalsIgnoreCase(localHash = JDHash.getMD5(JDUtilities.getResourceFile(UPDATE_ZIP_LOCAL_PATH)))) {
                        path = this.getZipUrl(trycount);
                        if (path == null) break block8;
                        Browser.download(JDUtilities.getResourceFile(UPDATE_ZIP_LOCAL_PATH), String.valueOf(path) + "?t=" + System.currentTimeMillis());
                    }
                    UnZip u = new UnZip(JDUtilities.getResourceFile(UPDATE_ZIP_LOCAL_PATH), JDUtilities.getResourceFile("tmp/"));
                    File[] efiles = u.extract();
                    fileMap = new HashMap();
                    File[] fileArray = efiles;
                    int n = efiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        fileMap.put(f.getName().toLowerCase(), f);
                        ++n2;
                    }
                    return;
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ++trycount;
        }
        throw new Exception("could not load Updatelist");
    }

    private void parseFileList(File file, ArrayList<FileUpdate> ret, HashMap<String, FileUpdate> plugins) {
        String source = JDIO.getLocalFile(file);
        String pattern = "[\r\n\\;]*([^=]+)\\=(.*?)\\;";
        if (source == null) {
            System.out.println("filelist nicht verf\u00fcpgbar");
            return;
        }
        String[] os = new String[]{"windows", "mac", "linux"};
        String[][] matches = new Regex(source, pattern).getMatches();
        ArrayList<Byte> sum = new ArrayList<Byte>();
        String[][] stringArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            String[] m = stringArray[n2];
            FileUpdate entry = this.workingdir != null ? new FileUpdate(m[0], m[1], this.workingdir) : new FileUpdate(m[0], m[1]);
            entry.getBroadcaster().addAllListener(this.broadcaster.getListener());
            sum.add((byte)entry.getRemoteHash().charAt(0));
            if (entry.getLocalPath().endsWith(".class")) {
                plugins.put(entry.getLocalPath(), entry);
            }
            if (!entry.getLocalPath().endsWith(".class") || !this.ignorePlugins) {
                boolean osFound = false;
                boolean correctOS = false;
                String[] stringArray2 = os;
                int n3 = os.length;
                int n4 = 0;
                while (n4 < n3) {
                    String element = stringArray2[n4];
                    String url = entry.getRawUrl();
                    if (url == null) {
                        url = entry.getRelURL();
                    }
                    if (url.toLowerCase().indexOf(element) >= 0) {
                        osFound = true;
                        if (OSDetector.getOSString().toLowerCase().indexOf(element) >= 0) {
                            correctOS = true;
                        }
                    }
                    ++n4;
                }
                if (this.OSFilter) {
                    if (!osFound || osFound && correctOS) {
                        if (ret != null) {
                            ret.add(entry);
                        }
                    } else {
                        String url = entry.getRawUrl();
                        if (url == null) {
                            url = entry.getRelURL();
                        }
                        System.out.println("OS Filter: " + url);
                    }
                } else if (ret != null) {
                    ret.add(entry);
                }
            }
            ++n2;
        }
        this.sum = new byte[sum.size()];
        int ii = 0;
        int i = sum.size() - 1;
        while (i >= 0) {
            this.sum[ii++] = (Byte)sum.get(i);
            --i;
        }
        PLUGIN_LIST = plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetErrors() {
        Integer n = this.errors;
        synchronized (n) {
            this.errors = 0;
        }
    }

    public void setDownloadProgress(JProgressBar progresslist) {
        this.progressload = progresslist;
    }

    public void setIgnorePlugins(boolean ignorePlugins) {
        this.ignorePlugins = ignorePlugins;
    }

    public void setLogger(StringBuilder log) {
        this.logger = log;
    }

    public void setOSFilter(boolean filter) {
        this.OSFilter = filter;
    }

    public void setWorkingdir(File workingdir) {
        this.workingdir = workingdir;
    }

    public String toString() {
        return "Updater";
    }

    private ArrayList<Server> updateAvailableServers() {
        boolean fnf = true;
        int trycount = 0;
        while (trycount < 10) {
            block14: {
                try {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 0, "Update Downloadmirrors"));
                    String path = this.getListPath(trycount);
                    if (path == null) break block14;
                    this.br.getPage(String.valueOf(path) + "?t=" + System.currentTimeMillis());
                    if ((long)this.br.getRequest().getHttpConnection().getResponseCode() != 404L) {
                        fnf = false;
                    }
                    if ((long)this.br.getRequest().getHttpConnection().getResponseCode() != 200L) {
                        this.errorWait();
                        break block14;
                    }
                    int total = 0;
                    ArrayList<Server> servers = new ArrayList<Server>();
                    boolean auto = false;
                    String[][] stringArray = this.br.getRegex("(\\-?\\d+)\\:([^\r^\n]*)").getMatches();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] match = stringArray[n2];
                        Server serv = new Server(Integer.parseInt(match[0]), match[1].trim());
                        servers.add(serv);
                        if (serv.getPercent() < 0) {
                            auto = true;
                        }
                        total += serv.getPercent();
                        ++n2;
                    }
                    for (Server s : servers) {
                        if (auto) {
                            s.setPercent(-1);
                        } else {
                            s.setPercent(s.getPercent() * 100 / total);
                        }
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 0, "Updateserver: " + s));
                    }
                    if (servers.size() > 0) {
                        WebUpdater.getConfig("WEBUPDATE").setProperty("SERVERLIST", servers);
                    }
                    return this.getAvailableServers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errorWait();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ++trycount;
        }
        if (fnf && WebUpdater.getConfig("WEBUPDATE").getStringProperty("BRANCH") != null) {
            System.err.println("Branch " + WebUpdater.getConfig("WEBUPDATE").getStringProperty("BRANCH") + " is not available any more. Reset to default");
            WebUpdater.getConfig("WEBUPDATE").setProperty("BRANCH", null);
            WebUpdater.getConfig("WEBUPDATE").save();
            return this.updateAvailableServers();
        }
        return this.getAvailableServers();
    }

    private void errorWait() {
        try {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, "Server Busy. Wait 10 Seconds"));
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void updateFile(Vector<String> file) throws IOException {
        String[] tmp = file.elementAt(0).split("\\?");
        this.broadcaster.fireEvent(new MessageEvent((Object)this, 42, String.format("Download %s to %s", WebUpdater.formatPathReadable(tmp[1]), WebUpdater.formatPathReadable(JDUtilities.getResourceFile(tmp[0]).getAbsolutePath()))));
        Browser.download(JDUtilities.getResourceFile(tmp[0]), tmp[0]);
    }

    public void updateFiles(ArrayList<FileUpdate> files, ProgressController prg) throws IOException {
        if (this.progressload != null) {
            this.progressload.setMaximum(files.size());
        }
        int i = 0;
        if (prg != null) {
            prg.addToMax(files.size());
        }
        for (FileUpdate file : files) {
            block12: {
                try {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 0, String.format("Update %s", WebUpdater.formatPathReadable(file.getLocalPath()))));
                    if (this.updateUpdatefile(file)) {
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 43, WebUpdater.formatPathReadable(file.toString())));
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 43, "Successfull"));
                    } else {
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, WebUpdater.formatPathReadable(file.toString())));
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, "Failed"));
                        if (this.progressload != null) {
                            this.progressload.setForeground(Color.RED);
                        }
                        if (prg != null) {
                            prg.setColor(Color.RED);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, e.getLocalizedMessage()));
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, WebUpdater.formatPathReadable(file.toString())));
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, "Failed"));
                    if (this.progressload != null) {
                        this.progressload.setForeground(Color.RED);
                    }
                    if (prg == null) break block12;
                    prg.setColor(Color.RED);
                }
            }
            ++i;
            if (this.progressload != null) {
                this.progressload.setValue(i);
            }
            if (prg == null) continue;
            prg.increase(1L);
        }
        if (this.progressload != null) {
            this.progressload.setValue(100);
        }
    }

    public static String formatPathReadable(String localPath) {
        localPath = localPath.replace(".class", "-Plugin");
        localPath = localPath.replace(".jar", "-Module");
        localPath = localPath.replace("plugins/decrypter/.*", "Decrypter-Plugin");
        return localPath;
    }

    public boolean updateUpdatefile(FileUpdate file) {
        if (file.update(this.getAvailableServers())) {
            if (file.getLocalTmpFile().getName().endsWith(".extract")) {
                UnZip u = new UnZip(file.getLocalTmpFile(), file.getLocalTmpFile().getParentFile());
                u.setOverwrite(false);
                try {
                    File[] efiles = u.extract();
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 43, "Extracted " + file.getLocalTmpFile().getName() + ": " + efiles.length + " files"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        this.errors = this.errors + 1;
        return false;
    }
}

