/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.StringReader;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import jd.controlling.JDLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CLRLoader {
    static Logger logger = JDLogger.getLogger();

    public static String[] createLiveHeader(String CLR) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setValidating(false);
            InputSource inSource = new InputSource(new StringReader(CLR));
            Document doc = factory.newDocumentBuilder().parse(inSource);
            NodeList nodes = doc.getFirstChild().getChildNodes();
            String routerName = null;
            StringBuilder hlh = new StringBuilder();
            hlh.append("[[[HSRC]]]");
            hlh.append("\r\n");
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                short type = node.getNodeType();
                if (type == 1) {
                    if (node.getNodeName().equalsIgnoreCase("router")) {
                        routerName = node.getAttributes().getNamedItem("name").getNodeValue().trim();
                    } else if (node.getNodeName().equalsIgnoreCase("command")) {
                        hlh.append("    [[[STEP]]]\r\n");
                        hlh.append("        [[[REQUEST]]]\r\n");
                        String method = node.getAttributes().getNamedItem("method").getNodeValue().trim();
                        String action = node.getAttributes().getNamedItem("action").getNodeValue().trim();
                        String basicauth = null;
                        if (method.equalsIgnoreCase("post")) {
                            hlh.append("            " + method.toUpperCase() + " /" + action + " HTTP/1.1" + "\r\n");
                        } else if (!method.equalsIgnoreCase("get")) {
                            if (method.equalsIgnoreCase("auth")) {
                                basicauth = action;
                            } else {
                                logger.severe("UNKNOWN METHOD: " + method);
                            }
                        }
                        NodeList params = node.getChildNodes();
                        HashMap<String, String> p = new HashMap<String, String>();
                        String post = "";
                        int ii = 0;
                        while (ii < params.getLength()) {
                            Node param = params.item(ii);
                            try {
                                String key = param.getAttributes().getNamedItem("name").getNodeValue();
                                String value = param.getAttributes().getNamedItem("value").getNodeValue();
                                p.put(key, value);
                                post = post.equals("") ? String.valueOf(post) + key + "=" + value : String.valueOf(post) + "&" + key + "=" + value;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++ii;
                        }
                        if (method.equalsIgnoreCase("post")) {
                            hlh.append("            Host: %%%routerip%%%\r\n");
                            CLRLoader.inputAuth(hlh, basicauth);
                            hlh.append("\r\n");
                            hlh.append(post.trim());
                            hlh.append("\r\n");
                        } else {
                            if (post.equals("")) {
                                hlh.append("            " + method.toUpperCase() + " /" + action + " HTTP/1.1" + "\r\n");
                            } else {
                                hlh.append("            " + method.toUpperCase() + " /" + action + "?" + post.trim() + " HTTP/1.1" + "\r\n");
                            }
                            hlh.append("            Host: %%%routerip%%%\r\n");
                            CLRLoader.inputAuth(hlh, basicauth);
                        }
                        hlh.append("        [[[/REQUEST]]]\r\n");
                        hlh.append("    [[[/STEP]]]\r\n");
                    } else {
                        logger.info("UNKNOWN  command: " + node.getNodeName());
                    }
                }
                ++i;
            }
            hlh.append("[[[/HSRC]]]");
            return new String[]{routerName, hlh.toString()};
        }
        catch (Exception e) {
            JDLogger.exception(e);
            return null;
        }
    }

    private static void inputAuth(StringBuilder hlh, String basicauth) {
        if (basicauth != null) {
            if (basicauth.equalsIgnoreCase("")) {
                hlh.append("            Authorization: Basic %%%basicauth%%%\r\n");
            } else {
                logger.severe("UNKNOWN AUTH TYPE");
            }
        }
    }
}

