/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import jd.nutils.svn.Subversion;
import jd.parser.Regex;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class Changelog {
    private static final String SVN_SRC = "svn://svn.jdownloader.org/jdownloader/trunk/src";

    public static void main(String[] args) throws SVNException {
        new Changelog().load();
    }

    private void load() throws SVNException {
        Subversion svn = new Subversion(SVN_SRC);
        ArrayList<SVNLogEntry> entries = svn.getChangeset(6193, 7450);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (SVNLogEntry logEntry : entries) {
            System.out.println("---------------------------------------------");
            System.out.println("revision: " + logEntry.getRevision());
            System.out.println("author: " + logEntry.getAuthor());
            System.out.println("date: " + logEntry.getDate());
            System.out.println("log message: " + logEntry.getMessage());
            if (logEntry.getChangedPaths().size() <= 0) continue;
            System.out.println();
            System.out.println("changed paths:");
            Set changedPathsSet = logEntry.getChangedPaths().keySet();
            Iterator changedPaths = changedPathsSet.iterator();
            while (changedPaths.hasNext()) {
                Object c;
                SVNLogEntryPath entryPath = (SVNLogEntryPath)logEntry.getChangedPaths().get(changedPaths.next());
                System.out.println(" " + entryPath.getType() + " " + entryPath.getPath() + (entryPath.getCopyPath() != null ? " (from " + entryPath.getCopyPath() + " revision " + entryPath.getCopyRevision() + ")" : ""));
                if (map.containsKey(entryPath.getPath())) {
                    c = (Change)map.get(entryPath.getPath());
                } else {
                    c = new Change(entryPath.getPath());
                    if (!(((Change)c).getName().contains("test") || ((Change)c).getName().contains("Test") || ((Change)c).getCategory() == null || ((Change)c).getCategory().trim().length() <= 2 || ((Change)c).getName().trim().length() <= 3 || logEntry.getMessage() == null || logEntry.getMessage().trim().length() <= 0 || logEntry.getMessage().contains("Merged") || logEntry.getMessage().contains("*nochangelog*"))) {
                        map.put(entryPath.getPath(), c);
                    }
                }
                ((Change)c).setType(entryPath.getType());
                ((Change)c).addRevision(logEntry.getRevision());
                ((Change)c).addAuthor(logEntry.getAuthor());
            }
        }
        System.out.println("^Type^Module^Package^Author(s)^Info^");
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Change next = (Change)it.next().getValue();
            String changesets = "[[changeset/";
            int i = 0;
            for (Long ref : next.getRevisions()) {
                if (i > 0) {
                    changesets = String.valueOf(changesets) + "-";
                }
                changesets = String.valueOf(changesets) + ref;
                ++i;
            }
            changesets = String.valueOf(changesets) + "|Details]]";
            changesets = changesets.trim();
            String authors = "";
            for (String a : next.getAuthors()) {
                if (authors.contains(a)) continue;
                authors = String.valueOf(authors) + " " + a;
            }
            authors = authors.trim();
            if (next.getCategory().equalsIgnoreCase("Decrypter")) continue;
            System.out.println("|" + next.getType() + "|" + next.getName() + "|" + next.getCategory() + "|" + authors + "|" + changesets + "|");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Change {
        private ArrayList<Long> revisions;
        private ArrayList<String> authors;
        private char type = (char)77;
        private String category = "";
        private String name;

        public ArrayList<Long> getRevisions() {
            return this.revisions;
        }

        public ArrayList<String> getAuthors() {
            return this.authors;
        }

        public String getCategory() {
            return this.category;
        }

        public String getType() {
            switch (this.type) {
                case 'M': {
                    return "Update";
                }
                case 'A': {
                    return "New";
                }
            }
            return String.valueOf(this.type);
        }

        public Change(String path) {
            this.revisions = new ArrayList();
            this.authors = new ArrayList();
            String name = new Regex(path, ".*/(.+)").getMatch(0);
            name = name.replaceAll("([a-z0-9])([A-Z][a-z0-9])", "$1 $2").trim();
            this.name = name = name.replaceAll("(.*)\\..+", "$1");
            this.category = this.getCategory(path);
            if (this.category == null) {
                this.category = "";
            }
        }

        public String getName() {
            return this.name;
        }

        private String getCategory(String path) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("/trunk/src/jd/plugins/optional", "Addon");
            map.put("/trunk/src/jd/plugins/decrypt", "Decrypter");
            map.put("/trunk/src/jd/plugins/host", "Hoster");
            map.put("/trunk/src/jd/gui", "GUI");
            map.put("/trunk/src/jd/captcha", "OCR");
            map.put("/trunk/ressourcen/jd/languages", "Translation");
            map.put("/trunk/src/jd/controlling/reconnect", "Reconnect");
            map.put("/trunk/src/jd/controlling", "Controlling");
            while (path != null) {
                if (!map.containsKey(path = new Regex(path, "(.*)/.*?").getMatch(0))) continue;
                return (String)map.get(path);
            }
            return null;
        }

        public void setType(char type) {
            if (type != 'M') {
                this.type = type;
            }
        }

        public void addAuthor(String author) {
            this.authors.add(author);
        }

        public void addRevision(long revision) {
            this.revisions.add(revision);
        }
    }
}

