/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Email {
    private String host;
    private String user;
    private String pass;
    private String senderEmail;
    private String senderName;

    public Email(String smtpHost) {
        this.host = smtpHost;
    }

    public Email(String smtpHost, String user, String pass) {
        this.host = smtpHost;
        this.user = user;
        this.pass = pass;
    }

    public void setSender(String email, String name) {
        this.senderEmail = email;
        this.senderName = name;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void sendEmail(String email, String name, String subject, String message) throws MessagingException {
        Session session;
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        if (this.user != null) {
            MailAuthenticator auth = new MailAuthenticator(this.user, this.pass);
            props.put("mail.smtp.auth", "true");
            session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        } else {
            session = Session.getDefaultInstance((Properties)props);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.senderEmail));
        msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
        msg.setSentDate(new Date());
        msg.setSubject(subject);
        msg.setContent((Object)message, "text/plain");
        Transport.send((Message)msg);
    }

    static class MailAuthenticator
    extends Authenticator {
        private final String user;
        private final String password;

        public MailAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

